/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.option;

import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.option.OptionChain;
import com.dxfeed.ipf.option.OptionSeries;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class OptionChainsBuilder<T> {
    String product = "";
    String underlying = "";
    OptionSeries<T> series = new OptionSeries();
    String cfi = "";
    double strike;
    private final Map<String, OptionChain<T>> chains = new HashMap<String, OptionChain<T>>();

    public static OptionChainsBuilder<InstrumentProfile> build(Collection<InstrumentProfile> instruments) {
        OptionChainsBuilder<InstrumentProfile> ocb = new OptionChainsBuilder<InstrumentProfile>();
        for (InstrumentProfile ip : instruments) {
            if (!"OPTION".equals(ip.getType())) continue;
            ocb.setProduct(ip.getProduct());
            ocb.setUnderlying(ip.getUnderlying());
            ocb.setExpiration(ip.getExpiration());
            ocb.setLastTrade(ip.getLastTrade());
            ocb.setMultiplier(ip.getMultiplier());
            ocb.setSPC(ip.getSPC());
            ocb.setAdditionalUnderlyings(ip.getAdditionalUnderlyings());
            ocb.setMMY(ip.getMMY());
            ocb.setOptionType(ip.getOptionType());
            ocb.setExpirationStyle(ip.getExpirationStyle());
            ocb.setSettlementStyle(ip.getSettlementStyle());
            ocb.setCFI(ip.getCFI());
            ocb.setStrike(ip.getStrike());
            ocb.addOption(ip);
        }
        return ocb;
    }

    public void setProduct(String product) {
        this.product = product == null || product.isEmpty() ? "" : product;
    }

    public void setUnderlying(String underlying) {
        this.underlying = underlying == null || underlying.isEmpty() ? "" : underlying;
    }

    public void setExpiration(int expiration) {
        this.series.expiration = expiration;
    }

    public void setLastTrade(int lastTrade) {
        this.series.lastTrade = lastTrade;
    }

    public void setMultiplier(double multiplier) {
        this.series.multiplier = multiplier;
    }

    public void setSPC(double spc) {
        this.series.spc = spc;
    }

    public void setAdditionalUnderlyings(String additionalUnderlyings) {
        this.series.additionalUnderlyings = additionalUnderlyings == null || additionalUnderlyings.isEmpty() ? "" : additionalUnderlyings;
    }

    public void setMMY(String mmy) {
        this.series.mmy = mmy == null || mmy.isEmpty() ? "" : mmy;
    }

    public void setOptionType(String optionType) {
        this.series.optionType = optionType == null || optionType.isEmpty() ? "" : optionType;
    }

    public void setExpirationStyle(String expirationStyle) {
        this.series.expirationStyle = expirationStyle == null || expirationStyle.isEmpty() ? "" : expirationStyle;
    }

    public void setSettlementStyle(String settlementStyle) {
        this.series.settlementStyle = settlementStyle == null || settlementStyle.isEmpty() ? "" : settlementStyle;
    }

    public void setCFI(String cfi) {
        this.cfi = cfi == null || cfi.isEmpty() ? "" : cfi;
        this.series.cfi = this.cfi.length() < 2 ? this.cfi : this.cfi.charAt(0) + "X" + this.cfi.substring(2);
    }

    public void setStrike(double strike) {
        this.strike = strike;
    }

    public void addOption(T option) {
        boolean isCall = this.cfi.startsWith("OC");
        if (!isCall && !this.cfi.startsWith("OP")) {
            return;
        }
        if (this.series.expiration == 0) {
            return;
        }
        if (Double.isNaN(this.strike) || Double.isInfinite(this.strike)) {
            return;
        }
        if (this.product.length() > 0) {
            this.getOrCreateChain(this.product).addOption(this.series, isCall, this.strike, option);
        }
        if (this.underlying.length() > 0) {
            this.getOrCreateChain(this.underlying).addOption(this.series, isCall, this.strike, option);
        }
    }

    private OptionChain<T> getOrCreateChain(String symbol) {
        OptionChain<T> chain = this.chains.get(symbol);
        if (chain == null) {
            chain = new OptionChain(symbol);
            this.chains.put(symbol, chain);
        }
        return chain;
    }

    public Map<String, OptionChain<T>> getChains() {
        return this.chains;
    }
}

