/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.option;

import com.dxfeed.ipf.option.OptionSeries;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

public final class OptionChain<T>
implements Cloneable {
    private final String symbol;
    private final SortedMap<OptionSeries<T>, OptionSeries<T>> seriesMap = new TreeMap<OptionSeries<T>, OptionSeries<T>>();

    OptionChain(String symbol) {
        this.symbol = symbol;
    }

    public OptionChain<T> clone() {
        OptionChain<T> clone = new OptionChain<T>(this.symbol);
        for (OptionSeries<T> series : this.seriesMap.values()) {
            Object seriesClone = series.clone();
            clone.seriesMap.put((OptionSeries<T>)seriesClone, (OptionSeries<T>)seriesClone);
        }
        return clone;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public SortedSet<OptionSeries<T>> getSeries() {
        return (SortedSet)this.seriesMap.keySet();
    }

    void addOption(OptionSeries<T> series, boolean isCall, double strike, T option) {
        OptionSeries<T> os = (OptionSeries<T>)this.seriesMap.get(series);
        if (os == null) {
            os = new OptionSeries<T>(series);
            this.seriesMap.put(os, os);
        }
        os.addOption(isCall, strike, option);
    }
}

