/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.live;

import com.devexperts.io.StreamCompression;
import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import com.devexperts.util.TimeUtil;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileReader;
import com.dxfeed.ipf.impl.InstrumentProfileParser;
import com.dxfeed.ipf.live.InstrumentProfileCollector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstrumentProfileConnection {
    private static final Logging log = Logging.getLogging(InstrumentProfileConnection.class);
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String LIVE_PROP_KEY = "X-Live";
    private static final String LIVE_PROP_REQUEST_YES = "yes";
    private static final String LIVE_PROP_RESPONSE = "provided";
    private static final Pattern UPDATE_PATTERN = Pattern.compile("(.*)\\[update=([^\\]]+)\\]");
    private static final int UPDATE_BATCH_SIZE = SystemProperties.getIntProperty(InstrumentProfileConnection.class, "updateBatchSize", 1000, 1, 0x3FFFFFFF);
    private static final long UPDATE_PERIOD = TimePeriod.valueOf(SystemProperties.getProperty(InstrumentProfileConnection.class, "updatePeriod", "1m")).getTime();
    private final String address;
    private final InstrumentProfileCollector collector;
    private final List<PropertyChangeListener> stateChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private volatile State state = State.NOT_CONNECTED;
    private volatile long lastModified;
    private volatile long updatePeriod;
    private volatile boolean completed;
    private Thread handlerThread;

    public static InstrumentProfileConnection createConnection(String address, InstrumentProfileCollector collector) {
        return new InstrumentProfileConnection(address, collector);
    }

    private InstrumentProfileConnection(String address, InstrumentProfileCollector collector) {
        long updatePeriod = UPDATE_PERIOD;
        Matcher update = UPDATE_PATTERN.matcher(address);
        if (update.matches()) {
            address = update.group(1);
            updatePeriod = TimePeriod.valueOf(update.group(2)).getTime();
        }
        this.address = address;
        this.collector = collector;
        this.setUpdatePeriod(updatePeriod);
    }

    public String getAddress() {
        return this.address;
    }

    public long getUpdatePeriod() {
        return this.updatePeriod;
    }

    public void setUpdatePeriod(long updatePeriod) {
        if (updatePeriod < 0L) {
            throw new IllegalArgumentException();
        }
        this.updatePeriod = updatePeriod;
    }

    public State getState() {
        return this.state;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public synchronized void start() {
        if (this.state != State.NOT_CONNECTED) {
            throw new IllegalStateException("Invalid state " + (Object)((Object)this.state));
        }
        String name = this.toString();
        log.info("[" + name + "] Starting instrument profiles connection");
        this.handlerThread = new Thread((Runnable)new Handler(), name);
        this.handlerThread.start();
        this.setStateAndFireChangeEvent(State.CONNECTING);
    }

    public synchronized void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        if (this.state != State.NOT_CONNECTED) {
            this.handlerThread.interrupt();
            this.handlerThread = null;
        }
        this.setStateAndFireChangeEvent(State.CLOSED);
    }

    public void addStateChangeListener(PropertyChangeListener listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(PropertyChangeListener listener) {
        this.stateChangeListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilCompleted(long timeout, TimeUnit unit) {
        final CountDownLatch latch = new CountDownLatch(1);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (InstrumentProfileConnection.this.getState() == State.COMPLETED || InstrumentProfileConnection.this.getState() == State.CLOSED) {
                    latch.countDown();
                }
            }
        };
        this.addStateChangeListener(listener);
        try {
            if (this.completed) {
                boolean bl = true;
                return bl;
            }
            if (this.getState() == State.CLOSED) {
                boolean bl = false;
                return bl;
            }
            latch.await(timeout, unit);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.removeStateChangeListener(listener);
        }
        return this.completed;
    }

    public String toString() {
        return "IPC:" + LogUtil.hideCredentials(this.address);
    }

    private synchronized void makeConnected() {
        if (this.state == State.CONNECTING) {
            this.setStateAndFireChangeEvent(State.CONNECTED);
        }
    }

    private synchronized void makeComplete() {
        if (this.state == State.CONNECTED) {
            this.completed = true;
            this.setStateAndFireChangeEvent(State.COMPLETED);
        }
    }

    private void setStateAndFireChangeEvent(State newState) {
        State oldState = this.state;
        this.state = newState;
        if (this.stateChangeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, "state", (Object)oldState, (Object)newState);
        for (PropertyChangeListener listener : this.stateChangeListeners) {
            try {
                listener.propertyChange(event);
            }
            catch (Throwable t) {
                log.error("Exception in InstrumentProfileConnection state change listener", t);
            }
        }
    }

    static /* synthetic */ String access$100(InstrumentProfileConnection x0) {
        return x0.address;
    }

    private class Handler
    implements Runnable {
        private final List<InstrumentProfile> instrumentProfiles = new ArrayList<InstrumentProfile>();
        private final String url = InstrumentProfileReader.resolveSourceURL(InstrumentProfileConnection.access$100(InstrumentProfileConnection.this));
        private final Set<Object> oldGenerations = new HashSet<Object>();
        private Object newGeneration;
        private boolean supportsLive;

        private Handler() {
        }

        @Override
        public void run() {
            long retryPeriod = 1000L;
            while (InstrumentProfileConnection.this.state != State.CLOSED) {
                try {
                    this.checkAndDownload();
                    Thread.sleep(InstrumentProfileConnection.this.updatePeriod);
                }
                catch (InterruptedException ignored) {
                    return;
                }
                catch (Throwable t) {
                    log.error("Exception while reading instrument profiles", t);
                    try {
                        Thread.sleep(retryPeriod);
                        retryPeriod = Math.min(retryPeriod * 2L, InstrumentProfileConnection.this.updatePeriod);
                    }
                    catch (InterruptedException ignored) {
                        return;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkAndDownload() throws Exception {
            URLConnection connection = URLInputStream.openConnection(this.url);
            connection.setRequestProperty(InstrumentProfileConnection.LIVE_PROP_KEY, InstrumentProfileConnection.LIVE_PROP_REQUEST_YES);
            if (InstrumentProfileConnection.this.lastModified != 0L && !this.supportsLive && connection instanceof HttpURLConnection) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(InstrumentProfileConnection.HTTP_DATE_FORMAT, Locale.US);
                dateFormat.setTimeZone(TimeUtil.getTimeZoneGmt());
                connection.setRequestProperty(InstrumentProfileConnection.IF_MODIFIED_SINCE, dateFormat.format(new Date(InstrumentProfileConnection.this.lastModified)));
                if (((HttpURLConnection)connection).getResponseCode() == 304) {
                    return;
                }
            }
            try (InputStream in = connection.getInputStream();){
                URLInputStream.checkConnectionResponseCode(connection);
                long time = connection.getLastModified();
                if (time != 0L && time == InstrumentProfileConnection.this.lastModified) {
                    return;
                }
                log.info("Downloading instrument profiles");
                this.supportsLive = InstrumentProfileConnection.LIVE_PROP_RESPONSE.equals(connection.getHeaderField(InstrumentProfileConnection.LIVE_PROP_KEY));
                if (this.supportsLive) {
                    log.info("Live updates streaming connection has been open");
                }
                InstrumentProfileConnection.this.makeConnected();
                try (InputStream decompressedIn = StreamCompression.detectCompressionByHeaderAndDecompress(in);){
                    int count = this.process(decompressedIn);
                    InstrumentProfileConnection.this.lastModified = time;
                    log.info("Downloaded " + count + " instrument profiles" + (InstrumentProfileConnection.this.lastModified == 0L ? "" : " (last modified on " + TimeFormat.DEFAULT.format(InstrumentProfileConnection.this.lastModified) + ")"));
                }
                finally {
                    if (this.newGeneration != null) {
                        this.oldGenerations.add(this.newGeneration);
                        this.newGeneration = null;
                    }
                }
            }
        }

        private int process(InputStream in) throws IOException {
            InstrumentProfile ip;
            int count = 0;
            InstrumentProfileParser parser = new InstrumentProfileParser(in).whenFlush(this::flush).whenComplete(this::complete);
            while ((ip = parser.next()) != null) {
                ++count;
                this.instrumentProfiles.add(ip);
                if (this.instrumentProfiles.size() < UPDATE_BATCH_SIZE) continue;
                this.flush();
            }
            this.flush();
            if (!this.supportsLive) {
                this.complete();
            }
            return count;
        }

        void flush() {
            if (this.instrumentProfiles.isEmpty()) {
                return;
            }
            if (this.newGeneration == null) {
                this.newGeneration = new Object();
            }
            InstrumentProfileConnection.this.collector.updateInstrumentProfiles(this.instrumentProfiles, this.newGeneration);
            this.instrumentProfiles.clear();
        }

        void complete() {
            this.flush();
            InstrumentProfileConnection.this.collector.removeGenerations(this.oldGenerations);
            this.oldGenerations.clear();
            InstrumentProfileConnection.this.makeComplete();
        }
    }

    public static enum State {
        NOT_CONNECTED,
        CONNECTING,
        CONNECTED,
        COMPLETED,
        CLOSED;

    }
}

