/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.live;

import com.devexperts.logging.Logging;
import com.devexperts.util.IndexedSet;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileType;
import com.dxfeed.ipf.live.InstrumentProfileUpdateListener;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class InstrumentProfileCollector {
    private static final Logging log = Logging.getLogging(InstrumentProfileCollector.class);
    private final IndexedSet<String, Entry> entriesBySymbol = IndexedSet.create(entry -> entry.symbol);
    private final CopyOnWriteArrayList<Agent> agents = new CopyOnWriteArrayList();
    private volatile Executor executor = InstrumentProfileCollector.createAgentExecutor();
    private Entry tail = new Entry();
    private long lastUpdateTime = System.currentTimeMillis();
    private long lastReportedTime;

    public final synchronized long getLastUpdateTime() {
        this.lastReportedTime = this.lastUpdateTime;
        return this.lastReportedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateInstrumentProfile(InstrumentProfile ip) {
        boolean updated = false;
        InstrumentProfileCollector instrumentProfileCollector = this;
        synchronized (instrumentProfileCollector) {
            if (this.updateInstrumentProfileImpl(ip, null)) {
                this.updateTimeImpl();
                updated = true;
            }
        }
        if (updated) {
            this.notifyAgents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateInstrumentProfiles(List<InstrumentProfile> ips, Object generation) {
        if (ips.isEmpty()) {
            return;
        }
        boolean updated = false;
        InstrumentProfileCollector instrumentProfileCollector = this;
        synchronized (instrumentProfileCollector) {
            for (InstrumentProfile ip : ips) {
                if (!this.updateInstrumentProfileImpl(ip, generation)) continue;
                updated = true;
            }
            if (updated) {
                this.updateTimeImpl();
            }
        }
        if (updated) {
            this.notifyAgents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeGenerations(Set<Object> generations) {
        if (Objects.requireNonNull(generations, "generations").isEmpty()) {
            return;
        }
        boolean removed = false;
        InstrumentProfileCollector instrumentProfileCollector = this;
        synchronized (instrumentProfileCollector) {
            Iterator<Entry> it = this.entriesBySymbol.iterator();
            while (it.hasNext()) {
                Entry entry = it.next();
                if (entry.generation == null || !generations.contains(entry.generation)) continue;
                it.remove();
                this.removeEntryImpl(entry);
                removed = true;
            }
            if (removed) {
                this.updateTimeImpl();
            }
        }
        if (removed) {
            this.notifyAgents();
        }
    }

    public final Iterable<InstrumentProfile> view() {
        return () -> new Iterator<InstrumentProfile>(){
            private final Iterator entryIterator;
            {
                this.entryIterator = InstrumentProfileCollector.this.entriesBySymbol.concurrentIterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public InstrumentProfile next() {
                return ((Entry)this.entryIterator.next()).ip;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public final void addUpdateListener(InstrumentProfileUpdateListener listener) {
        Agent agent = new Agent(Objects.requireNonNull(listener, "listener"));
        this.agents.add(agent);
        this.executor.execute(() -> agent.update());
    }

    public final void removeUpdateListener(InstrumentProfileUpdateListener listener) {
        for (Agent agent : this.agents) {
            if (agent.listener != listener) continue;
            this.agents.remove(agent);
            return;
        }
    }

    protected InstrumentProfile copyInstrumentProfile(InstrumentProfile ip) {
        return ip;
    }

    private void updateTimeImpl() {
        this.lastUpdateTime = Math.max(System.currentTimeMillis(), this.lastReportedTime + 1000L);
    }

    private void notifyAgents() {
        Executor executor = this.executor;
        for (Agent agent : this.agents) {
            executor.execute(() -> agent.update());
        }
    }

    private boolean updateInstrumentProfileImpl(InstrumentProfile ip, Object generation) {
        String symbol = Objects.requireNonNull(ip, "ip").getSymbol();
        Entry oldEntry = this.entriesBySymbol.getByKey(symbol);
        if (oldEntry != null && oldEntry.ip != ip && oldEntry.ip.equals(ip)) {
            oldEntry.generation = generation;
            return false;
        }
        ip = this.copyInstrumentProfile(ip);
        Entry newEntry = new Entry(symbol, ip);
        newEntry.generation = generation;
        if (ip.getType().equals(InstrumentProfileType.REMOVED.name())) {
            if (oldEntry == null) {
                return false;
            }
            this.entriesBySymbol.remove(oldEntry);
        } else {
            this.entriesBySymbol.put(newEntry);
        }
        this.linkUpdatedEntryImpl(newEntry);
        if (oldEntry != null) {
            oldEntry.old = true;
        }
        return true;
    }

    private void removeEntryImpl(Entry entry) {
        InstrumentProfile removed = new InstrumentProfile();
        removed.setSymbol(entry.symbol);
        removed.setType(InstrumentProfileType.REMOVED.name());
        this.linkUpdatedEntryImpl(new Entry(entry.symbol, removed));
        entry.old = true;
    }

    private void linkUpdatedEntryImpl(Entry entry) {
        Entry oldTail = this.tail;
        oldTail.next = entry;
        this.tail = entry;
    }

    private String debugString(InstrumentProfile ip) {
        return ip + " @" + Integer.toHexString(System.identityHashCode(ip));
    }

    protected static Executor createAgentExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r, "IPC-Executor");
            t.setDaemon(true);
            return t;
        });
    }

    private class Agent
    implements Iterator<InstrumentProfile> {
        final InstrumentProfileUpdateListener listener;
        Entry nextEntry;
        Entry tailEntry;
        Iterator<Entry> snapshotIterator;

        Agent(InstrumentProfileUpdateListener listener) {
            this.listener = listener;
            this.tailEntry = InstrumentProfileCollector.this.tail;
            this.snapshotIterator = InstrumentProfileCollector.this.entriesBySymbol.concurrentIterator();
        }

        private void ensureNext() {
            Entry entry;
            if (this.nextEntry != null) {
                return;
            }
            if (this.snapshotIterator != null) {
                if (this.snapshotIterator.hasNext()) {
                    this.nextEntry = this.snapshotIterator.next();
                    return;
                }
                this.snapshotIterator = null;
            }
            do {
                if ((entry = this.tailEntry.next) == null) {
                    return;
                }
                this.tailEntry = entry;
            } while (entry.old);
            this.nextEntry = entry;
        }

        private void update() {
            try {
                if (this.hasNext()) {
                    this.listener.instrumentProfilesUpdated(this);
                }
            }
            catch (Throwable t) {
                log.error("Exception in InstrumentProfileUpdateListener", t);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            this.ensureNext();
            return this.nextEntry != null;
        }

        @Override
        public synchronized InstrumentProfile next() {
            this.ensureNext();
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            InstrumentProfile result = this.nextEntry.ip;
            this.nextEntry = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Entry {
        final String symbol;
        final InstrumentProfile ip;
        Object generation;
        volatile Entry next;
        volatile boolean old;

        Entry() {
            this(null, null);
            this.old = true;
        }

        Entry(String symbol, InstrumentProfile ip) {
            this.symbol = symbol;
            this.ip = ip;
        }
    }
}

