/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.impl;

import com.devexperts.io.CSVFormatException;
import com.devexperts.io.CSVReader;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileField;
import com.dxfeed.ipf.InstrumentProfileFormatException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class InstrumentProfileParser
implements Closeable {
    private final Map<String, Format> formats = new HashMap<String, Format>();
    private final CSVReader reader;
    private final List<String> tmpFields = new ArrayList<String>();
    private String prevF0 = "";
    private Runnable flushHandler;
    private Runnable completeHandler;
    private Function<String, String> internalizer = Function.identity();

    public InstrumentProfileParser(InputStream in) {
        this.reader = new CSVReader(new InputStreamReader(in, StandardCharsets.UTF_8));
    }

    public InstrumentProfileParser whenFlush(Runnable command) {
        this.flushHandler = command;
        return this;
    }

    public InstrumentProfileParser whenComplete(Runnable command) {
        this.completeHandler = command;
        return this;
    }

    public InstrumentProfileParser withIntern(Function<String, String> internFunction) {
        this.internalizer = internFunction == null ? Function.identity() : internFunction;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public InstrumentProfile next() throws IOException {
        try {
            Format format;
            int line;
            while (true) {
                line = this.reader.getLineNumber();
                String f0 = this.reader.readField(this.prevF0);
                format = this.formats.get(f0);
                if (format == null) {
                    if (!this.parseSpecial(f0, line)) continue;
                    return null;
                }
                if (!f0.isEmpty() || !this.reader.isRecordEnded()) break;
                this.reader.readRecord(this.tmpFields);
            }
            this.prevF0 = format.type;
            InstrumentProfile ip = new InstrumentProfile();
            ip.setType(format.type);
            for (int i = 0; i < format.n; ++i) {
                String oldValue = format.fieldValues[i];
                String newValue = this.reader.readField(oldValue);
                if (newValue == null) {
                    throw new InstrumentProfileFormatException("wrong number of fields (line " + line + ")");
                }
                if (newValue.isEmpty()) continue;
                try {
                    InstrumentProfileField ipf = format.standardFields[i];
                    if (newValue != oldValue) {
                        if (ipf == null || !ipf.isNumericField()) {
                            newValue = this.intern(newValue);
                        }
                        format.fieldValues[i] = newValue;
                    }
                    if (ipf != null) {
                        ipf.setField(ip, newValue);
                        continue;
                    }
                    ip.setField(format.fields[i], newValue);
                    continue;
                }
                catch (Exception e) {
                    throw new InstrumentProfileFormatException(e.getMessage() + " (line " + line + ")");
                }
            }
            if (this.reader.readRecord(format.leftoverFields) != 0) {
                throw new InstrumentProfileFormatException("wrong number of fields (line " + line + ")");
            }
            return ip;
        }
        catch (CSVFormatException e) {
            throw new InstrumentProfileFormatException(e.getMessage());
        }
    }

    private boolean parseSpecial(String f0, int line) throws IOException {
        if (f0 == null) {
            return this.reader.readRecord(this.tmpFields) < 0;
        }
        if (f0.startsWith("#")) {
            this.parseMeta(f0);
        } else {
            this.checkUndefinedFormat(f0, line);
        }
        return false;
    }

    private void checkUndefinedFormat(String f0, int line) throws IOException {
        int n = this.reader.readRecord(this.tmpFields);
        if (f0.isEmpty() && n <= 0) {
            return;
        }
        throw new InstrumentProfileFormatException("undefined format " + (f0.isEmpty() ? "\"\"" : f0) + " (line " + line + ")");
    }

    private void parseMeta(String f0) throws IOException {
        if (f0.endsWith("::=TYPE")) {
            this.parseFormat(f0);
            return;
        }
        this.reader.readRecord(this.tmpFields);
        if (f0.equals("##")) {
            this.onFlush();
        } else if (f0.equals("##COMPLETE")) {
            this.onComplete();
        }
    }

    private void parseFormat(String f0) throws IOException {
        int n;
        String type = f0.substring("#".length(), f0.length() - "::=TYPE".length());
        Format format = this.formats.get(type);
        if (format != null) {
            while (this.tmpFields.size() < format.n) {
                this.tmpFields.add("");
            }
            for (int i = 0; i < format.n; ++i) {
                this.tmpFields.set(i, format.fields[i]);
            }
        }
        if ((n = this.reader.readRecord(this.tmpFields)) < 0) {
            return;
        }
        if (format != null && n == format.n) {
            boolean sameFormat = true;
            for (int i = 0; sameFormat && i < n; ++i) {
                sameFormat = this.tmpFields.get(i).equals(format.fields[i]);
            }
            if (sameFormat) {
                return;
            }
        }
        if (type.startsWith("#") && type.endsWith("::=TYPE") || type.equals("##") || type.equals("##COMPLETE")) {
            throw new InstrumentProfileFormatException("forbidden format " + type);
        }
        if (type.isEmpty() && n == 0) {
            return;
        }
        format = new Format(type, n, this.tmpFields);
        this.formats.put(format.type, format);
    }

    protected String intern(String value) {
        return this.internalizer.apply(value);
    }

    protected void onFlush() {
        if (this.flushHandler != null) {
            this.flushHandler.run();
        }
    }

    protected void onComplete() {
        if (this.completeHandler != null) {
            this.completeHandler.run();
        }
    }

    private static class Format {
        final String type;
        final int n;
        final String[] fields;
        final InstrumentProfileField[] standardFields;
        final String[] fieldValues;
        final List<String> leftoverFields = new ArrayList<String>();

        Format(String type, int n, List<String> tmpFields) {
            this.type = type.intern();
            this.n = n;
            this.fields = new String[n];
            this.standardFields = new InstrumentProfileField[n];
            this.fieldValues = new String[n];
            for (int i = 0; i < n; ++i) {
                this.fields[i] = tmpFields.get(i).intern();
                this.standardFields[i] = InstrumentProfileField.find(this.fields[i]);
                this.fieldValues[i] = "";
            }
        }

        public String toString() {
            return this.type + "=" + Arrays.toString(this.fields);
        }
    }
}

