/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.impl;

import com.devexperts.io.CSVWriter;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileField;
import com.dxfeed.ipf.InstrumentProfileType;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class InstrumentProfileComposer
implements Closeable {
    private static final InstrumentProfileField[] FIELDS = InstrumentProfileField.values();
    private static final String REMOVED_TYPE = InstrumentProfileType.REMOVED.name();
    private final Map<String, EnumSet<InstrumentProfileField>> enumFormats = new HashMap<String, EnumSet<InstrumentProfileField>>();
    private final Map<String, TreeSet<String>> customFormats = new HashMap<String, TreeSet<String>>();
    private final List<String> types = new ArrayList<String>();
    private final CSVWriter writer;

    public InstrumentProfileComposer(OutputStream out) {
        this.writer = new CSVWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void compose(List<InstrumentProfile> profiles, boolean skipRemoved) throws IOException {
        this.captureTypes(profiles);
        this.writeFormats(profiles, skipRemoved);
        this.writeProfiles(profiles, skipRemoved);
        this.types.clear();
        this.writer.flush();
    }

    public void composeNewLine() throws IOException {
        this.writer.writeRecord(new String[]{""});
        this.writer.flush();
    }

    public void composeFlush() throws IOException {
        this.writer.writeRecord(new String[]{"##"});
        this.composeNewLine();
    }

    public void composeComplete() throws IOException {
        this.writer.writeRecord(new String[]{"##COMPLETE"});
        this.composeNewLine();
    }

    private void captureTypes(List<InstrumentProfile> profiles) {
        this.types.clear();
        for (InstrumentProfile ip : profiles) {
            this.types.add(ip.getType());
        }
    }

    private void writeFormats(List<InstrumentProfile> profiles, boolean skipRemoved) throws IOException {
        TreeSet<String> updated = new TreeSet<String>();
        for (int i = 0; i < profiles.size(); ++i) {
            String type = this.types.get(i);
            if (REMOVED_TYPE.equals(type) && skipRemoved) continue;
            InstrumentProfile ip = profiles.get(i);
            EnumSet<InstrumentProfileField> enumFormat = this.enumFormats.get(type);
            TreeSet<String> customFormat = this.customFormats.get(type);
            if (enumFormat == null) {
                updated.add(type);
                enumFormat = EnumSet.of(InstrumentProfileField.SYMBOL);
                this.enumFormats.put(type, enumFormat);
                customFormat = new TreeSet();
                this.customFormats.put(type, customFormat);
            }
            if (REMOVED_TYPE.equals(type)) continue;
            for (InstrumentProfileField ipf : FIELDS) {
                if (ipf == InstrumentProfileField.TYPE || ipf.getField(ip).length() <= 0 || !enumFormat.add(ipf)) continue;
                updated.add(type);
            }
            if (!ip.addNonEmptyCustomFieldNames(customFormat)) continue;
            updated.add(type);
        }
        for (String type : updated) {
            this.writeFormat(type);
        }
    }

    private void writeFormat(String type) throws IOException {
        this.writer.writeField("#" + type + "::=TYPE");
        for (InstrumentProfileField instrumentProfileField : this.enumFormats.get(type)) {
            this.writer.writeField(instrumentProfileField.name());
        }
        for (String string : this.customFormats.get(type)) {
            this.writer.writeField(string);
        }
        this.writer.writeRecord(null);
    }

    private void writeProfiles(List<InstrumentProfile> profiles, boolean skipRemoved) throws IOException {
        for (int i = 0; i < profiles.size(); ++i) {
            String type = this.types.get(i);
            if (REMOVED_TYPE.equals(type) && skipRemoved) continue;
            InstrumentProfile ip = profiles.get(i);
            this.writeProfile(type, ip);
        }
    }

    private void writeProfile(String type, InstrumentProfile ip) throws IOException {
        this.writer.writeField(type);
        for (InstrumentProfileField instrumentProfileField : this.enumFormats.get(type)) {
            this.writer.writeField(instrumentProfileField.getField(ip));
        }
        for (String string : this.customFormats.get(type)) {
            this.writer.writeField(ip.getField(string));
        }
        this.writer.writeRecord(null);
    }
}

