/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf;

import com.devexperts.io.UncloseableOutputStream;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.impl.InstrumentProfileComposer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class InstrumentProfileWriter {
    public void writeToFile(String file, List<InstrumentProfile> profiles) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.write(out, file, profiles);
        }
    }

    public void write(OutputStream out, String name, List<InstrumentProfile> profiles) throws IOException {
        if (name.toLowerCase().endsWith(".zip")) {
            name = name.substring(Math.max(name.lastIndexOf(47), name.lastIndexOf(92)) + 1, name.length() - ".zip".length());
            try (ZipOutputStream zip = new ZipOutputStream(new UncloseableOutputStream(out));){
                zip.putNextEntry(new ZipEntry(name));
                this.write(zip, name, profiles);
                zip.closeEntry();
            }
            return;
        }
        if (name.toLowerCase().endsWith(".gz")) {
            try (GZIPOutputStream gzip = new GZIPOutputStream(new UncloseableOutputStream(out));){
                this.write(gzip, profiles);
            }
            return;
        }
        this.write(out, profiles);
    }

    public void write(OutputStream out, List<InstrumentProfile> profiles) throws IOException {
        InstrumentProfileComposer composer = new InstrumentProfileComposer(out);
        composer.compose(profiles, false);
        composer.composeComplete();
    }
}

