/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf;

import java.util.HashMap;

public enum InstrumentProfileType {
    CURRENCY,
    FOREX,
    BOND,
    INDEX,
    STOCK,
    ETF,
    MUTUAL_FUND,
    MONEY_MARKET_FUND,
    PRODUCT,
    FUTURE,
    OPTION,
    WARRANT,
    CFD,
    SPREAD,
    OTHER,
    REMOVED;

    private static final HashMap<String, InstrumentProfileType> MAP;

    public static InstrumentProfileType find(String name) {
        return MAP.get(name);
    }

    public static int compareTypes(String type1, String type2) {
        InstrumentProfileType t1 = InstrumentProfileType.find(type1);
        InstrumentProfileType t2 = InstrumentProfileType.find(type2);
        if (t1 == null) {
            return t2 == null ? type1.compareTo(type2) : 1;
        }
        if (t2 == null) {
            return -1;
        }
        return t1.compareTo(t2);
    }

    static {
        MAP = new HashMap();
        for (InstrumentProfileType ipt : InstrumentProfileType.values()) {
            MAP.put(ipt.name(), ipt);
        }
    }
}

