/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf;

import com.devexperts.io.StreamCompression;
import com.devexperts.io.URLInputStream;
import com.devexperts.io.UncloseableInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.util.LogUtil;
import com.devexperts.util.SystemProperties;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileFormatException;
import com.dxfeed.ipf.impl.InstrumentProfileParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public class InstrumentProfileReader {
    private static final Logging log = Logging.getLogging(InstrumentProfileReader.class);
    private static final String LIVE_PROP_KEY = "X-Live";
    private static final String LIVE_PROP_REQUEST_NO = "no";
    private long lastModified;
    protected boolean wasComplete;
    private static final String COMPLETE_ERROR = "error";
    private static final String COMPLETE_WARN = "warn";
    private static final String COMPLETE_IGNORE = "ignore";
    private static final String DEFAULT_COMPLETE_STRATEGY = "warn";
    private static final String COMPLETE_PROPERTY = "com.dxfeed.ipf.complete";
    private static final String COMPLETE_STRATEGY = InstrumentProfileReader.initializeCompleteStrategy();

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean wasComplete() {
        return this.wasComplete;
    }

    public List<InstrumentProfile> readFromFile(String address) throws IOException {
        return this.readFromFile(address, null, null);
    }

    public List<InstrumentProfile> readFromFile(String address, String user, String password) throws IOException {
        String url = InstrumentProfileReader.resolveSourceURL(address);
        URLConnection connection = URLInputStream.openConnection(URLInputStream.resolveURL(url), user, password);
        connection.setRequestProperty(LIVE_PROP_KEY, LIVE_PROP_REQUEST_NO);
        try (InputStream in = connection.getInputStream();){
            URLInputStream.checkConnectionResponseCode(connection);
            this.lastModified = connection.getLastModified();
            List<InstrumentProfile> list = this.read(in, address);
            return list;
        }
    }

    public static String resolveSourceURL(String address) {
        if (address.indexOf(58) > 0 && address.indexOf(47) < 0) {
            try {
                int port;
                int j = address.indexOf(63);
                String query = "";
                if (j >= 0) {
                    query = address.substring(j);
                    address = address.substring(0, j);
                }
                if ((port = Integer.parseInt(address.substring(address.indexOf(58) + 1))) > 0 && port < 65536) {
                    address = "http://" + address + "/ipf/all.ipf.gz" + query;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return address;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final List<InstrumentProfile> read(InputStream in, String address) throws IOException {
        this.wasComplete = true;
        try (InputStream decompressed = StreamCompression.detectCompressionByHeaderAndDecompress(new UncloseableInputStream(in));){
            List<InstrumentProfile> profiles = this.read(decompressed);
            if (!this.wasComplete) {
                this.handleIncomplete(address);
            }
            List<InstrumentProfile> list = profiles;
            return list;
        }
        catch (IOException e) {
            this.wasComplete = false;
            throw e;
        }
    }

    @Deprecated
    public final List<InstrumentProfile> readCompressed(InputStream in) throws IOException {
        return this.read(in, "<unknown stream>");
    }

    @Deprecated
    public List<InstrumentProfile> read(InputStream in) throws IOException {
        InstrumentProfile ip;
        this.wasComplete = false;
        ArrayList<InstrumentProfile> profiles = new ArrayList<InstrumentProfile>();
        InstrumentProfileParser parser = new InstrumentProfileParser(in).withIntern(this::intern).whenComplete(() -> {
            this.wasComplete = true;
        });
        while ((ip = parser.next()) != null) {
            profiles.add(ip);
        }
        return profiles;
    }

    protected String intern(String value) {
        return value;
    }

    protected void handleIncomplete(String address) throws InstrumentProfileFormatException {
        switch (COMPLETE_STRATEGY) {
            case "error": {
                throw new InstrumentProfileFormatException("##COMPLETE tag is missing in IPF " + LogUtil.hideCredentials(address));
            }
            case "warn": {
                log.warn("##COMPLETE tag is missing in IPF " + LogUtil.hideCredentials(address));
                break;
            }
        }
    }

    private static String initializeCompleteStrategy() {
        String value;
        switch (value = SystemProperties.getProperty(COMPLETE_PROPERTY, "warn")) {
            case "error": 
            case "warn": 
            case "ignore": {
                return value;
            }
        }
        log.warn("Unknown value for com.dxfeed.ipf.complete property: " + value);
        return "warn";
    }
}

