/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf;

import com.dxfeed.ipf.ArrayMap;
import com.dxfeed.ipf.InstrumentProfileField;
import com.dxfeed.ipf.InstrumentProfileType;
import java.io.Serializable;
import java.util.Collection;

public final class InstrumentProfile
implements Comparable<InstrumentProfile>,
Serializable {
    private static final long serialVersionUID = 0L;
    private String type = "";
    private String symbol = "";
    private String description = "";
    private String localSymbol = "";
    private String localDescription = "";
    private String country = "";
    private String opol = "";
    private String exchangeData = "";
    private String exchanges = "";
    private String currency = "";
    private String baseCurrency = "";
    private String cfi = "";
    private String isin = "";
    private String sedol = "";
    private String cusip = "";
    private int icb;
    private int sic;
    private double multiplier;
    private String product = "";
    private String underlying = "";
    private double spc;
    private String additionalUnderlyings = "";
    private String mmy = "";
    private int expiration;
    private int lastTrade;
    private double strike;
    private String optionType = "";
    private String expirationStyle = "";
    private String settlementStyle = "";
    private String priceIncrements = "";
    private String tradingHours = "";
    private String[] customFields;

    public InstrumentProfile() {
    }

    public InstrumentProfile(InstrumentProfile ip) {
        this.type = ip.type;
        this.symbol = ip.symbol;
        this.description = ip.description;
        this.localSymbol = ip.localSymbol;
        this.localDescription = ip.localDescription;
        this.country = ip.country;
        this.opol = ip.opol;
        this.exchangeData = ip.exchangeData;
        this.exchanges = ip.exchanges;
        this.currency = ip.currency;
        this.baseCurrency = ip.baseCurrency;
        this.cfi = ip.cfi;
        this.isin = ip.isin;
        this.sedol = ip.sedol;
        this.cusip = ip.cusip;
        this.icb = ip.icb;
        this.sic = ip.sic;
        this.multiplier = ip.multiplier;
        this.product = ip.product;
        this.underlying = ip.underlying;
        this.spc = ip.spc;
        this.additionalUnderlyings = ip.additionalUnderlyings;
        this.mmy = ip.mmy;
        this.expiration = ip.expiration;
        this.lastTrade = ip.lastTrade;
        this.strike = ip.strike;
        this.optionType = ip.optionType;
        this.expirationStyle = ip.expirationStyle;
        this.settlementStyle = ip.settlementStyle;
        this.priceIncrements = ip.priceIncrements;
        this.tradingHours = ip.tradingHours;
        String[] customFields = ip.customFields;
        this.customFields = customFields == null || ArrayMap.isEmpty(customFields) ? null : (String[])customFields.clone();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type == null || type.isEmpty() ? "" : type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol == null || symbol.isEmpty() ? "" : symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description == null || description.isEmpty() ? "" : description;
    }

    public String getLocalSymbol() {
        return this.localSymbol;
    }

    public void setLocalSymbol(String localSymbol) {
        this.localSymbol = localSymbol == null || localSymbol.isEmpty() ? "" : localSymbol;
    }

    public String getLocalDescription() {
        return this.localDescription;
    }

    public void setLocalDescription(String localDescription) {
        this.localDescription = localDescription == null || localDescription.isEmpty() ? "" : localDescription;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country == null || country.isEmpty() ? "" : country;
    }

    public String getOPOL() {
        return this.opol;
    }

    public void setOPOL(String opol) {
        this.opol = opol == null || opol.isEmpty() ? "" : opol;
    }

    public String getExchangeData() {
        return this.exchangeData;
    }

    public void setExchangeData(String exchangeData) {
        this.exchangeData = exchangeData == null || exchangeData.isEmpty() ? "" : exchangeData;
    }

    public String getExchanges() {
        return this.exchanges;
    }

    public void setExchanges(String exchanges) {
        this.exchanges = exchanges == null || exchanges.isEmpty() ? "" : exchanges;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null || currency.isEmpty() ? "" : currency;
    }

    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    public void setBaseCurrency(String baseCurrency) {
        this.baseCurrency = baseCurrency == null || baseCurrency.isEmpty() ? "" : baseCurrency;
    }

    public String getCFI() {
        return this.cfi;
    }

    public void setCFI(String cfi) {
        this.cfi = cfi == null || cfi.isEmpty() ? "" : cfi;
    }

    public String getISIN() {
        return this.isin;
    }

    public void setISIN(String isin) {
        this.isin = isin == null || isin.isEmpty() ? "" : isin;
    }

    public String getSEDOL() {
        return this.sedol;
    }

    public void setSEDOL(String sedol) {
        this.sedol = sedol == null || sedol.isEmpty() ? "" : sedol;
    }

    public String getCUSIP() {
        return this.cusip;
    }

    public void setCUSIP(String cusip) {
        this.cusip = cusip == null || cusip.isEmpty() ? "" : cusip;
    }

    public int getICB() {
        return this.icb;
    }

    public void setICB(int icb) {
        this.icb = icb;
    }

    public int getSIC() {
        return this.sic;
    }

    public void setSIC(int sic) {
        this.sic = sic;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product == null || product.isEmpty() ? "" : product;
    }

    public String getUnderlying() {
        return this.underlying;
    }

    public void setUnderlying(String underlying) {
        this.underlying = underlying == null || underlying.isEmpty() ? "" : underlying;
    }

    public double getSPC() {
        return this.spc;
    }

    public void setSPC(double spc) {
        this.spc = spc;
    }

    public String getAdditionalUnderlyings() {
        return this.additionalUnderlyings;
    }

    public void setAdditionalUnderlyings(String additionalUnderlyings) {
        this.additionalUnderlyings = additionalUnderlyings == null || additionalUnderlyings.isEmpty() ? "" : additionalUnderlyings;
    }

    public String getMMY() {
        return this.mmy;
    }

    public void setMMY(String mmy) {
        this.mmy = mmy == null || mmy.isEmpty() ? "" : mmy;
    }

    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    public int getLastTrade() {
        return this.lastTrade;
    }

    public void setLastTrade(int lastTrade) {
        this.lastTrade = lastTrade;
    }

    public double getStrike() {
        return this.strike;
    }

    public void setStrike(double strike) {
        this.strike = strike;
    }

    public String getOptionType() {
        return this.optionType;
    }

    public void setOptionType(String optionType) {
        this.optionType = optionType == null || optionType.isEmpty() ? "" : optionType;
    }

    public String getExpirationStyle() {
        return this.expirationStyle;
    }

    public void setExpirationStyle(String expirationStyle) {
        this.expirationStyle = expirationStyle == null || expirationStyle.isEmpty() ? "" : expirationStyle;
    }

    public String getSettlementStyle() {
        return this.settlementStyle;
    }

    public void setSettlementStyle(String settlementStyle) {
        this.settlementStyle = settlementStyle == null || settlementStyle.isEmpty() ? "" : settlementStyle;
    }

    public String getPriceIncrements() {
        return this.priceIncrements;
    }

    public void setPriceIncrements(String priceIncrements) {
        this.priceIncrements = priceIncrements == null || priceIncrements.isEmpty() ? "" : priceIncrements;
    }

    public String getTradingHours() {
        return this.tradingHours;
    }

    public void setTradingHours(String tradingHours) {
        this.tradingHours = tradingHours == null || tradingHours.isEmpty() ? "" : tradingHours;
    }

    private String getCustomField(String name) {
        String[] customFields = this.customFields;
        return customFields == null ? null : ArrayMap.get(customFields, name);
    }

    private void setCustomField(String name, String value) {
        String[] customFields = this.customFields;
        if (!value.isEmpty()) {
            this.customFields = ArrayMap.put(customFields == null ? new String[4] : customFields, name, value);
        } else if (customFields != null) {
            this.customFields = ArrayMap.putIfKeyPresent(customFields, name, value);
        }
    }

    public String getField(String name) {
        InstrumentProfileField ipf = InstrumentProfileField.find(name);
        if (ipf != null) {
            return ipf.getField(this);
        }
        String value = this.getCustomField(name);
        return value == null ? "" : value;
    }

    public void setField(String name, String value) {
        InstrumentProfileField ipf = InstrumentProfileField.find(name);
        if (ipf != null) {
            ipf.setField(this, value);
        } else {
            this.setCustomField(name, value == null || value.isEmpty() ? "" : value);
        }
    }

    public double getNumericField(String name) {
        InstrumentProfileField ipf = InstrumentProfileField.find(name);
        if (ipf != null) {
            return ipf.getNumericField(this);
        }
        String value = this.getCustomField(name);
        return value == null || value.isEmpty() ? 0.0 : (value.length() == 10 && value.charAt(4) == '-' && value.charAt(7) == '-' ? (double)InstrumentProfileField.parseDate(value) : InstrumentProfileField.parseNumber(value));
    }

    public void setNumericField(String name, double value) {
        InstrumentProfileField ipf = InstrumentProfileField.find(name);
        if (ipf != null) {
            ipf.setNumericField(this, value);
        } else {
            this.setCustomField(name, InstrumentProfileField.formatNumber(value));
        }
    }

    public int getDateField(String name) {
        InstrumentProfileField ipf = InstrumentProfileField.find(name);
        if (ipf != null) {
            return (int)ipf.getNumericField(this);
        }
        String value = this.getCustomField(name);
        return value == null || value.isEmpty() ? 0 : InstrumentProfileField.parseDate(value);
    }

    public void setDateField(String name, int value) {
        InstrumentProfileField ipf = InstrumentProfileField.find(name);
        if (ipf != null) {
            ipf.setNumericField(this, value);
        } else {
            this.setCustomField(name, InstrumentProfileField.formatDate(value));
        }
    }

    public boolean addNonEmptyCustomFieldNames(Collection<? super String> targetFieldNames) {
        boolean updated = false;
        String[] customFields = this.customFields;
        if (customFields != null) {
            int i = customFields.length & 0xFFFFFFFE;
            while ((i -= 2) >= 0) {
                String name = customFields[i];
                String value = customFields[i + 1];
                if (name == null || value == null || value.length() <= 0 || !targetFieldNames.add(name)) continue;
                updated = true;
            }
        }
        return updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstrumentProfile)) {
            return false;
        }
        InstrumentProfile that = (InstrumentProfile)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.symbol.equals(that.symbol)) {
            return false;
        }
        if (!this.description.equals(that.description)) {
            return false;
        }
        if (!this.localSymbol.equals(that.localSymbol)) {
            return false;
        }
        if (!this.localDescription.equals(that.localDescription)) {
            return false;
        }
        if (!this.country.equals(that.country)) {
            return false;
        }
        if (!this.opol.equals(that.opol)) {
            return false;
        }
        if (!this.exchangeData.equals(that.exchangeData)) {
            return false;
        }
        if (!this.exchanges.equals(that.exchanges)) {
            return false;
        }
        if (!this.currency.equals(that.currency)) {
            return false;
        }
        if (!this.baseCurrency.equals(that.baseCurrency)) {
            return false;
        }
        if (!this.cfi.equals(that.cfi)) {
            return false;
        }
        if (!this.isin.equals(that.isin)) {
            return false;
        }
        if (!this.sedol.equals(that.sedol)) {
            return false;
        }
        if (!this.cusip.equals(that.cusip)) {
            return false;
        }
        if (this.icb != that.icb) {
            return false;
        }
        if (this.sic != that.sic) {
            return false;
        }
        if (Double.compare(that.multiplier, this.multiplier) != 0) {
            return false;
        }
        if (!this.product.equals(that.product)) {
            return false;
        }
        if (!this.underlying.equals(that.underlying)) {
            return false;
        }
        if (Double.compare(that.spc, this.spc) != 0) {
            return false;
        }
        if (!this.additionalUnderlyings.equals(that.additionalUnderlyings)) {
            return false;
        }
        if (!this.mmy.equals(that.mmy)) {
            return false;
        }
        if (this.expiration != that.expiration) {
            return false;
        }
        if (this.lastTrade != that.lastTrade) {
            return false;
        }
        if (Double.compare(that.strike, this.strike) != 0) {
            return false;
        }
        if (!this.optionType.equals(that.optionType)) {
            return false;
        }
        if (!this.expirationStyle.equals(that.expirationStyle)) {
            return false;
        }
        if (!this.settlementStyle.equals(that.settlementStyle)) {
            return false;
        }
        if (!this.priceIncrements.equals(that.priceIncrements)) {
            return false;
        }
        if (!this.tradingHours.equals(that.tradingHours)) {
            return false;
        }
        return InstrumentProfile.customEquals(this.customFields, that.customFields);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.symbol.hashCode();
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.localSymbol.hashCode();
        result = 31 * result + this.localDescription.hashCode();
        result = 31 * result + this.country.hashCode();
        result = 31 * result + this.opol.hashCode();
        result = 31 * result + this.exchangeData.hashCode();
        result = 31 * result + this.exchanges.hashCode();
        result = 31 * result + this.currency.hashCode();
        result = 31 * result + this.baseCurrency.hashCode();
        result = 31 * result + this.cfi.hashCode();
        result = 31 * result + this.isin.hashCode();
        result = 31 * result + this.sedol.hashCode();
        result = 31 * result + this.cusip.hashCode();
        result = 31 * result + this.icb;
        result = 31 * result + this.sic;
        long temp = Double.doubleToLongBits(this.multiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.product.hashCode();
        result = 31 * result + this.underlying.hashCode();
        temp = Double.doubleToLongBits(this.spc);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.additionalUnderlyings.hashCode();
        result = 31 * result + this.mmy.hashCode();
        result = 31 * result + this.expiration;
        result = 31 * result + this.lastTrade;
        temp = Double.doubleToLongBits(this.strike);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.optionType.hashCode();
        result = 31 * result + this.expirationStyle.hashCode();
        result = 31 * result + this.settlementStyle.hashCode();
        result = 31 * result + this.priceIncrements.hashCode();
        result = 31 * result + this.tradingHours.hashCode();
        return 31 * result + InstrumentProfile.customHashCode(this.customFields);
    }

    private static int customHashCode(String[] a) {
        if (a == null) {
            return 0;
        }
        int hash = 0;
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            String key = a[i];
            String value = a[i + 1];
            if (key == null || value == null || value.isEmpty()) continue;
            hash += key.hashCode() ^ value.hashCode();
        }
        return hash;
    }

    private static boolean customEquals(String[] a, String[] b) {
        return InstrumentProfile.customContainsAll(b, a) && InstrumentProfile.customContainsAll(a, b);
    }

    private static boolean customContainsAll(String[] a, String[] b) {
        if (b == null) {
            return true;
        }
        int i = b.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            String key = b[i];
            String value = b[i + 1];
            if (key == null || value == null || value.isEmpty() || a != null && value.equals(ArrayMap.get(a, key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(InstrumentProfile ip) {
        int i = InstrumentProfileType.compareTypes(this.type, ip.type);
        if (i != 0) {
            return i;
        }
        i = this.product.compareTo(ip.product);
        if (i != 0) {
            return i;
        }
        i = this.underlying.compareTo(ip.underlying);
        if (i != 0) {
            return i;
        }
        int n = this.lastTrade > ip.lastTrade ? 1 : (i = this.lastTrade < ip.lastTrade ? -1 : 0);
        if (i != 0) {
            return i;
        }
        int n2 = this.strike > ip.strike ? 1 : (i = this.strike < ip.strike ? -1 : 0);
        if (i != 0) {
            return i;
        }
        i = this.symbol.compareTo(ip.symbol);
        if (i != 0) {
            return i;
        }
        return 0;
    }

    public String toString() {
        return this.type + " " + this.symbol;
    }
}

