/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf;

import java.lang.reflect.Array;

final class ArrayMap {
    private static final int GOLDEN_RATIO = -1640531527;

    public static <T> int size(T[] a) {
        int result = 0;
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            if (a[i] == null) continue;
            ++result;
        }
        return result;
    }

    public static <T> boolean isEmpty(T[] a) {
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            if (a[i] == null) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean containsKey(T[] a, T key) {
        int index = ArrayMap.initialIndex(key.hashCode(), a.length);
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            T k = a[index];
            if (k == null) {
                return false;
            }
            if (key.equals(k)) {
                return true;
            }
            if ((index -= 2) >= 0) continue;
            index = (a.length & 0xFFFFFFFE) - 2;
        }
        return false;
    }

    public static <T> T get(T[] a, T key) {
        int index = ArrayMap.initialIndex(key.hashCode(), a.length);
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            T k = a[index];
            if (k == null) {
                return null;
            }
            if (key.equals(k)) {
                return a[index + 1];
            }
            if ((index -= 2) >= 0) continue;
            index = (a.length & 0xFFFFFFFE) - 2;
        }
        return null;
    }

    public static <T> T[] putIfKeyPresent(T[] a, T key, T value) {
        int index = ArrayMap.initialIndex(key.hashCode(), a.length);
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            T k = a[index];
            if (k == null) {
                return a;
            }
            if (key.equals(k)) {
                a[index + 1] = value;
                return a;
            }
            if ((index -= 2) >= 0) continue;
            index = (a.length & 0xFFFFFFFE) - 2;
        }
        return a;
    }

    public static <T> T[] put(T[] a, T key, T value) {
        int result = ArrayMap.putImpl(a, key, value);
        if (result < 0) {
            if (ArrayMap.putImpl(a = ArrayMap.rehash(a), key, value) < 0) {
                throw new IllegalStateException("grow failure");
            }
            return a;
        }
        if (result < a.length >> 1) {
            return ArrayMap.rehash(a);
        }
        return a;
    }

    public static <T> T remove(T[] a, T key) {
        throw new UnsupportedOperationException();
    }

    public static <T> void clear(T[] a) {
        int i = a.length & 0xFFFFFFFE;
        while (--i >= 0) {
            a[i] = null;
        }
    }

    private static int initialIndex(int hash, int length) {
        return (int)(((long)(hash * -1640531527) & 0xFFFFFFFFL) * (long)(length & 0xFFFFFFFE) >>> 32) & 0xFFFFFFFE;
    }

    private static <T> int putImpl(T[] a, T key, T value) {
        int index = ArrayMap.initialIndex(key.hashCode(), a.length);
        int i = a.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            T k = a[index];
            if (k == null) {
                a[index] = key;
                a[index + 1] = value;
                return i;
            }
            if (key.equals(k)) {
                a[index + 1] = value;
                return i;
            }
            if ((index -= 2) >= 0) continue;
            index = (a.length & 0xFFFFFFFE) - 2;
        }
        return -2;
    }

    private static <T> T[] rehash(T[] old) {
        Object[] a = (Object[])Array.newInstance(old.getClass().getComponentType(), Math.max((old.length & 0xFFFFFFFE) * 2, 4));
        int i = old.length & 0xFFFFFFFE;
        while ((i -= 2) >= 0) {
            T k = old[i];
            if (k == null || ArrayMap.putImpl(a, k, old[i + 1]) >= 0) continue;
            throw new IllegalStateException("rehash failure");
        }
        return a;
    }

    private ArrayMap() {
    }
}

