/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.impl;

import java.util.AbstractList;

public abstract class AbstractIndexedList<E>
extends AbstractList<E> {
    private static final int INITIAL_MASK = 15;
    private E[] events = new Object[16];
    private int min;
    private int max;
    private int mask = 15;

    protected abstract long getIndex(E var1);

    protected void removed(E event) {
    }

    @Override
    public boolean isEmpty() {
        return this.min == this.max;
    }

    @Override
    public int size() {
        return this.max - this.min & this.mask;
    }

    @Override
    public E get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("i=" + i + ", size=" + this.size());
        }
        return this.events[this.min + i & this.mask];
    }

    public int findIndex(long index) {
        if (this.min == this.max) {
            return -1;
        }
        long minIndex = this.getIndex(this.events[this.min]);
        if (index < minIndex) {
            return -1;
        }
        if (index == minIndex) {
            return 0;
        }
        long maxIndex = this.getIndex(this.events[this.max - 1 & this.mask]);
        if (index > maxIndex) {
            return -this.size() - 1;
        }
        if (index == maxIndex) {
            return this.size() - 1;
        }
        int b = this.max;
        int a = this.min;
        if (b < a) {
            b += this.mask + 1;
        }
        ++a;
        while (a < b) {
            int m = a + b >> 1;
            long mIndex = this.getIndex(this.events[m & this.mask]);
            if (index > mIndex) {
                a = m + 1;
                continue;
            }
            if (index < mIndex) {
                b = m;
                continue;
            }
            return m - this.min;
        }
        return -(a - this.min) - 1;
    }

    public void clearImpl() {
        int i = this.min;
        while (i != this.max) {
            this.removed(this.events[i]);
            this.events[i] = null;
            i = i + 1 & this.mask;
        }
        this.min = 0;
        this.max = 0;
    }

    public void updateImpl(E event, boolean remove) {
        int a;
        if (!remove) {
            this.growIfNeededImpl();
        }
        if ((a = this.findIndex(this.getIndex(event))) < 0) {
            if (!remove) {
                this.insertImpl(-a - 1, event);
            }
        } else if (remove) {
            this.removeImpl(a);
        } else {
            this.events[this.min + a & this.mask] = event;
        }
    }

    public void removeImpl(int i) {
        this.removed(this.events[this.min + i & this.mask]);
        int left = i;
        int right = this.size() - i - 1;
        if (left < right) {
            this.moveRight(this.min, left);
            this.events[this.min] = null;
            this.min = this.min + 1 & this.mask;
        } else {
            this.moveLeft(this.min + i + 1 & this.mask, right);
            this.max = this.max - 1 & this.mask;
            this.events[this.max] = null;
        }
    }

    public void insertImpl(int i, E event) {
        int left = i;
        int right = this.size() - i;
        if (left < right) {
            this.moveLeft(this.min, left);
            this.min = this.min - 1 & this.mask;
            this.events[this.min + i & this.mask] = event;
        } else {
            int at = this.min + i & this.mask;
            this.moveRight(at, right);
            this.max = this.max + 1 & this.mask;
            this.events[at] = event;
        }
    }

    private void moveLeft(int at, int n) {
        if (n == 0) {
            return;
        }
        if (at == 0) {
            at = this.mask + 1;
        }
        int m = this.mask + 1 - at;
        System.arraycopy(this.events, at, this.events, at - 1, Math.min(n, m));
        if (n > m) {
            this.events[this.mask] = this.events[0];
            System.arraycopy(this.events, 1, this.events, 0, n - m - 1);
        }
    }

    private void moveRight(int at, int n) {
        if (n == 0) {
            return;
        }
        int m = this.mask - at;
        if (n > m) {
            System.arraycopy(this.events, 0, this.events, 1, n - m - 1);
            this.events[0] = this.events[this.mask];
        }
        System.arraycopy(this.events, at, this.events, at + 1, Math.min(n, m));
    }

    public void growIfNeededImpl() {
        if ((this.max + 1 & this.mask) == this.min) {
            this.grow();
        }
    }

    private void grow() {
        int oldLen = this.events.length;
        int newLen = oldLen << 1;
        Object[] newEvents = new Object[newLen];
        if (this.max < this.min) {
            System.arraycopy(this.events, this.min, newEvents, 0, oldLen - this.min);
            System.arraycopy(this.events, 0, newEvents, oldLen - this.min, this.max);
        } else {
            System.arraycopy(this.events, this.min, newEvents, 0, this.max - this.min);
        }
        this.events = newEvents;
        this.max = this.size();
        this.min = 0;
        this.mask = newLen - 1;
    }
}

