/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.glossary;

import com.devexperts.util.MathUtil;
import com.dxfeed.glossary.AdditionalUnderlyings;
import java.io.Serializable;
import java.math.RoundingMode;

public class PriceIncrements
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final PriceIncrements EMPTY = new PriceIncrements("");
    private static final PriceIncrements[] cache = new PriceIncrements[239];
    private final String text;
    private volatile transient double[] increments;
    private volatile transient double[] precisions;
    private static final int MAXIMUM_PRECISION = 10;
    private static final double MINIMUM_INCREMENT = 1.0E-10;
    private static final double RELATIVE_EPS = 1.0E-6;

    public static PriceIncrements valueOf(String text) {
        if (text == null || text.isEmpty() || AdditionalUnderlyings.parseDouble(text, 0, text.length()) == 0.0) {
            return EMPTY;
        }
        int h = Math.abs(text.hashCode() % cache.length);
        PriceIncrements pi = cache[h];
        if (pi == null || !text.equals(pi.text)) {
            PriceIncrements.cache[h] = pi = new PriceIncrements(text);
        }
        return pi;
    }

    public static PriceIncrements valueOf(double increment) {
        if (Double.isNaN(increment) || Double.isInfinite(increment) || increment < 0.0) {
            throw new IllegalArgumentException("increment is not a finite positive number");
        }
        if (increment == 0.0) {
            return EMPTY;
        }
        return PriceIncrements.valueOf(AdditionalUnderlyings.formatDouble(increment));
    }

    public static PriceIncrements valueOf(double[] increments) {
        return PriceIncrements.valueOf(PriceIncrements.format(increments));
    }

    private PriceIncrements(String text) {
        this.text = text;
        this.increments = PriceIncrements.parse(text);
    }

    private double[] cacheIncrements() {
        double[] increments = this.increments;
        if (increments == null) {
            this.increments = increments = PriceIncrements.parse(this.text);
        }
        return increments;
    }

    private double[] cachePrecisions() {
        double[] precisions = this.precisions;
        if (precisions == null) {
            this.precisions = precisions = PriceIncrements.computePrecisions(this.cacheIncrements());
        }
        return precisions;
    }

    public String getText() {
        return this.text;
    }

    public double[] getPriceIncrements() {
        return (double[])this.cacheIncrements().clone();
    }

    public double getPriceIncrement() {
        return this.cacheIncrements()[0];
    }

    public double getPriceIncrement(double price) {
        return this.getPriceIncrement(price, 0);
    }

    public double getPriceIncrement(double price, int direction) {
        int i;
        if (price < 0.0) {
            return this.getPriceIncrement(-price, -direction);
        }
        if (Double.isNaN(price)) {
            return this.getPriceIncrement();
        }
        double[] increments = this.cacheIncrements();
        for (i = 1; i < increments.length && price > increments[i] + Math.min(increments[i - 1], increments[i + 1]) * 1.0E-6; i += 2) {
        }
        if (direction < 0 || i >= increments.length || price < increments[i] - Math.min(increments[i - 1], increments[i + 1]) * 1.0E-6) {
            return increments[i - 1];
        }
        if (direction > 0) {
            return increments[i + 1];
        }
        return Math.min(increments[i - 1], increments[i + 1]);
    }

    public int getPricePrecision() {
        return (int)this.cachePrecisions()[0];
    }

    public int getPricePrecision(double price) {
        int i;
        if (price < 0.0) {
            return this.getPricePrecision(-price);
        }
        if (Double.isNaN(price)) {
            return this.getPricePrecision();
        }
        double[] precisions = this.cachePrecisions();
        for (i = 1; i < precisions.length && price > precisions[i]; i += 2) {
        }
        return (int)precisions[i - 1];
    }

    public double roundPrice(double price) {
        return this.roundPrice(price, 0);
    }

    public double roundPrice(double price, int direction) {
        if (Double.isNaN(price)) {
            return price;
        }
        double increment = this.getPriceIncrement(price, direction);
        if (increment == 0.0) {
            return price;
        }
        if (direction < 0) {
            return this.floor(price, increment);
        }
        if (direction > 0) {
            return this.ceil(price, increment);
        }
        return this.halfEven(price, increment);
    }

    public double roundPrice(double price, RoundingMode mode) {
        if (Double.isNaN(price)) {
            return price;
        }
        if (mode == RoundingMode.UP) {
            mode = price >= 0.0 ? RoundingMode.CEILING : RoundingMode.FLOOR;
        } else if (mode == RoundingMode.DOWN) {
            RoundingMode roundingMode = mode = price >= 0.0 ? RoundingMode.FLOOR : RoundingMode.CEILING;
        }
        int direction = mode == RoundingMode.CEILING ? 1 : (mode == RoundingMode.FLOOR ? -1 : 0);
        double increment = this.getPriceIncrement(price, direction);
        if (increment == 0.0) {
            return price;
        }
        switch (mode) {
            case CEILING: {
                return this.ceil(price, increment);
            }
            case FLOOR: {
                return this.floor(price, increment);
            }
            case HALF_UP: {
                return price >= 0.0 ? this.halfCeil(price, increment) : this.halfFloor(price, increment);
            }
            case HALF_DOWN: {
                return price >= 0.0 ? this.halfFloor(price, increment) : this.halfCeil(price, increment);
            }
            case HALF_EVEN: {
                return this.halfEven(price, increment);
            }
            case UNNECESSARY: {
                if (this.halfEven(price, increment) != price) {
                    throw new ArithmeticException("price is not round " + price);
                }
                return price;
            }
        }
        throw new IllegalArgumentException("unknown mode " + (Object)((Object)mode));
    }

    public double incrementPrice(double price, int direction) {
        return this.incrementPrice(price, direction, 0.0);
    }

    public double incrementPrice(double price, int direction, double step) {
        if (direction == 0) {
            throw new IllegalArgumentException("direction is 0");
        }
        if (Double.isNaN(step) || Double.isInfinite(step) || step < 0.0) {
            throw new IllegalArgumentException("step is not a finite positive number");
        }
        double delta = Math.max(this.getPriceIncrement(price, direction), step);
        return this.roundPrice(direction > 0 ? price + delta : price - delta);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PriceIncrements && this.text.equals(((PriceIncrements)obj).text);
    }

    public String toString() {
        return this.text;
    }

    private static String format(double[] increments) {
        if (increments == null || increments.length == 0 || increments.length == 1 && increments[0] == 0.0) {
            return "";
        }
        if ((increments.length & 1) == 0) {
            throw new IllegalArgumentException("increments length is even");
        }
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < increments.length; n += 2) {
            double inc = increments[n];
            if (Double.isNaN(inc) || Double.isInfinite(inc) || inc < 1.0E-10) {
                throw new IllegalArgumentException("increment is not a finite positive number");
            }
            sb.append(AdditionalUnderlyings.formatDouble(inc));
            if (n + 1 >= increments.length) continue;
            double limit = increments[n + 1];
            if (Double.isNaN(limit) || Double.isInfinite(limit) || limit < 1.0E-10) {
                throw new IllegalArgumentException("limit is not a finite positive number");
            }
            if (n > 0 && limit <= increments[n - 1] + 2.0E-10) {
                throw new IllegalArgumentException("increments are not ordered properly");
            }
            sb.append(" ").append(AdditionalUnderlyings.formatDouble(limit)).append("; ");
        }
        return sb.toString();
    }

    private static double[] parse(String text) {
        double inc;
        if (text == null || text.isEmpty()) {
            return new double[]{0.0};
        }
        int n = 0;
        int i = text.lastIndexOf(59);
        while (i >= 0) {
            ++n;
            i = text.lastIndexOf(59, i - 1);
        }
        double[] increments = new double[2 * n + 1];
        n = 0;
        int i2 = 0;
        while (true) {
            int k;
            if ((k = text.indexOf(59, i2)) < 0) {
                if (text.charAt(i2) == ' ' || text.charAt(text.length() - 1) == ' ') {
                    throw new IllegalArgumentException("inappropriate use of separators");
                }
                inc = AdditionalUnderlyings.parseDouble(text, i2, text.length());
                if (Double.isNaN(inc) || Double.isInfinite(inc) || inc < 0.0 || n > 0 && inc < 1.0E-10) {
                    throw new IllegalArgumentException("increment is not a finite positive number");
                }
                break;
            }
            if (k >= text.length() - 2 || text.charAt(k + 1) != ' ') {
                throw new IllegalArgumentException("inappropriate use of separators");
            }
            int j = text.indexOf(32, i2);
            if (j <= i2 || j >= k - 1 || j < text.lastIndexOf(32, k - 1)) {
                throw new IllegalArgumentException("inappropriate use of separators");
            }
            double inc2 = AdditionalUnderlyings.parseDouble(text, i2, j);
            if (Double.isNaN(inc2) || Double.isInfinite(inc2) || inc2 < 1.0E-10) {
                throw new IllegalArgumentException("increment is not a finite positive number");
            }
            double limit = AdditionalUnderlyings.parseDouble(text, j + 1, k);
            if (Double.isNaN(limit) || Double.isInfinite(limit) || limit < 1.0E-10) {
                throw new IllegalArgumentException("limit is not a finite positive number");
            }
            if (n > 1 && limit <= increments[n - 1] + 2.0E-10) {
                throw new IllegalArgumentException("increments are not ordered properly");
            }
            increments[n++] = inc2;
            increments[n++] = limit;
            i2 = k + 2;
        }
        increments[n++] = inc;
        if (n != increments.length) {
            throw new IllegalArgumentException("inappropriate use of separators");
        }
        return increments;
    }

    private static double[] computePrecisions(double[] increments) {
        int i;
        double[] precisions = new double[increments.length];
        for (i = 0; i < increments.length; i += 2) {
            precisions[i] = PriceIncrements.computePrecision(increments[i]);
        }
        for (i = 1; i < increments.length; i += 2) {
            precisions[i] = increments[i] + Math.min(increments[i - 1], increments[i + 1]) * 1.0E-6;
        }
        return precisions;
    }

    private static int computePrecision(double value) {
        for (int i = 0; i < 10; ++i) {
            double eps;
            double round = Math.floor(value + 0.5);
            if (round >= value - (eps = Math.abs(value * 1.0E-6)) && round <= value + eps) {
                return i;
            }
            value *= 10.0;
        }
        return 10;
    }

    private double ceil(double price, double increment) {
        return MathUtil.roundDecimal(Math.ceil(price / increment - 1.0E-6) * increment);
    }

    private double floor(double price, double increment) {
        return MathUtil.roundDecimal(Math.floor(price / increment + 1.0E-6) * increment);
    }

    private double halfCeil(double price, double increment) {
        return MathUtil.roundDecimal(Math.floor(price / increment + 0.5 + 1.0E-6) * increment);
    }

    private double halfFloor(double price, double increment) {
        return MathUtil.roundDecimal(Math.ceil(price / increment - 0.5 - 1.0E-6) * increment);
    }

    private double halfEven(double price, double increment) {
        double scaled = price / increment;
        double res = Math.floor(scaled);
        double rem = scaled - res;
        if (rem >= 0.500001 || rem > 0.499999 && Math.floor(res / 2.0) * 2.0 != res) {
            res += 1.0;
        }
        return MathUtil.roundDecimal(res * increment);
    }
}

