/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.glossary;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class AdditionalUnderlyings
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final AdditionalUnderlyings EMPTY = new AdditionalUnderlyings("");
    private static final AdditionalUnderlyings[] cache = new AdditionalUnderlyings[239];
    private final String text;
    private volatile transient Map<String, Double> map;

    public static AdditionalUnderlyings valueOf(String text) {
        if (text == null || text.isEmpty()) {
            return EMPTY;
        }
        int h = Math.abs(text.hashCode() % cache.length);
        AdditionalUnderlyings au = cache[h];
        if (au == null || !text.equals(au.text)) {
            AdditionalUnderlyings.cache[h] = au = new AdditionalUnderlyings(text);
        }
        return au;
    }

    public static AdditionalUnderlyings valueOf(Map<String, Double> map) {
        return AdditionalUnderlyings.valueOf(AdditionalUnderlyings.format(map));
    }

    public static double getSPC(String text, String symbol) {
        if (text == null || text.isEmpty() || symbol == null || symbol.isEmpty()) {
            return 0.0;
        }
        int n = text.length();
        while (n > 0) {
            double spc;
            int j;
            int k = text.lastIndexOf(32, n - 1);
            if (k < n - 1 && k - (j = text.lastIndexOf(32, k - 1) + 1) == symbol.length() && text.regionMatches(j, symbol, 0, symbol.length()) && !Double.isNaN(spc = AdditionalUnderlyings.parseDouble(text, k + 1, n))) {
                return spc;
            }
            n = text.lastIndexOf(59, n - 1);
        }
        return 0.0;
    }

    private AdditionalUnderlyings(String text) {
        this.text = text;
        this.map = AdditionalUnderlyings.parse(text);
    }

    public String getText() {
        return this.text;
    }

    public Map<String, Double> getMap() {
        Map<String, Double> map = this.map;
        if (map == null) {
            this.map = map = AdditionalUnderlyings.parse(this.text);
        }
        return map;
    }

    public double getSPC(String symbol) {
        Double spc = this.getMap().get(symbol);
        return spc == null ? 0.0 : spc;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AdditionalUnderlyings && this.text.equals(((AdditionalUnderlyings)obj).text);
    }

    public String toString() {
        return this.text;
    }

    private static String format(Map<String, Double> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        Object[] symbols = map.keySet().toArray(new String[map.size()]);
        Arrays.sort(symbols);
        StringBuilder sb = new StringBuilder();
        for (Object symbol : symbols) {
            if (symbol == null || ((String)symbol).isEmpty()) {
                throw new IllegalArgumentException("symbol is empty");
            }
            if (((String)symbol).indexOf(32) >= 0 || ((String)symbol).indexOf(59) >= 0) {
                throw new IllegalArgumentException("symbol contains prohibited character");
            }
            Double spc = map.get(symbol);
            if (spc == null || Double.isNaN(spc) || Double.isInfinite(spc)) {
                throw new IllegalArgumentException("SPC is missing or infinite");
            }
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append((String)symbol).append(" ").append(AdditionalUnderlyings.formatDouble(spc));
        }
        return sb.toString();
    }

    private static Map<String, Double> parse(String text) {
        if (text == null || text.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Double> map = new HashMap<String, Double>();
        int n = text.length();
        while (n > 0) {
            if (n == text.length() - 1 || n < text.length() - 1 && text.charAt(n + 1) != ' ') {
                throw new IllegalArgumentException("inappropriate use of separators");
            }
            int k = text.lastIndexOf(32, n - 1);
            if (k >= n - 1) {
                throw new IllegalArgumentException("inappropriate use of separators");
            }
            int j = text.lastIndexOf(32, k - 1);
            if (j >= k - 1 || j == 0 || j > 0 && text.charAt(j - 1) != ';') {
                throw new IllegalArgumentException("inappropriate use of separators");
            }
            if (text.lastIndexOf(59, n - 1) > j) {
                throw new IllegalArgumentException("inappropriate use of separators");
            }
            double spc = AdditionalUnderlyings.parseDouble(text, k + 1, n);
            if (Double.isNaN(spc)) {
                throw new IllegalArgumentException("SPC is missing or infinite");
            }
            map.put(text.substring(j + 1, k), spc);
            n = text.lastIndexOf(59, n - 1);
        }
        return Collections.unmodifiableMap(map);
    }

    static double parseDouble(String text, int k, int n) {
        if (k >= n) {
            return Double.NaN;
        }
        boolean negative = false;
        double amount = 0.0;
        double divisor = 0.0;
        while (k < n) {
            char c;
            if ((c = text.charAt(k++)) == '-') {
                if (negative || amount > 0.0) {
                    return Double.NaN;
                }
                negative = true;
                continue;
            }
            if (c == '.') {
                if (divisor > 0.0) {
                    return Double.NaN;
                }
                divisor = 1.0;
                continue;
            }
            if (c < '0' || c > '9') {
                return Double.NaN;
            }
            amount = amount * 10.0 + (double)(c - 48);
            divisor *= 10.0;
        }
        if (divisor > 1.0) {
            amount /= divisor;
        }
        if (negative) {
            amount = -amount;
        }
        return amount;
    }

    static String formatDouble(double d) {
        if (d == (double)((long)d)) {
            return Long.toString((long)d);
        }
        if (d >= 0.01 && d < 1000000.0) {
            return Double.toString(d);
        }
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(20);
        nf.setGroupingUsed(false);
        return nf.format(d);
    }
}

