/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Underlying")
@XmlType(propOrder={"eventFlags", "index", "time", "sequence", "volatility", "frontVolatility", "backVolatility", "callVolume", "putVolume", "putCallRatio"})
@Description(value="Underlying event is a snapshot of computed values that are available for an option underlying\n symbol based on the option prices on the market.")
public class Underlying
extends MarketEvent
implements TimeSeriesEvent<String>,
LastingEvent<String> {
    private static final long serialVersionUID = 0L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private int eventFlags;
    private long index;
    private double volatility = Double.NaN;
    private double frontVolatility = Double.NaN;
    private double backVolatility = Double.NaN;
    private double callVolume = Double.NaN;
    private double putVolume = Double.NaN;
    private double putCallRatio = Double.NaN;

    public Underlying() {
    }

    public Underlying(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlTransient
    @Description(value="{@inheritDoc}")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this event.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @Override
    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns timestamp of the event in milliseconds.")
    public long getTime() {
        return (this.index >> 32) * 1000L + (this.index >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.index = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @Description(value="Returns sequence number of this event to distinguish events that have the same")
    public int getSequence() {
        return (int)this.index & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.index = this.index & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns 30-day implied volatility for this underlying based on VIX methodology.")
    public double getVolatility() {
        return this.volatility;
    }

    public void setVolatility(double volatility) {
        this.volatility = volatility;
    }

    @Description(value="Returns front month implied volatility for this underlying based on VIX methodology.")
    public double getFrontVolatility() {
        return this.frontVolatility;
    }

    public void setFrontVolatility(double frontVolatility) {
        this.frontVolatility = frontVolatility;
    }

    @Description(value="Returns back month implied volatility for this underlying based on VIX methodology.")
    public double getBackVolatility() {
        return this.backVolatility;
    }

    public void setBackVolatility(double backVolatility) {
        this.backVolatility = backVolatility;
    }

    @Description(value="Returns call options traded volume for a day.")
    public double getCallVolume() {
        return this.callVolume;
    }

    public void setCallVolume(double callVolume) {
        this.callVolume = callVolume;
    }

    @Description(value="Returns put options traded volume for a day.")
    public double getPutVolume() {
        return this.putVolume;
    }

    public void setPutVolume(double putVolume) {
        this.putVolume = putVolume;
    }

    @Description(value="Returns options traded volume for a day.")
    public double getOptionVolume() {
        return Double.isNaN(this.putVolume) ? this.callVolume : (Double.isNaN(this.callVolume) ? this.putVolume : this.putVolume + this.callVolume);
    }

    @Description(value="Returns ratio of put options traded volume to call options traded volume for a day.")
    public double getPutCallRatio() {
        return this.putCallRatio;
    }

    public void setPutCallRatio(double putCallRatio) {
        this.putCallRatio = putCallRatio;
    }

    public String toString() {
        return "Underlying{" + this.baseFieldsToString() + '}';
    }

    protected String baseFieldsToString() {
        return this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", sequence=" + this.getSequence() + ", volatility=" + this.volatility + ", frontVolatility=" + this.frontVolatility + ", backVolatility=" + this.backVolatility + ", callVolume=" + this.callVolume + ", putVolume=" + this.putVolume + ", putCallRatio=" + this.putCallRatio;
    }
}

