/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="TheoPrice")
@XmlType(propOrder={"eventFlags", "index", "time", "sequence", "price", "underlyingPrice", "delta", "gamma", "dividend", "interest"})
@Description(value="Theo price is a snapshot of the theoretical option price computation that is\n periodically performed by")
public class TheoPrice
extends MarketEvent
implements TimeSeriesEvent<String>,
LastingEvent<String> {
    private static final long serialVersionUID = 0L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private int eventFlags;
    private long index;
    private double price = Double.NaN;
    private double underlyingPrice = Double.NaN;
    private double delta = Double.NaN;
    private double gamma = Double.NaN;
    private double dividend = Double.NaN;
    private double interest = Double.NaN;

    public TheoPrice() {
    }

    public TheoPrice(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlTransient
    @Description(value="{@inheritDoc}")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this event.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @Override
    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns timestamp of the event in milliseconds.")
    public long getTime() {
        return (this.index >> 32) * 1000L + (this.index >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.index = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @Description(value="Returns sequence number of this event to distinguish events that have the same")
    public int getSequence() {
        return (int)this.index & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.index = this.index & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns theoretical option price.")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @Description(value="Returns underlying price at the time of theo price computation.")
    public double getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    public void setUnderlyingPrice(double underlyingPrice) {
        this.underlyingPrice = underlyingPrice;
    }

    @Description(value="Returns delta of the theoretical price.")
    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    @Description(value="Returns gamma of the theoretical price.")
    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    @Description(value="Returns implied simple dividend return of the corresponding option series.")
    public double getDividend() {
        return this.dividend;
    }

    public void setDividend(double dividend) {
        this.dividend = dividend;
    }

    @Description(value="Returns implied simple interest return of the corresponding option series.")
    public double getInterest() {
        return this.interest;
    }

    public void setInterest(double interest) {
        this.interest = interest;
    }

    public String toString() {
        return "TheoPrice{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", sequence=" + this.getSequence() + ", price=" + this.price + ", underlyingPrice=" + this.underlyingPrice + ", delta=" + this.delta + ", gamma=" + this.gamma + ", dividend=" + this.dividend + ", interest=" + this.interest + '}';
    }
}

