/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.annotation.Description;
import com.devexperts.util.DayUtil;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Series")
@XmlType(propOrder={"eventFlags", "index", "time", "sequence", "expiration", "volatility", "callVolume", "putVolume", "putCallRatio", "forwardPrice", "dividend", "interest"})
@Description(value="Series event is a snapshot of computed values that are available for all option series for\n a given underlying symbol based on the option prices on the market.")
public class Series
extends MarketEvent
implements IndexedEvent<String> {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private int eventFlags;
    private long index;
    private long timeSequence;
    private int expiration;
    private double volatility = Double.NaN;
    private double callVolume = Double.NaN;
    private double putVolume = Double.NaN;
    private double putCallRatio = Double.NaN;
    private double forwardPrice = Double.NaN;
    private double dividend = Double.NaN;
    private double interest = Double.NaN;

    public Series() {
    }

    public Series(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlTransient
    @Description(value="Returns a source for this event.")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this series.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @XmlTransient
    @Description(value="Returns time and sequence of this series packaged into single long value.")
    public long getTimeSequence() {
        return this.timeSequence;
    }

    public void setTimeSequence(long timeSequence) {
        this.timeSequence = timeSequence;
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @Description(value="Returns time of this series.")
    public long getTime() {
        return (this.timeSequence >> 32) * 1000L + (this.timeSequence >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.timeSequence = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @Description(value="Returns sequence number of this series to distinguish series that have the same")
    public int getSequence() {
        return (int)this.timeSequence & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.timeSequence = this.timeSequence & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns day id of expiration.")
    public int getExpiration() {
        return this.expiration;
    }

    public void setExpiration(int expiration) {
        this.expiration = expiration;
    }

    @Description(value="Returns implied volatility index for this series based on VIX methodology.")
    public double getVolatility() {
        return this.volatility;
    }

    public void setVolatility(double volatility) {
        this.volatility = volatility;
    }

    @Description(value="Returns call options traded volume for a day.")
    public double getCallVolume() {
        return this.callVolume;
    }

    @Description(value="Returns put options traded volume for a day.")
    public double getPutVolume() {
        return this.putVolume;
    }

    @Description(value="Returns options traded volume for a day.")
    public double getOptionVolume() {
        return Double.isNaN(this.putVolume) ? this.callVolume : (Double.isNaN(this.callVolume) ? this.putVolume : this.putVolume + this.callVolume);
    }

    @Description(value="Returns ratio of put options traded volume to call options traded volume for a day.")
    public double getPutCallRatio() {
        return this.putCallRatio;
    }

    @Description(value="Returns implied forward price for this option series.")
    public double getForwardPrice() {
        return this.forwardPrice;
    }

    public void setForwardPrice(double forwardPrice) {
        this.forwardPrice = forwardPrice;
    }

    @Description(value="Returns implied simple dividend return of the corresponding option series.")
    public double getDividend() {
        return this.dividend;
    }

    public void setDividend(double dividend) {
        this.dividend = dividend;
    }

    @Description(value="Returns implied simple interest return of the corresponding option series.")
    public double getInterest() {
        return this.interest;
    }

    public void setInterest(double interest) {
        this.interest = interest;
    }

    public void setCallVolume(double callVolume) {
        this.callVolume = callVolume;
    }

    public void setPutVolume(double putVolume) {
        this.putVolume = putVolume;
    }

    public void setPutCallRatio(double putCallRatio) {
        this.putCallRatio = putCallRatio;
    }

    public String toString() {
        return "Series{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", index=0x" + Long.toHexString(this.index) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", sequence=" + this.getSequence() + ", expiration=" + DayUtil.getYearMonthDayByDayId(this.getExpiration()) + ", volatility=" + this.volatility + ", callVolume=" + this.callVolume + ", putVolume=" + this.putVolume + ", putCallRatio=" + this.putCallRatio + ", forwardPrice=" + this.forwardPrice + ", dividend=" + this.dividend + ", interest=" + this.interest + '}';
    }
}

