/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Greeks")
@XmlType(propOrder={"eventFlags", "index", "time", "sequence", "price", "volatility", "delta", "gamma", "theta", "rho", "vega"})
@Description(value="Greeks event is a snapshot of the option price, Black-Scholes volatility and greeks.")
public class Greeks
extends MarketEvent
implements TimeSeriesEvent<String>,
LastingEvent<String> {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private int eventFlags;
    private long index;
    private double price = Double.NaN;
    private double volatility = Double.NaN;
    private double delta = Double.NaN;
    private double gamma = Double.NaN;
    private double theta = Double.NaN;
    private double rho = Double.NaN;
    private double vega = Double.NaN;

    public Greeks() {
    }

    public Greeks(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlTransient
    @Description(value="{@inheritDoc}")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this event.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @Override
    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns timestamp of the event in milliseconds.")
    public long getTime() {
        return (this.index >> 32) * 1000L + (this.index >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.index = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @Description(value="Returns sequence number of this event to distinguish events that have the same")
    public int getSequence() {
        return (int)this.index & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.index = this.index & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns option market price.")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @Description(value="Returns Black-Scholes implied volatility of the option.")
    public double getVolatility() {
        return this.volatility;
    }

    public void setVolatility(double volatility) {
        this.volatility = volatility;
    }

    @Description(value="Return option delta.")
    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    @Description(value="Returns option gamma.")
    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    @Description(value="Returns option theta.")
    public double getTheta() {
        return this.theta;
    }

    public void setTheta(double theta) {
        this.theta = theta;
    }

    @Description(value="Returns option rho.")
    public double getRho() {
        return this.rho;
    }

    public void setRho(double rho) {
        this.rho = rho;
    }

    @Description(value="Returns option vega.")
    public double getVega() {
        return this.vega;
    }

    public void setVega(double vega) {
        this.vega = vega;
    }

    public String toString() {
        return "Greeks{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", sequence=" + this.getSequence() + ", price=" + this.price + ", volatility=" + this.volatility + ", delta=" + this.delta + ", gamma=" + this.gamma + ", theta=" + this.theta + ", rho=" + this.rho + ", vega=" + this.vega + '}';
    }
}

