/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.misc;

import com.devexperts.annotation.Description;
import com.devexperts.io.IOUtil;
import com.devexperts.io.Marshalled;
import com.devexperts.util.TimeFormat;
import com.dxfeed.event.LastingEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Configuration")
@XmlType(propOrder={"eventSymbol", "eventTime", "version", "attachment"})
@Description(value="Configuration event with application-specific attachment.")
public class Configuration
implements LastingEvent<String>,
Serializable {
    private static final long serialVersionUID = 0L;
    private String eventSymbol;
    private long eventTime;
    private int version;
    private transient Marshalled<?> attachment;

    public Configuration() {
    }

    public Configuration(String eventSymbol) {
        this.setEventSymbol(eventSymbol);
    }

    public Configuration(String eventSymbol, Object attachment) {
        this.setEventSymbol(eventSymbol);
        this.setAttachment(attachment);
    }

    public Configuration(String eventSymbol, Object attachment, int version) {
        this.setEventSymbol(eventSymbol);
        this.setAttachment(attachment);
        this.setVersion(version);
    }

    @Override
    @Description(value="Returns symbol for this event.")
    public String getEventSymbol() {
        return this.eventSymbol;
    }

    @Override
    public void setEventSymbol(String eventSymbol) {
        this.eventSymbol = eventSymbol;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public long getEventTime() {
        return this.eventTime;
    }

    @Override
    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    @Description(value="Returns version.")
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @XmlAnyElement
    @Description(value="Returns attachment.")
    public Object getAttachment() {
        return this.attachment == null ? null : this.attachment.getObject();
    }

    @Description(value="Returns attachment.")
    public Object getAttachment(@Description(name="cl", value="the ClassLoader that will be used to load classes; ,<code>,null,</code>, for default") ClassLoader cl) {
        return this.attachment == null ? null : this.attachment.getObject(cl);
    }

    public void setAttachment(Object attachment) {
        this.attachment = Marshalled.forObject(attachment);
    }

    Marshalled<?> getMarshalledAttachment() {
        return this.attachment;
    }

    void setMarshalledAttachment(Marshalled<?> attachment) {
        this.attachment = attachment;
    }

    public String toString() {
        return "Configuration{" + this.eventSymbol + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", version=" + this.version + ", attachment=" + this.attachment + "}";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        IOUtil.writeByteArray(out, this.attachment == null ? null : this.attachment.getBytes());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attachment = Marshalled.forBytes(IOUtil.readByteArray(in));
    }
}

