/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import java.util.Arrays;

class Util {
    private Util() {
    }

    static <T extends Enum> T[] buildEnumArrayByOrdinal(T def, int length) {
        if (Integer.bitCount(length) != 1) {
            throw new IllegalArgumentException("length must be power of 2");
        }
        Enum[] values = (Enum[])def.getClass().getEnumConstants();
        Object[] result = Arrays.copyOf(values, length);
        Arrays.fill(result, def);
        for (Enum v : values) {
            result[v.ordinal()] = v;
        }
        return result;
    }

    static String encodeChar(char c) {
        if (c >= ' ' && c <= '~') {
            return String.valueOf(c);
        }
        if (c == '\u0000') {
            return "\\0";
        }
        return "\\u" + Integer.toHexString(c + 65536).substring(1);
    }

    static void checkChar(char c, int mask, String name) {
        if ((c & ~mask) != 0) {
            Util.throwInvalidChar(c, name);
        }
    }

    static void throwInvalidChar(char c, String name) {
        throw new IllegalArgumentException("Invalid " + name + ": " + Util.encodeChar(c));
    }

    static int getBits(int flags, int mask, int shift) {
        return flags >> shift & mask;
    }

    static int setBits(int flags, int mask, int shift, int bits) {
        return flags & ~(mask << shift) | (bits & mask) << shift;
    }
}

