/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.dxfeed.event.market.Util;

@Description(value="Trading status of an instrument.")
public enum TradingStatus {
    UNDEFINED(0),
    HALTED(1),
    ACTIVE(2);

    private static final TradingStatus[] STATUSES;
    private final int code;

    public static TradingStatus valueOf(int code) {
        return STATUSES[code];
    }

    private TradingStatus(int code) {
        this.code = code;
        if (code != this.ordinal()) {
            throw new IllegalArgumentException("code differs from ordinal");
        }
    }

    @Description(value="Returns integer code that is used in flag bits.")
    public int getCode() {
        return this.code;
    }

    static {
        STATUSES = (TradingStatus[])Util.buildEnumArrayByOrdinal((Enum)UNDEFINED, (int)4);
    }
}

