/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.DayUtil;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.impl.TimeNanosUtil;
import com.dxfeed.event.market.Direction;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Util;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"time", "timeNanoPart", "sequence", "exchangeCode", "price", "change", "sizeAsDouble", "dayId", "dayVolumeAsDouble", "dayTurnover", "tickDirection", "extendedTradingHours"})
@Description(value="Base class for common fields of")
public abstract class TradeBase
extends MarketEvent
implements LastingEvent<String> {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    static final int DIRECTION_MASK = 7;
    static final int DIRECTION_SHIFT = 1;
    static final int ETH = 1;
    private long timeSequence;
    private int timeNanoPart;
    private char exchangeCode;
    private double price = Double.NaN;
    private double change = Double.NaN;
    private double size = Double.NaN;
    private int dayId;
    private double dayVolume = Double.NaN;
    private double dayTurnover = Double.NaN;
    private int flags;

    TradeBase() {
    }

    TradeBase(String eventSymbol) {
        super(eventSymbol);
    }

    @XmlTransient
    @Description(value="Returns time and sequence of last trade packaged into single long value.")
    public long getTimeSequence() {
        return this.timeSequence;
    }

    public void setTimeSequence(long timeSequence) {
        this.timeSequence = timeSequence;
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns time of the last trade.")
    public long getTime() {
        return (this.timeSequence >> 32) * 1000L + (this.timeSequence >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.timeSequence = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @XmlTransient
    @Description(value="Returns time of the last trade in nanoseconds.")
    public long getTimeNanos() {
        return TimeNanosUtil.getNanosFromMillisAndNanoPart(this.getTime(), this.timeNanoPart);
    }

    public void setTimeNanos(long timeNanos) {
        this.setTime(TimeNanosUtil.getMillisFromNanos(timeNanos));
        this.timeNanoPart = TimeNanosUtil.getNanoPartFromNanos(timeNanos);
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    @Description(value="Returns microseconds and nanoseconds time part of the last trade.")
    public int getTimeNanoPart() {
        return this.timeNanoPart;
    }

    @Description(value="Returns sequence number of the last trade to distinguish trades that have the same")
    public int getSequence() {
        return (int)this.timeSequence & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.timeSequence = this.timeSequence & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns exchange code of the last trade.")
    public char getExchangeCode() {
        return this.exchangeCode;
    }

    public void setExchangeCode(char exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    @Description(value="Returns price of the last trade.")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @XmlTransient
    @Description(value="Returns size of the last trade as integer number (rounded toward zero).")
    public long getSize() {
        return (long)this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @XmlElement(name="size")
    @Description(value="Returns size of the last trade as floating number with fractions.")
    public double getSizeAsDouble() {
        return this.size;
    }

    public void setSizeAsDouble(double size) {
        this.size = size;
    }

    @Description(value="Returns identifier of the current trading day.")
    public int getDayId() {
        return this.dayId;
    }

    public void setDayId(int dayId) {
        this.dayId = dayId;
    }

    @XmlTransient
    @Description(value="Returns total volume traded for a day as integer number (rounded toward zero).")
    public long getDayVolume() {
        return (long)this.dayVolume;
    }

    public void setDayVolume(long dayVolume) {
        this.dayVolume = dayVolume;
    }

    @XmlElement(name="dayVolume")
    @Description(value="Returns total volume traded for a day as floating number with fractions.")
    public double getDayVolumeAsDouble() {
        return this.dayVolume;
    }

    public void setDayVolumeAsDouble(double dayVolume) {
        this.dayVolume = dayVolume;
    }

    @Description(value="Returns total turnover traded for a day.")
    public double getDayTurnover() {
        return this.dayTurnover;
    }

    public void setDayTurnover(double dayTurnover) {
        this.dayTurnover = dayTurnover;
    }

    @Description(value="Returns tick direction of the last trade.")
    public Direction getTickDirection() {
        return Direction.valueOf(Util.getBits(this.flags, 7, 1));
    }

    public void setTickDirection(Direction direction) {
        this.flags = Util.setBits(this.flags, 7, 1, direction.getCode());
    }

    public boolean isExtendedTradingHours() {
        return (this.flags & 1) != 0;
    }

    public void setExtendedTradingHours(boolean extendedTradingHours) {
        this.flags = extendedTradingHours ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    @Description(value="Returns change of the last trade.")
    public double getChange() {
        return this.change;
    }

    public void setChange(double change) {
        this.change = change;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.baseFieldsToString() + "}";
    }

    String baseFieldsToString() {
        return this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", timeNanoPart=" + this.timeNanoPart + ", sequence=" + this.getSequence() + ", exchange=" + Util.encodeChar(this.exchangeCode) + ", price=" + this.price + ", change=" + this.change + ", size=" + this.size + ", day=" + DayUtil.getYearMonthDayByDayId(this.dayId) + ", dayVolume=" + this.dayVolume + ", dayTurnover=" + this.dayTurnover + ", direction=" + (Object)((Object)this.getTickDirection()) + ", ETH=" + this.isExtendedTradingHours();
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }
}

