/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.impl.TimeNanosUtil;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.TimeAndSaleType;
import com.dxfeed.event.market.Util;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="TimeAndSale")
@XmlType(propOrder={"eventFlags", "index", "time", "timeNanoPart", "sequence", "exchangeCode", "price", "sizeAsDouble", "bidPrice", "askPrice", "exchangeSaleConditions", "tradeThroughExempt", "aggressorSide", "spreadLeg", "extendedTradingHours", "validTick", "type", "buyer", "seller"})
@Description(value="Time and Sale represents a trade or other market event with price, like market open/close price, etc.")
public class TimeAndSale
extends MarketEvent
implements TimeSeriesEvent<String> {
    private static final long serialVersionUID = 3L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    static final int TTE_MASK = 255;
    static final int TTE_SHIFT = 8;
    static final int SIDE_MASK = 3;
    static final int SIDE_SHIFT = 5;
    static final int SPREAD_LEG = 16;
    static final int ETH = 8;
    static final int VALID_TICK = 4;
    static final int TYPE_MASK = 3;
    static final int TYPE_SHIFT = 0;
    private int eventFlags;
    private long index;
    private int timeNanoPart;
    private char exchangeCode;
    private double price = Double.NaN;
    private double size = Double.NaN;
    private double bidPrice = Double.NaN;
    private double askPrice = Double.NaN;
    private String exchangeSaleConditions;
    private int flags;
    private String buyer;
    private String seller;

    public TimeAndSale() {
    }

    public TimeAndSale(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlTransient
    @Description(value="{@inheritDoc}")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this time and sale event.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @Deprecated
    public void setEventId(long index) {
        this.setIndex(index);
    }

    @Override
    @Description(value="Returns timestamp of the original event.")
    public long getTime() {
        return (this.index >> 32) * 1000L + (this.index >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.index = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @XmlTransient
    @Description(value="Returns timestamp of the original event in nanoseconds.")
    public long getTimeNanos() {
        return TimeNanosUtil.getNanosFromMillisAndNanoPart(this.getTime(), this.timeNanoPart);
    }

    public void setTimeNanos(long timeNanos) {
        this.setTime(TimeNanosUtil.getMillisFromNanos(timeNanos));
        this.timeNanoPart = TimeNanosUtil.getNanoPartFromNanos(timeNanos);
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    @Description(value="Returns microseconds and nanoseconds time part of event.")
    public int getTimeNanoPart() {
        return this.timeNanoPart;
    }

    @Description(value="Returns sequence number of this event to distinguish events that have the same")
    public int getSequence() {
        return (int)this.index & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.index = this.index & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns exchange code of this time and sale event.")
    public char getExchangeCode() {
        return this.exchangeCode;
    }

    public void setExchangeCode(char exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    @Description(value="Returns price of this time and sale event.")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @XmlTransient
    @Description(value="Returns size of this time and sale event as integer number (rounded toward zero).")
    public long getSize() {
        return (long)this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @XmlElement(name="size")
    @Description(value="Returns size of this time and sale event as floating number with fractions.")
    public double getSizeAsDouble() {
        return this.size;
    }

    public void setSizeAsDouble(double size) {
        this.size = size;
    }

    @Description(value="Returns the current bid price on the market when this time and sale event had occurred.")
    public double getBidPrice() {
        return this.bidPrice;
    }

    public void setBidPrice(double bidPrice) {
        this.bidPrice = bidPrice;
    }

    @Description(value="Returns the current ask price on the market when this time and sale event had occurred.")
    public double getAskPrice() {
        return this.askPrice;
    }

    public void setAskPrice(double askPrice) {
        this.askPrice = askPrice;
    }

    @Description(value="Returns sale conditions provided for this event by data feed.")
    public String getExchangeSaleConditions() {
        return this.exchangeSaleConditions;
    }

    public void setExchangeSaleConditions(String exchangeSaleConditions) {
        this.exchangeSaleConditions = exchangeSaleConditions;
    }

    @Description(value="Returns TradeThroughExempt flag of this time and sale event.")
    public char getTradeThroughExempt() {
        return (char)Util.getBits(this.flags, 255, 8);
    }

    public void setTradeThroughExempt(char tradeThroughExempt) {
        Util.checkChar(tradeThroughExempt, 255, "tradeThroughExempt");
        this.flags = Util.setBits(this.flags, 255, 8, tradeThroughExempt);
    }

    @Description(value="Returns aggressor side of this time and sale event.")
    public Side getAggressorSide() {
        return Side.valueOf(Util.getBits(this.flags, 3, 5));
    }

    public void setAggressorSide(Side side) {
        this.flags = Util.setBits(this.flags, 3, 5, side.getCode());
    }

    public boolean isSpreadLeg() {
        return (this.flags & 0x10) != 0;
    }

    public void setSpreadLeg(boolean spreadLeg) {
        this.flags = spreadLeg ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isExtendedTradingHours() {
        return (this.flags & 8) != 0;
    }

    public void setExtendedTradingHours(boolean extendedTradingHours) {
        this.flags = extendedTradingHours ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public boolean isValidTick() {
        return (this.flags & 4) != 0;
    }

    public void setValidTick(boolean validTick) {
        this.flags = validTick ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    @Description(value="Returns type of this time and sale event.")
    public TimeAndSaleType getType() {
        return TimeAndSaleType.valueOf(Util.getBits(this.flags, 3, 0));
    }

    public void setType(TimeAndSaleType type) {
        this.flags = Util.setBits(this.flags, 3, 0, type.getCode());
    }

    @XmlTransient
    public boolean isNew() {
        return this.getType() == TimeAndSaleType.NEW;
    }

    @Deprecated
    public void setNew() {
        this.setType(TimeAndSaleType.NEW);
    }

    @XmlTransient
    public boolean isCorrection() {
        return this.getType() == TimeAndSaleType.CORRECTION;
    }

    @Deprecated
    public void setCorrection() {
        this.setType(TimeAndSaleType.CORRECTION);
    }

    @XmlTransient
    public boolean isCancel() {
        return this.getType() == TimeAndSaleType.CANCEL;
    }

    @Deprecated
    public void setCancel() {
        this.setType(TimeAndSaleType.CANCEL);
    }

    @Description(value="Returns buyer of this time and sale event.")
    public String getBuyer() {
        return this.buyer;
    }

    public void setBuyer(String buyer) {
        this.buyer = buyer;
    }

    @Description(value="Returns seller of this time and sale event.")
    public String getSeller() {
        return this.seller;
    }

    public void setSeller(String seller) {
        this.seller = seller;
    }

    public String toString() {
        return "TimeAndSale{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", timeNanoPart=" + this.timeNanoPart + ", sequence=" + this.getSequence() + ", exchange=" + Util.encodeChar(this.exchangeCode) + ", price=" + this.price + ", size=" + this.size + ", bid=" + this.bidPrice + ", ask=" + this.askPrice + ", ESC='" + this.exchangeSaleConditions + "', TTE=" + Util.encodeChar(this.getTradeThroughExempt()) + ", side=" + (Object)((Object)this.getAggressorSide()) + ", spread=" + this.isSpreadLeg() + ", ETH=" + this.isExtendedTradingHours() + ", validTick=" + this.isValidTick() + ", type=" + (Object)((Object)this.getType()) + (this.buyer == null ? "" : ", buyer='" + this.buyer + "'") + (this.seller == null ? "" : ", seller='" + this.seller + "'") + "}";
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }
}

