/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.DayUtil;
import com.devexperts.util.TimeFormat;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.PriceType;
import com.dxfeed.event.market.Util;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Summary")
@XmlType(propOrder={"dayId", "dayOpenPrice", "dayHighPrice", "dayLowPrice", "dayClosePrice", "dayClosePriceType", "prevDayId", "prevDayClosePrice", "prevDayClosePriceType", "prevDayVolume", "openInterest"})
@Description(value="Summary information snapshot about the trading session including session highs, lows, etc.")
public class Summary
extends MarketEvent
implements LastingEvent<String> {
    private static final long serialVersionUID = 0L;
    static final int DAY_CLOSE_PRICE_TYPE_MASK = 3;
    static final int DAY_CLOSE_PRICE_TYPE_SHIFT = 2;
    static final int PREV_DAY_CLOSE_PRICE_TYPE_MASK = 3;
    static final int PREV_DAY_CLOSE_PRICE_TYPE_SHIFT = 0;
    private int dayId;
    private double dayOpenPrice = Double.NaN;
    private double dayHighPrice = Double.NaN;
    private double dayLowPrice = Double.NaN;
    private double dayClosePrice = Double.NaN;
    private int prevDayId;
    private double prevDayClosePrice = Double.NaN;
    private double prevDayVolume = Double.NaN;
    private long openInterest;
    private int flags;

    public Summary() {
    }

    public Summary(String eventSymbol) {
        super(eventSymbol);
    }

    @Description(value="Returns identifier of the day that this summary represents.")
    public int getDayId() {
        return this.dayId;
    }

    public void setDayId(int dayId) {
        this.dayId = dayId;
    }

    @Description(value="Returns the first (open) price for the day.")
    public double getDayOpenPrice() {
        return this.dayOpenPrice;
    }

    public void setDayOpenPrice(double dayOpenPrice) {
        this.dayOpenPrice = dayOpenPrice;
    }

    @Description(value="Returns the maximal (high) price for the day.")
    public double getDayHighPrice() {
        return this.dayHighPrice;
    }

    public void setDayHighPrice(double dayHighPrice) {
        this.dayHighPrice = dayHighPrice;
    }

    @Description(value="Returns the minimal (low) price for the day.")
    public double getDayLowPrice() {
        return this.dayLowPrice;
    }

    public void setDayLowPrice(double dayLowPrice) {
        this.dayLowPrice = dayLowPrice;
    }

    @Description(value="Returns the last (close) price for the day.")
    public double getDayClosePrice() {
        return this.dayClosePrice;
    }

    public void setDayClosePrice(double dayClosePrice) {
        this.dayClosePrice = dayClosePrice;
    }

    @Description(value="Returns the price type of the last (close) price for the day.")
    public PriceType getDayClosePriceType() {
        return PriceType.valueOf(Util.getBits(this.flags, 3, 2));
    }

    public void setDayClosePriceType(PriceType type) {
        this.flags = Util.setBits(this.flags, 3, 2, type.getCode());
    }

    @Description(value="Returns identifier of the previous day that this summary represents.")
    public int getPrevDayId() {
        return this.prevDayId;
    }

    public void setPrevDayId(int prevDayId) {
        this.prevDayId = prevDayId;
    }

    @Description(value="Returns the last (close) price for the previous day.")
    public double getPrevDayClosePrice() {
        return this.prevDayClosePrice;
    }

    public void setPrevDayClosePrice(double prevDayClosePrice) {
        this.prevDayClosePrice = prevDayClosePrice;
    }

    @Description(value="Returns the price type of the last (close) price for the previous day.")
    public PriceType getPrevDayClosePriceType() {
        return PriceType.valueOf(Util.getBits(this.flags, 3, 0));
    }

    public void setPrevDayClosePriceType(PriceType type) {
        this.flags = Util.setBits(this.flags, 3, 0, type.getCode());
    }

    @Description(value="Returns total volume traded for the previous day.")
    public double getPrevDayVolume() {
        return this.prevDayVolume;
    }

    public void setPrevDayVolume(double prevDayVolume) {
        this.prevDayVolume = prevDayVolume;
    }

    @Description(value="Returns open interest of the symbol as the number of open contracts.")
    public long getOpenInterest() {
        return this.openInterest;
    }

    public void setOpenInterest(long openInterest) {
        this.openInterest = openInterest;
    }

    public String toString() {
        return "Summary{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", day=" + DayUtil.getYearMonthDayByDayId(this.dayId) + ", dayOpen=" + this.dayOpenPrice + ", dayHigh=" + this.dayHighPrice + ", dayLow=" + this.dayLowPrice + ", dayClose=" + this.dayClosePrice + ", dayCloseType=" + (Object)((Object)this.getDayClosePriceType()) + ", prevDay=" + DayUtil.getYearMonthDayByDayId(this.prevDayId) + ", prevDayClose=" + this.prevDayClosePrice + ", prevDayCloseType=" + (Object)((Object)this.getPrevDayClosePriceType()) + ", prevDayVolume=" + this.prevDayVolume + ", openInterest=" + this.openInterest + '}';
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }
}

