/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.dxfeed.event.market.Util;

@Description(value="Scope of an order.")
public enum Scope {
    COMPOSITE(0),
    REGIONAL(1),
    AGGREGATE(2),
    ORDER(3);

    private static final Scope[] SCOPES;
    private final int code;

    public static Scope valueOf(int code) {
        return SCOPES[code];
    }

    private Scope(int code) {
        this.code = code;
        if (code != this.ordinal()) {
            throw new IllegalArgumentException("code differs from ordinal");
        }
    }

    @Description(value="Returns integer code that is used in flag bits.")
    public int getCode() {
        return this.code;
    }

    static {
        SCOPES = (Scope[])Util.buildEnumArrayByOrdinal((Enum)COMPOSITE, (int)4);
    }
}

