/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.impl.TimeNanosUtil;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Util;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Quote")
@XmlType(propOrder={"sequence", "timeNanoPart", "bidTime", "bidExchangeCode", "bidPrice", "bidSizeAsDouble", "askTime", "askExchangeCode", "askPrice", "askSizeAsDouble"})
@Description(value="Quote event is a snapshot of the best bid and ask prices, and other fields that change with each quote.")
public class Quote
extends MarketEvent
implements LastingEvent<String> {
    private static final long serialVersionUID = 1L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private int timeMillisSequence;
    private int timeNanoPart;
    private long bidTime;
    private char bidExchangeCode;
    private double bidPrice = Double.NaN;
    private double bidSize = Double.NaN;
    private long askTime;
    private char askExchangeCode;
    private double askPrice = Double.NaN;
    private double askSize = Double.NaN;

    public Quote() {
    }

    public Quote(String eventSymbol) {
        super(eventSymbol);
    }

    @Description(value="Returns sequence number of this quote to distinguish quotes that have the same")
    public int getSequence() {
        return this.timeMillisSequence & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.timeMillisSequence = this.timeMillisSequence & 0xFFC00000 | sequence;
    }

    @XmlTransient
    @Description(value="Returns time of the last bid or ask change.")
    public long getTime() {
        return Math.floorDiv(Math.max(this.bidTime, this.askTime), 1000L) * 1000L + (long)(this.timeMillisSequence >>> 22);
    }

    @XmlTransient
    @Description(value="Returns time of the last bid or ask change in nanoseconds.")
    public long getTimeNanos() {
        return TimeNanosUtil.getNanosFromMillisAndNanoPart(this.getTime(), this.timeNanoPart);
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    @Description(value="Returns microseconds and nanoseconds part of time of the last bid or ask change.")
    public int getTimeNanoPart() {
        return this.timeNanoPart;
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns time of the last bid change.")
    public long getBidTime() {
        return this.bidTime;
    }

    public void setBidTime(long bidTime) {
        this.bidTime = bidTime;
        this.recomputeTimeMillisPart();
    }

    @Description(value="Returns bid exchange code.")
    public char getBidExchangeCode() {
        return this.bidExchangeCode;
    }

    public void setBidExchangeCode(char bidExchangeCode) {
        this.bidExchangeCode = bidExchangeCode;
    }

    @Description(value="Returns bid price.")
    public double getBidPrice() {
        return this.bidPrice;
    }

    public void setBidPrice(double bidPrice) {
        this.bidPrice = bidPrice;
    }

    @XmlTransient
    @Description(value="Returns bid size as integer number (rounded toward zero).")
    public long getBidSize() {
        return (long)this.bidSize;
    }

    public void setBidSize(long bidSize) {
        this.bidSize = bidSize;
    }

    @XmlElement(name="bidSize")
    @Description(value="Returns bid size as floating number with fractions.")
    public double getBidSizeAsDouble() {
        return this.bidSize;
    }

    public void setBidSizeAsDouble(double bidSize) {
        this.bidSize = bidSize;
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns time of the last ask change.")
    public long getAskTime() {
        return this.askTime;
    }

    public void setAskTime(long askTime) {
        this.askTime = askTime;
        this.recomputeTimeMillisPart();
    }

    @Description(value="Returns ask exchange code.")
    public char getAskExchangeCode() {
        return this.askExchangeCode;
    }

    public void setAskExchangeCode(char askExchangeCode) {
        this.askExchangeCode = askExchangeCode;
    }

    @Description(value="Returns ask price.")
    public double getAskPrice() {
        return this.askPrice;
    }

    public void setAskPrice(double askPrice) {
        this.askPrice = askPrice;
    }

    @XmlTransient
    @Description(value="Returns ask size as integer number (rounded toward zero).")
    public long getAskSize() {
        return (long)this.askSize;
    }

    public void setAskSize(long askSize) {
        this.askSize = askSize;
    }

    @XmlElement(name="askSize")
    @Description(value="Returns ask size as floating number with fractions.")
    public double getAskSizeAsDouble() {
        return this.askSize;
    }

    public void setAskSizeAsDouble(double askSize) {
        this.askSize = askSize;
    }

    public String toString() {
        return "Quote{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", timeNanoPart=" + this.timeNanoPart + ", sequence=" + this.getSequence() + ", bidTime=" + TimeFormat.DEFAULT.withMillis().format(this.bidTime) + ", bidExchange=" + Util.encodeChar(this.bidExchangeCode) + ", bidPrice=" + this.bidPrice + ", bidSize=" + this.bidSize + ", askTime=" + TimeFormat.DEFAULT.withMillis().format(this.askTime) + ", askExchange=" + Util.encodeChar(this.askExchangeCode) + ", askPrice=" + this.askPrice + ", askSize=" + this.askSize + '}';
    }

    int getTimeMillisSequence() {
        return this.timeMillisSequence;
    }

    void setTimeMillisSequence(int timeMillisSequence) {
        this.timeMillisSequence = timeMillisSequence;
    }

    private void recomputeTimeMillisPart() {
        this.timeMillisSequence = TimeUtil.getMillisFromTime(Math.max(this.askTime, this.bidTime)) << 22 | this.getSequence();
    }
}

