/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.DayUtil;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.WideDecimal;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.ShortSaleRestriction;
import com.dxfeed.event.market.TradingStatus;
import com.dxfeed.event.market.Util;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Profile")
@XmlType(propOrder={"description", "shortSaleRestriction", "tradingStatus", "statusReason", "haltStartTime", "haltEndTime", "highLimitPrice", "lowLimitPrice", "high52WeekPrice", "low52WeekPrice", "beta", "earningsPerShare", "dividendFrequency", "exDividendAmount", "exDividendDayId", "shares", "freeFloat"})
@Description(value="Profile information snapshot that contains security instrument description.")
public class Profile
extends MarketEvent
implements LastingEvent<String> {
    private static final long serialVersionUID = 0L;
    static final int SSR_MASK = 3;
    static final int SSR_SHIFT = 2;
    static final int STATUS_MASK = 3;
    static final int STATUS_SHIFT = 0;
    private String description;
    private String statusReason;
    private long haltStartTime;
    private long haltEndTime;
    private double highLimitPrice = Double.NaN;
    private double lowLimitPrice = Double.NaN;
    private double high52WeekPrice = Double.NaN;
    private double low52WeekPrice = Double.NaN;
    private double beta = Double.NaN;
    private double earningsPerShare = Double.NaN;
    private double dividendFrequency = Double.NaN;
    private double exDividendAmount = Double.NaN;
    private int exDividendDayId;
    private double shares = Double.NaN;
    private double freeFloat = Double.NaN;
    private int flags;

    public Profile() {
    }

    public Profile(String eventSymbol) {
        super(eventSymbol);
    }

    @Description(value="Returns description of the security instrument.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Description(value="Returns short sale restriction of the security instrument.")
    public ShortSaleRestriction getShortSaleRestriction() {
        return ShortSaleRestriction.valueOf(Util.getBits(this.flags, 3, 2));
    }

    public void setShortSaleRestriction(ShortSaleRestriction restriction) {
        this.flags = Util.setBits(this.flags, 3, 2, restriction.getCode());
    }

    @XmlTransient
    public boolean isShortSaleRestricted() {
        return this.getShortSaleRestriction() == ShortSaleRestriction.ACTIVE;
    }

    @Deprecated
    public void setShortSaleRestricted(boolean isShortSaleRestricted) {
        this.setShortSaleRestriction(isShortSaleRestricted ? ShortSaleRestriction.ACTIVE : ShortSaleRestriction.UNDEFINED);
    }

    @Description(value="Returns trading status of the security instrument.")
    public TradingStatus getTradingStatus() {
        return TradingStatus.valueOf(Util.getBits(this.flags, 3, 0));
    }

    public void setTradingStatus(TradingStatus status) {
        this.flags = Util.setBits(this.flags, 3, 0, status.getCode());
    }

    @XmlTransient
    public boolean isTradingHalted() {
        return this.getTradingStatus() == TradingStatus.HALTED;
    }

    @Deprecated
    public void setTradingHalted(boolean isTradingHalted) {
        this.setTradingStatus(isTradingHalted ? TradingStatus.HALTED : TradingStatus.UNDEFINED);
    }

    @Description(value="Returns description of the reason that trading was halted.")
    public String getStatusReason() {
        return this.statusReason;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    @Description(value="Returns starting time of the trading halt interval.")
    public long getHaltStartTime() {
        return this.haltStartTime;
    }

    public void setHaltStartTime(long haltStartTime) {
        this.haltStartTime = haltStartTime;
    }

    @Description(value="Returns ending time of the trading halt interval.")
    public long getHaltEndTime() {
        return this.haltEndTime;
    }

    public void setHaltEndTime(long haltEndTime) {
        this.haltEndTime = haltEndTime;
    }

    @Description(value="Returns the maximal (high) allowed price.")
    public double getHighLimitPrice() {
        return this.highLimitPrice;
    }

    public void setHighLimitPrice(double highLimitPrice) {
        this.highLimitPrice = highLimitPrice;
    }

    @Description(value="Returns the minimal (low) allowed price.")
    public double getLowLimitPrice() {
        return this.lowLimitPrice;
    }

    public void setLowLimitPrice(double lowLimitPrice) {
        this.lowLimitPrice = lowLimitPrice;
    }

    @Description(value="Returns the maximal (high) price in last 52 weeks.")
    public double getHigh52WeekPrice() {
        return this.high52WeekPrice;
    }

    public void setHigh52WeekPrice(double high52WeekPrice) {
        this.high52WeekPrice = high52WeekPrice;
    }

    @Description(value="Returns the minimal (low) price in last 52 weeks.")
    public double getLow52WeekPrice() {
        return this.low52WeekPrice;
    }

    public void setLow52WeekPrice(double low52WeekPrice) {
        this.low52WeekPrice = low52WeekPrice;
    }

    @Description(value="Returns the correlation coefficient of the instrument to the S")
    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    @Description(value="Returns earnings per share (the company\\u2019s profits divided by the number of shares).")
    public double getEarningsPerShare() {
        return this.earningsPerShare;
    }

    public void setEarningsPerShare(double earningsPerShare) {
        this.earningsPerShare = earningsPerShare;
    }

    @Description(value="Returns frequency of cash dividends payments per year (calculated).")
    public double getDividendFrequency() {
        return this.dividendFrequency;
    }

    public void setDividendFrequency(double dividendFrequency) {
        this.dividendFrequency = dividendFrequency;
    }

    @Description(value="Returns the amount of the last paid dividend.")
    public double getExDividendAmount() {
        return this.exDividendAmount;
    }

    public void setExDividendAmount(double exDividendAmount) {
        this.exDividendAmount = exDividendAmount;
    }

    @Description(value="Returns identifier of the day of the last dividend payment (ex-dividend date).")
    public int getExDividendDayId() {
        return this.exDividendDayId;
    }

    public void setExDividendDayId(int exDividendDayId) {
        this.exDividendDayId = exDividendDayId;
    }

    @Description(value="Returns the number of shares outstanding.")
    public double getShares() {
        return this.shares;
    }

    public void setShares(double shares) {
        this.shares = shares;
    }

    @Description(value="Returns free-float - the number of shares outstanding that are available to the public for trade.")
    public double getFreeFloat() {
        return this.freeFloat;
    }

    public void setFreeFloat(double freeFloat) {
        this.freeFloat = freeFloat;
    }

    public String toString() {
        return "Profile{" + this.baseFieldsToString() + "}";
    }

    protected String baseFieldsToString() {
        return this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", description='" + this.description + "', SSR=" + (Object)((Object)this.getShortSaleRestriction()) + ", status=" + (Object)((Object)this.getTradingStatus()) + ", statusReason='" + this.statusReason + "', haltStartTime=" + TimeFormat.DEFAULT.format(this.haltStartTime) + ", haltEndTime=" + TimeFormat.DEFAULT.format(this.haltEndTime) + ", highLimitPrice=" + this.highLimitPrice + ", lowLimitPrice=" + this.lowLimitPrice + ", high52WeekPrice=" + this.high52WeekPrice + ", low52WeekPrice=" + this.low52WeekPrice + ", beta=" + this.beta + ", earningsPerShare=" + this.earningsPerShare + ", dividendFrequency=" + this.dividendFrequency + ", exDividendAmount=" + this.exDividendAmount + ", exDividendDay=" + DayUtil.getYearMonthDayByDayId(this.exDividendDayId) + ", shares=" + WideDecimal.toString(WideDecimal.composeWide(this.shares)) + ", freeFloat=" + WideDecimal.toString(WideDecimal.composeWide(this.freeFloat));
    }

    protected int getFlags() {
        return this.flags;
    }

    protected void setFlags(int flags) {
        this.flags = flags;
    }
}

