/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.dxfeed.event.market.Util;

@Description(value="Type of the price value.")
public enum PriceType {
    REGULAR(0),
    INDICATIVE(1),
    PRELIMINARY(2),
    FINAL(3);

    private static final PriceType[] TYPES;
    private final int code;

    public static PriceType valueOf(int code) {
        return TYPES[code];
    }

    private PriceType(int code) {
        this.code = code;
        if (code != this.ordinal()) {
            throw new IllegalArgumentException("code differs from ordinal");
        }
    }

    @Description(value="Returns integer code that is used in flag bits.")
    public int getCode() {
        return this.code;
    }

    static {
        TYPES = (PriceType[])Util.buildEnumArrayByOrdinal((Enum)REGULAR, (int)4);
    }
}

