/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OtcMarketsPriceType;
import com.dxfeed.event.market.Util;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="OtcMarketsOrder")
@XmlType(propOrder={"quoteAccessPayment", "open", "unsolicited", "otcMarketsPriceType", "saturated", "autoExecution", "nmsConditional"})
@Description(value="Represents an extension of")
public class OtcMarketsOrder
extends Order {
    private static final long serialVersionUID = 0L;
    static final int NMS_CONDITIONAL = 64;
    static final int AUTO_EXECUTION = 32;
    static final int SATURATED = 16;
    static final int OTC_PRICE_TYPE_MASK = 3;
    static final int OTC_PRICE_TYPE_SHIFT = 2;
    static final int UNSOLICITED = 2;
    static final int OPEN = 1;
    private int quoteAccessPayment;
    private int otcMarketsFlags;

    public OtcMarketsOrder() {
    }

    public OtcMarketsOrder(String eventSymbol) {
        super(eventSymbol);
    }

    @Description(value="Returns Quote Access Payment (QAP) of this OTC Markets order.")
    public int getQuoteAccessPayment() {
        return this.quoteAccessPayment;
    }

    public void setQuoteAccessPayment(int quoteAccessPayment) {
        this.quoteAccessPayment = quoteAccessPayment;
    }

    public boolean isOpen() {
        return (this.otcMarketsFlags & 1) != 0;
    }

    public void setOpen(boolean open) {
        this.otcMarketsFlags = open ? this.otcMarketsFlags | 1 : this.otcMarketsFlags & 0xFFFFFFFE;
    }

    public boolean isUnsolicited() {
        return (this.otcMarketsFlags & 2) != 0;
    }

    public void setUnsolicited(boolean unsolicited) {
        this.otcMarketsFlags = unsolicited ? this.otcMarketsFlags | 2 : this.otcMarketsFlags & 0xFFFFFFFD;
    }

    @Description(value="Returns OTC Markets price type of this OTC Markets order events.")
    public OtcMarketsPriceType getOtcMarketsPriceType() {
        return OtcMarketsPriceType.valueOf(Util.getBits(this.otcMarketsFlags, 3, 2));
    }

    public void setOtcMarketsPriceType(OtcMarketsPriceType otcPriceType) {
        this.otcMarketsFlags = Util.setBits(this.otcMarketsFlags, 3, 2, otcPriceType.getCode());
    }

    public boolean isSaturated() {
        return (this.otcMarketsFlags & 0x10) != 0;
    }

    public void setSaturated(boolean saturated) {
        this.otcMarketsFlags = saturated ? this.otcMarketsFlags | 0x10 : this.otcMarketsFlags & 0xFFFFFFEF;
    }

    public boolean isAutoExecution() {
        return (this.otcMarketsFlags & 0x20) != 0;
    }

    public void setAutoExecution(boolean autoExecution) {
        this.otcMarketsFlags = autoExecution ? this.otcMarketsFlags | 0x20 : this.otcMarketsFlags & 0xFFFFFFDF;
    }

    public boolean isNmsConditional() {
        return (this.otcMarketsFlags & 0x40) != 0;
    }

    public void setNmsConditional(boolean nmsConditional) {
        this.otcMarketsFlags = nmsConditional ? this.otcMarketsFlags | 0x40 : this.otcMarketsFlags & 0xFFFFFFBF;
    }

    @Override
    StringBuilder fieldsToString(StringBuilder sb) {
        return super.fieldsToString(sb).append(", QAP=").append(this.quoteAccessPayment).append(", open=").append(this.isOpen()).append(", unsolicited=").append(this.isUnsolicited()).append(", priceType=").append((Object)this.getOtcMarketsPriceType()).append(", saturated=").append(this.isSaturated()).append(", autoEx=").append(this.isAutoExecution()).append(", NMS=").append(this.isNmsConditional());
    }

    int getOtcMarketsFlags() {
        return this.otcMarketsFlags;
    }

    void setOtcMarketsFlags(int otcMarketsFlags) {
        this.otcMarketsFlags = otcMarketsFlags;
    }
}

