/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.SynchronizedIndexedSet;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.AnalyticOrder;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBase;
import com.dxfeed.event.market.OtcMarketsOrder;
import com.dxfeed.event.market.SpreadOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@Description(value="Identifies source of")
public final class OrderSource
extends IndexedEventSource {
    private static volatile int CACHE_SIZE = 100;
    private static final SynchronizedIndexedSet<Integer, OrderSource> SOURCES_BY_ID = SynchronizedIndexedSet.createInt(IndexedEventSource::id).withCapacity(CACHE_SIZE);
    private static final SynchronizedIndexedSet<String, OrderSource> SOURCES_BY_NAME = SynchronizedIndexedSet.create(IndexedEventSource::name).withCapacity(CACHE_SIZE);
    private static final int PUB_ORDER = 1;
    private static final int PUB_ANALYTIC_ORDER = 2;
    private static final int PUB_OTC_MARKETS_ORDER = 4;
    private static final int PUB_SPREAD_ORDER = 8;
    private static final int FULL_ORDER_BOOK = 16;
    private static final int FLAGS_SIZE = 5;
    private static final List<OrderSource>[] PUBLISHABLE_LISTS = new List[5];
    private static final List<OrderSource>[] PUBLISHABLE_VIEWS = new List[5];
    public static final OrderSource COMPOSITE_BID;
    public static final OrderSource COMPOSITE_ASK;
    public static final OrderSource REGIONAL_BID;
    public static final OrderSource REGIONAL_ASK;
    public static final OrderSource AGGREGATE_BID;
    public static final OrderSource AGGREGATE_ASK;
    public static final OrderSource DEFAULT;
    public static final OrderSource NTV;
    public static final OrderSource ntv;
    public static final OrderSource NFX;
    public static final OrderSource ESPD;
    public static final OrderSource XNFI;
    public static final OrderSource ICE;
    public static final OrderSource ISE;
    public static final OrderSource DEA;
    public static final OrderSource DEX;
    public static final OrderSource dex;
    public static final OrderSource BYX;
    public static final OrderSource BZX;
    public static final OrderSource bzx;
    public static final OrderSource BATE;
    public static final OrderSource CHIX;
    public static final OrderSource CEUX;
    public static final OrderSource BXTR;
    public static final OrderSource IST;
    public static final OrderSource BI20;
    public static final OrderSource ABE;
    public static final OrderSource FAIR;
    public static final OrderSource GLBX;
    public static final OrderSource glbx;
    public static final OrderSource ERIS;
    public static final OrderSource XEUR;
    public static final OrderSource xeur;
    public static final OrderSource CFE;
    public static final OrderSource C2OX;
    public static final OrderSource SMFE;
    public static final OrderSource smfe;
    public static final OrderSource iex;
    public static final OrderSource MEMX;
    public static final OrderSource memx;
    public static final OrderSource OCEA;
    public static final OrderSource pink;
    private final int pubFlags;
    private final boolean builtin;

    public static boolean isSpecialSourceId(int sourceId) {
        return sourceId >= 1 && sourceId <= 6;
    }

    public static OrderSource valueOf(int sourceId) {
        OrderSource result = (OrderSource)SOURCES_BY_ID.getByKey(sourceId);
        if (result != null) {
            return result;
        }
        return OrderSource.createAndCacheOrderSource(SOURCES_BY_ID, sourceId, OrderSource.decodeName(sourceId));
    }

    public static OrderSource valueOf(String name) {
        OrderSource result = (OrderSource)SOURCES_BY_NAME.getByKey(name);
        if (result != null) {
            return result;
        }
        return OrderSource.createAndCacheOrderSource(SOURCES_BY_NAME, OrderSource.composeId(name), name);
    }

    public static List<OrderSource> publishable(Class<? extends OrderBase> eventType) {
        return PUBLISHABLE_VIEWS[31 - Integer.numberOfLeadingZeros(OrderSource.getEventTypeMask(eventType))];
    }

    public static List<OrderSource> fullOrderBook() {
        return PUBLISHABLE_VIEWS[31 - Integer.numberOfLeadingZeros(16)];
    }

    private OrderSource(String name, int pubFlags) {
        this(OrderSource.composeId(name), name, pubFlags);
    }

    private OrderSource(int id, String name, int pubFlags) {
        super(id, name);
        this.pubFlags = pubFlags;
        this.builtin = true;
        if (id < 0) {
            throw new IllegalArgumentException("id is negative");
        }
        if (id > 0 && id < 32 && !OrderSource.isSpecialSourceId(id)) {
            throw new IllegalArgumentException("id is not marked as special");
        }
        if (!(id < 32 || id == OrderSource.composeId(name) && name.equals(OrderSource.decodeName(id)))) {
            throw new IllegalArgumentException("id does not match name");
        }
        if (!SOURCES_BY_ID.add(this)) {
            throw new IllegalArgumentException("duplicate id");
        }
        if (!SOURCES_BY_NAME.add(this)) {
            throw new IllegalArgumentException("duplicate name");
        }
        if (OrderSource.isFullOrderBookFlag(pubFlags) && !OrderSource.isPublishableFlag(pubFlags)) {
            throw new IllegalArgumentException("unpublishable full order book order");
        }
        CACHE_SIZE = Math.max(CACHE_SIZE, SOURCES_BY_ID.size() * 4);
        for (int i = 0; i < 5; ++i) {
            if ((pubFlags & 1 << i) == 0) continue;
            PUBLISHABLE_LISTS[i].add(this);
        }
    }

    private OrderSource(int id, String name) {
        super(id, name);
        this.pubFlags = 0;
        this.builtin = false;
    }

    public boolean isPublishable(Class<? extends OrderBase> eventType) {
        return (this.pubFlags & OrderSource.getEventTypeMask(eventType)) != 0;
    }

    public boolean isFullOrderBook() {
        return OrderSource.isFullOrderBookFlag(this.pubFlags);
    }

    private static boolean isPublishableFlag(int pubFlags) {
        return (pubFlags & 0xF) != 0;
    }

    private static boolean isFullOrderBookFlag(int pubFlags) {
        return (pubFlags & 0x10) != 0;
    }

    private static void checkChar(char c) {
        if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
            return;
        }
        throw new IllegalArgumentException("Source name must contain only alphanumeric characters");
    }

    private static int composeId(String name) {
        int sourceId = 0;
        int n = name.length();
        if (n == 0 || n > 4) {
            throw new IllegalArgumentException("Source name must contain from 1 to 4 characters");
        }
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            OrderSource.checkChar(c);
            sourceId = sourceId << 8 | c;
        }
        return sourceId;
    }

    private static String decodeName(int id) {
        if (id == 0) {
            throw new IllegalArgumentException("Source name must contain from 1 to 4 characters");
        }
        char[] name = new char[4];
        int n = 0;
        for (int i = 24; i >= 0; i -= 8) {
            if (id >> i == 0) continue;
            char c = (char)(id >> i & 0xFF);
            OrderSource.checkChar(c);
            name[n++] = c;
        }
        return new String(name, 0, n);
    }

    private static int getEventTypeMask(Class<? extends OrderBase> eventType) {
        if (eventType == Order.class) {
            return 1;
        }
        if (eventType == AnalyticOrder.class) {
            return 2;
        }
        if (eventType == OtcMarketsOrder.class) {
            return 4;
        }
        if (eventType == SpreadOrder.class) {
            return 8;
        }
        throw new IllegalArgumentException("Invalid order event type: " + eventType);
    }

    private static OrderSource createAndCacheOrderSource(SynchronizedIndexedSet<?, OrderSource> cache, int sourceId, String name) {
        if (cache.size() >= CACHE_SIZE) {
            OrderSource.trimCache(cache);
        }
        return cache.putIfAbsentAndGet(new OrderSource(sourceId, name));
    }

    private static void trimCache(SynchronizedIndexedSet<?, OrderSource> cache) {
        Iterator it = cache.concurrentIterator();
        while (it.hasNext()) {
            if (((OrderSource)it.next()).builtin) continue;
            it.remove();
        }
    }

    static {
        for (int i = 0; i < 5; ++i) {
            OrderSource.PUBLISHABLE_LISTS[i] = new ArrayList<OrderSource>();
            OrderSource.PUBLISHABLE_VIEWS[i] = Collections.unmodifiableList(PUBLISHABLE_LISTS[i]);
        }
        COMPOSITE_BID = new OrderSource(1, "COMPOSITE_BID", 0);
        COMPOSITE_ASK = new OrderSource(2, "COMPOSITE_ASK", 0);
        REGIONAL_BID = new OrderSource(3, "REGIONAL_BID", 0);
        REGIONAL_ASK = new OrderSource(4, "REGIONAL_ASK", 0);
        AGGREGATE_BID = new OrderSource(5, "AGGREGATE_BID", 0);
        AGGREGATE_ASK = new OrderSource(6, "AGGREGATE_ASK", 0);
        DEFAULT = new OrderSource(0, "DEFAULT", 31);
        NTV = new OrderSource("NTV", 17);
        ntv = new OrderSource("ntv", 1);
        NFX = new OrderSource("NFX", 1);
        ESPD = new OrderSource("ESPD", 1);
        XNFI = new OrderSource("XNFI", 1);
        ICE = new OrderSource("ICE", 1);
        ISE = new OrderSource("ISE", 9);
        DEA = new OrderSource("DEA", 1);
        DEX = new OrderSource("DEX", 1);
        dex = new OrderSource("dex", 1);
        BYX = new OrderSource("BYX", 1);
        BZX = new OrderSource("BZX", 1);
        bzx = new OrderSource("bzx", 1);
        BATE = new OrderSource("BATE", 1);
        CHIX = new OrderSource("CHIX", 1);
        CEUX = new OrderSource("CEUX", 1);
        BXTR = new OrderSource("BXTR", 1);
        IST = new OrderSource("IST", 1);
        BI20 = new OrderSource("BI20", 1);
        ABE = new OrderSource("ABE", 1);
        FAIR = new OrderSource("FAIR", 1);
        GLBX = new OrderSource("GLBX", 3);
        glbx = new OrderSource("glbx", 1);
        ERIS = new OrderSource("ERIS", 1);
        XEUR = new OrderSource("XEUR", 1);
        xeur = new OrderSource("xeur", 1);
        CFE = new OrderSource("CFE", 1);
        C2OX = new OrderSource("C2OX", 1);
        SMFE = new OrderSource("SMFE", 1);
        smfe = new OrderSource("smfe", 1);
        iex = new OrderSource("iex", 1);
        MEMX = new OrderSource("MEMX", 1);
        memx = new OrderSource("memx", 1);
        OCEA = new OrderSource("OCEA", 1);
        pink = new OrderSource("pink", 5);
    }
}

