/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.impl.TimeNanosUtil;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.OrderAction;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.Util;
import com.dxfeed.impl.XmlSourceAdapter;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlType(propOrder={"eventFlags", "index", "time", "timeNanoPart", "sequence", "source", "action", "actionTime", "orderId", "auxOrderId", "price", "sizeAsDouble", "executedSize", "count", "exchangeCode", "orderSide", "scope", "tradeId", "tradePrice", "tradeSize"})
@Description(value="Base class for common fields of")
public class OrderBase
extends MarketEvent
implements IndexedEvent<String> {
    private static final long serialVersionUID = 3L;
    @Deprecated
    public static final int SIDE_BUY = 0;
    @Deprecated
    public static final int SIDE_SELL = 1;
    @Deprecated
    public static final int LEVEL_COMPOSITE = 0;
    @Deprecated
    public static final int LEVEL_REGIONAL = 1;
    @Deprecated
    public static final int LEVEL_AGGREGATE = 2;
    @Deprecated
    public static final int LEVEL_ORDER = 3;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    static final int ACTION_MASK = 15;
    static final int ACTION_SHIFT = 11;
    static final int EXCHANGE_MASK = 127;
    static final int EXCHANGE_SHIFT = 4;
    static final int SIDE_MASK = 3;
    static final int SIDE_SHIFT = 2;
    static final int SCOPE_MASK = 3;
    static final int SCOPE_SHIFT = 0;
    private int eventFlags;
    private long index;
    private long timeSequence;
    private int timeNanoPart;
    private long actionTime;
    private long orderId;
    private long auxOrderId;
    private double price = Double.NaN;
    private double size = Double.NaN;
    private double executedSize = Double.NaN;
    private long count;
    private int flags;
    private long tradeId;
    private double tradePrice = Double.NaN;
    private double tradeSize = Double.NaN;

    OrderBase() {
    }

    OrderBase(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlJavaTypeAdapter(type=IndexedEventSource.class, value=XmlSourceAdapter.class)
    @XmlSchemaType(name="string")
    @Description(value="Returns source of this event.")
    public OrderSource getSource() {
        int sourceId = (int)(this.index >> 48);
        if (!OrderSource.isSpecialSourceId(sourceId)) {
            sourceId = (int)(this.index >> 32);
        }
        return OrderSource.valueOf(sourceId);
    }

    public void setSource(OrderSource source) {
        int shift = OrderSource.isSpecialSourceId(source.id()) ? 48 : 32;
        long mask = OrderSource.isSpecialSourceId((int)(this.index >> 48)) ? 0xFFFFFFFFFFFFL : 0xFFFFFFFFL;
        this.index = (long)source.id() << shift | this.index & mask;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this order.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        if (index < 0L) {
            throw new IllegalArgumentException("Negative index: " + index);
        }
        this.index = index;
    }

    @XmlTransient
    @Description(value="Returns time and sequence of this order packaged into single long value.")
    public long getTimeSequence() {
        return this.timeSequence;
    }

    public void setTimeSequence(long timeSequence) {
        this.timeSequence = timeSequence;
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @Description(value="Returns time of this order.")
    public long getTime() {
        return (this.timeSequence >> 32) * 1000L + (this.timeSequence >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.timeSequence = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    @Description(value="Returns microseconds and nanoseconds time part of this order.")
    public int getTimeNanoPart() {
        return this.timeNanoPart;
    }

    @Description(value="Returns sequence number of this order to distinguish orders that have the same")
    public int getSequence() {
        return (int)this.timeSequence & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.timeSequence = this.timeSequence & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @XmlTransient
    @Description(value="Returns time of this order in nanoseconds.")
    public long getTimeNanos() {
        return TimeNanosUtil.getNanosFromMillisAndNanoPart(this.getTime(), this.timeNanoPart);
    }

    public void setTimeNanos(long timeNanos) {
        this.setTime(TimeNanosUtil.getMillisFromNanos(timeNanos));
        this.timeNanoPart = TimeNanosUtil.getNanoPartFromNanos(timeNanos);
    }

    @XmlElement
    @Description(value="Returns order action if available, otherwise -")
    public OrderAction getAction() {
        return OrderAction.valueOf(Util.getBits(this.flags, 15, 11));
    }

    public void setAction(OrderAction action) {
        this.flags = Util.setBits(this.flags, 15, 11, action.getCode());
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @Description(value="Returns time of the last")
    public long getActionTime() {
        return this.actionTime;
    }

    public void setActionTime(long actionTime) {
        this.actionTime = actionTime;
    }

    @Description(value="Returns order ID if available.")
    public long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(long orderId) {
        this.orderId = orderId;
    }

    @Description(value="Returns auxiliary order ID if available:")
    public long getAuxOrderId() {
        return this.auxOrderId;
    }

    public void setAuxOrderId(long auxOrderId) {
        this.auxOrderId = auxOrderId;
    }

    @Description(value="Returns price of this order.")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @XmlTransient
    @Description(value="Returns size of this order as integer number (rounded toward zero).")
    public long getSize() {
        return (long)this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @XmlElement(name="size")
    @Description(value="Returns size of this order as floating number with fractions.")
    public double getSizeAsDouble() {
        return this.size;
    }

    public void setSizeAsDouble(double size) {
        this.size = size;
    }

    public boolean hasSize() {
        return this.size != 0.0 && !Double.isNaN(this.size);
    }

    @Description(value="Returns executed size of this order.")
    public double getExecutedSize() {
        return this.executedSize;
    }

    public void setExecutedSize(double executedSize) {
        this.executedSize = executedSize;
    }

    @Description(value="Returns number of individual orders in this aggregate order.")
    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @Description(value="Returns trade (order execution) ID for events containing trade-related action.")
    public long getTradeId() {
        return this.tradeId;
    }

    public void setTradeId(long tradeId) {
        this.tradeId = tradeId;
    }

    @Description(value="Returns trade price for events containing trade-related action.")
    public double getTradePrice() {
        return this.tradePrice;
    }

    public void setTradePrice(double tradePrice) {
        this.tradePrice = tradePrice;
    }

    @Description(value="Returns trade size for events containing trade-related action.")
    public double getTradeSize() {
        return this.tradeSize;
    }

    public void setTradeSize(double tradeSize) {
        this.tradeSize = tradeSize;
    }

    @Description(value="Returns exchange code of this order.")
    public char getExchangeCode() {
        return (char)Util.getBits(this.flags, 127, 4);
    }

    public void setExchangeCode(char exchangeCode) {
        Util.checkChar(exchangeCode, 127, "exchangeCode");
        this.flags = Util.setBits(this.flags, 127, 4, exchangeCode);
    }

    @XmlElement(name="side")
    @Description(value="Returns side of this order.")
    public Side getOrderSide() {
        return Side.valueOf(Util.getBits(this.flags, 3, 2));
    }

    public void setOrderSide(Side side) {
        this.flags = Util.setBits(this.flags, 3, 2, side.getCode());
    }

    @Description(value="Returns scope of this order.")
    public Scope getScope() {
        return Scope.valueOf(Util.getBits(this.flags, 3, 0));
    }

    public void setScope(Scope scope) {
        this.flags = Util.setBits(this.flags, 3, 0, scope.getCode());
    }

    @Deprecated
    @XmlTransient
    @Description(value="Returns side of this order.")
    public int getSide() {
        return this.getOrderSide() == Side.SELL ? 1 : 0;
    }

    @Deprecated
    public void setSide(int side) {
        if (side == 0) {
            this.setOrderSide(Side.BUY);
        } else if (side == 1) {
            this.setOrderSide(Side.SELL);
        } else {
            throw new IllegalArgumentException("Invalid side: " + side);
        }
    }

    @Deprecated
    @XmlTransient
    @Description(value="Returns detail level of this order.")
    public int getLevel() {
        return this.getScope().getCode();
    }

    @Deprecated
    public void setLevel(int level) {
        this.setScope(Scope.valueOf(level));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append('{');
        this.fieldsToString(sb);
        sb.append('}');
        return sb.toString();
    }

    StringBuilder fieldsToString(StringBuilder sb) {
        return sb.append(this.getEventSymbol()).append(", eventTime=").append(TimeFormat.DEFAULT.withMillis().format(this.getEventTime())).append(", source=").append(this.getSource()).append(", eventFlags=0x").append(Integer.toHexString(this.getEventFlags())).append(", index=0x").append(Long.toHexString(this.index)).append(", time=").append(TimeFormat.DEFAULT.withMillis().format(this.getTime())).append(", sequence=").append(this.getSequence()).append(", timeNanoPart=").append(this.timeNanoPart).append(", action=").append((Object)this.getAction()).append(", actionTime=").append(TimeFormat.DEFAULT.withMillis().format(this.actionTime)).append(", orderId=").append(this.orderId).append(", auxOrderId=").append(this.auxOrderId).append(", price=").append(this.price).append(", size=").append(this.size).append(", executedSize=").append(this.executedSize).append(", count=").append(this.count).append(", exchange=").append(Util.encodeChar(this.getExchangeCode())).append(", side=").append((Object)this.getOrderSide()).append(", scope=").append((Object)this.getScope()).append(", tradeId=").append(this.tradeId).append(", tradePrice=").append(this.tradePrice).append(", tradeSize=").append(this.tradeSize);
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }
}

