/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.dxfeed.event.market.Util;

@Description(value="Action enum for the Full Order Book (FOB) Orders.")
public enum OrderAction {
    UNDEFINED(0),
    NEW(1),
    REPLACE(2),
    MODIFY(3),
    DELETE(4),
    PARTIAL(5),
    EXECUTE(6),
    TRADE(7),
    BUST(8);

    private static final OrderAction[] ACTIONS;
    private final int code;

    public static OrderAction valueOf(int code) {
        return ACTIONS[code];
    }

    private OrderAction(int code) {
        this.code = code;
        if (code != this.ordinal()) {
            throw new IllegalArgumentException("code differs from ordinal");
        }
    }

    @Description(value="Returns integer code that is used in flag bits.")
    public int getCode() {
        return this.code;
    }

    static {
        ACTIONS = (OrderAction[])Util.buildEnumArrayByOrdinal((Enum)UNDEFINED, (int)16);
    }
}

