/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.impl.TimeNanosUtil;
import com.dxfeed.event.market.MarketEvent;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.TimeAndSaleType;
import com.dxfeed.event.market.Util;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="OptionSale")
@XmlType(propOrder={"eventFlags", "index", "time", "timeNanoPart", "sequence", "exchangeCode", "price", "size", "bidPrice", "askPrice", "exchangeSaleConditions", "tradeThroughExempt", "aggressorSide", "spreadLeg", "extendedTradingHours", "validTick", "type", "underlyingPrice", "volatility", "delta", "optionSymbol"})
@Description(value="Option Sale event represents a trade or another market event with the price\n (for example, market open/close price, etc.) for each option symbol listed under the specified Underlying.")
public class OptionSale
extends MarketEvent
implements IndexedEvent<String> {
    private static final long serialVersionUID = 0L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private int eventFlags;
    private long index;
    private long timeSequence;
    private int timeNanoPart;
    private char exchangeCode;
    private double price = Double.NaN;
    private double size = Double.NaN;
    private double bidPrice = Double.NaN;
    private double askPrice = Double.NaN;
    private String exchangeSaleConditions;
    private int flags;
    private double underlyingPrice = Double.NaN;
    private double volatility = Double.NaN;
    private double delta = Double.NaN;
    private String optionSymbol;

    public OptionSale() {
    }

    public OptionSale(String eventSymbol) {
        super(eventSymbol);
    }

    @Override
    @XmlTransient
    @Description(value="Returns a source for this event.")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this option sale event.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    @XmlTransient
    @Description(value="Returns time and sequence of this event packaged into single long value.")
    public long getTimeSequence() {
        return this.timeSequence;
    }

    public void setTimeSequence(long timeSequence) {
        this.timeSequence = timeSequence;
    }

    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @Description(value="Returns time of this option sale event.")
    public long getTime() {
        return (this.timeSequence >> 32) * 1000L + (this.timeSequence >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.timeSequence = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @XmlTransient
    @Description(value="Returns timestamp of the original event in nanoseconds.")
    public long getTimeNanos() {
        return TimeNanosUtil.getNanosFromMillisAndNanoPart(this.getTime(), this.timeNanoPart);
    }

    public void setTimeNanos(long timeNanos) {
        this.setTime(TimeNanosUtil.getMillisFromNanos(timeNanos));
        this.timeNanoPart = TimeNanosUtil.getNanoPartFromNanos(timeNanos);
    }

    @Description(value="Returns microseconds and nanoseconds time part of this event.")
    public int getTimeNanoPart() {
        return this.timeNanoPart;
    }

    public void setTimeNanoPart(int timeNanoPart) {
        this.timeNanoPart = timeNanoPart;
    }

    @Description(value="Returns sequence number of this event to distinguish option sale events that have the same")
    public int getSequence() {
        return (int)this.timeSequence & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.timeSequence = this.timeSequence & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns exchange code of this option sale event.")
    public char getExchangeCode() {
        return this.exchangeCode;
    }

    public void setExchangeCode(char exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    @Description(value="Returns price of this option sale event.")
    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    @Description(value="Returns size of this option sale event.")
    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    @Description(value="Returns the current bid price on the market when this option sale event had occurred.")
    public double getBidPrice() {
        return this.bidPrice;
    }

    public void setBidPrice(double bidPrice) {
        this.bidPrice = bidPrice;
    }

    @Description(value="Returns the current ask price on the market when this option sale event had occurred.")
    public double getAskPrice() {
        return this.askPrice;
    }

    public void setAskPrice(double askPrice) {
        this.askPrice = askPrice;
    }

    @Description(value="Returns sale conditions provided for this event by data feed.")
    public String getExchangeSaleConditions() {
        return this.exchangeSaleConditions;
    }

    public void setExchangeSaleConditions(String exchangeSaleConditions) {
        this.exchangeSaleConditions = exchangeSaleConditions;
    }

    @Description(value="Returns TradeThroughExempt flag of this option sale event.")
    public char getTradeThroughExempt() {
        return (char)Util.getBits(this.flags, 255, 8);
    }

    public void setTradeThroughExempt(char tradeThroughExempt) {
        Util.checkChar(tradeThroughExempt, 255, "tradeThroughExempt");
        this.flags = Util.setBits(this.flags, 255, 8, tradeThroughExempt);
    }

    @Description(value="Returns aggressor side of this option sale event.")
    public Side getAggressorSide() {
        return Side.valueOf(Util.getBits(this.flags, 3, 5));
    }

    public void setAggressorSide(Side side) {
        this.flags = Util.setBits(this.flags, 3, 5, side.getCode());
    }

    public boolean isSpreadLeg() {
        return (this.flags & 0x10) != 0;
    }

    public void setSpreadLeg(boolean spreadLeg) {
        this.flags = spreadLeg ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isExtendedTradingHours() {
        return (this.flags & 8) != 0;
    }

    public void setExtendedTradingHours(boolean extendedTradingHours) {
        this.flags = extendedTradingHours ? this.flags | 8 : this.flags & 0xFFFFFFF7;
    }

    public boolean isValidTick() {
        return (this.flags & 4) != 0;
    }

    public void setValidTick(boolean validTick) {
        this.flags = validTick ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    @Description(value="Returns type of this option sale event.")
    public TimeAndSaleType getType() {
        return TimeAndSaleType.valueOf(Util.getBits(this.flags, 3, 0));
    }

    public void setType(TimeAndSaleType type) {
        this.flags = Util.setBits(this.flags, 3, 0, type.getCode());
    }

    @XmlTransient
    public boolean isNew() {
        return this.getType() == TimeAndSaleType.NEW;
    }

    @XmlTransient
    public boolean isCorrection() {
        return this.getType() == TimeAndSaleType.CORRECTION;
    }

    @XmlTransient
    public boolean isCancel() {
        return this.getType() == TimeAndSaleType.CANCEL;
    }

    @Description(value="Returns underlying price at the time of this option sale event.")
    public double getUnderlyingPrice() {
        return this.underlyingPrice;
    }

    public void setUnderlyingPrice(double underlyingPrice) {
        this.underlyingPrice = underlyingPrice;
    }

    @Description(value="Returns Black-Scholes implied volatility of the option at the time of this option sale event.")
    public double getVolatility() {
        return this.volatility;
    }

    public void setVolatility(double volatility) {
        this.volatility = volatility;
    }

    @Description(value="Return option delta at the time of this option sale event.")
    public double getDelta() {
        return this.delta;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    @Description(value="Returns option symbol of this event.")
    public String getOptionSymbol() {
        return this.optionSymbol;
    }

    public void setOptionSymbol(String optionSymbol) {
        this.optionSymbol = optionSymbol;
    }

    public String toString() {
        return "OptionSale{" + this.getEventSymbol() + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", index=0x" + Long.toHexString(this.index) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", timeNanoPart=" + this.timeNanoPart + ", sequence=" + this.getSequence() + ", exchange=" + Util.encodeChar(this.exchangeCode) + ", price=" + this.price + ", size=" + this.size + ", bid=" + this.bidPrice + ", ask=" + this.askPrice + ", ESC='" + this.exchangeSaleConditions + "', TTE=" + Util.encodeChar(this.getTradeThroughExempt()) + ", side=" + (Object)((Object)this.getAggressorSide()) + ", spread=" + this.isSpreadLeg() + ", ETH=" + this.isExtendedTradingHours() + ", validTick=" + this.isValidTick() + ", type=" + (Object)((Object)this.getType()) + ", underlyingPrice=" + this.underlyingPrice + ", volatility=" + this.volatility + ", delta=" + this.delta + ", optionSymbol='" + this.optionSymbol + "'}";
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }
}

