/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Description(value="Helper class to compose and parse symbols for market events.")
public class MarketEventSymbols {
    public static final Pattern EXCHANGES_PATTERN = Pattern.compile("[0-9A-Za-z]");
    public static final String SUPPORTED_EXCHANGES = IntStream.rangeClosed(0, 127).mapToObj(c -> String.valueOf((char)c)).filter(s -> EXCHANGES_PATTERN.matcher((CharSequence)s).matches()).collect(Collectors.joining());
    public static final String DEFAULT_EXCHANGES = IntStream.rangeClosed(65, 90).mapToObj(c -> String.valueOf((char)c)).collect(Collectors.joining());
    private static final char EXCHANGE_SEPARATOR = '&';
    private static final char ATTRIBUTES_OPEN = '{';
    private static final char ATTRIBUTES_CLOSE = '}';
    private static final char ATTRIBUTES_SEPARATOR = ',';
    private static final char ATTRIBUTE_VALUE = '=';

    private MarketEventSymbols() {
    }

    public static boolean hasExchangeCode(String symbol) {
        return symbol != null && MarketEventSymbols.hasExchangeCodeInternal(symbol, MarketEventSymbols.getLengthWithoutAttributesInternal(symbol));
    }

    @Description(value="Returns exchange code of the specified symbol or")
    public static char getExchangeCode(@Description(name="symbol", value="symbol.") String symbol) {
        return MarketEventSymbols.hasExchangeCode(symbol) ? symbol.charAt(MarketEventSymbols.getLengthWithoutAttributesInternal(symbol) - 1) : (char)'\u0000';
    }

    public static String changeExchangeCode(String symbol, char exchangeCode) {
        if (symbol == null) {
            return exchangeCode == '\u0000' ? null : "&" + exchangeCode;
        }
        int i = MarketEventSymbols.getLengthWithoutAttributesInternal(symbol);
        String result = exchangeCode == '\u0000' ? MarketEventSymbols.getBaseSymbolInternal(symbol, i) : MarketEventSymbols.getBaseSymbolInternal(symbol, i) + '&' + exchangeCode;
        return i == symbol.length() ? result : result + symbol.substring(i);
    }

    @Description(value="Returns base symbol without exchange code and attributes.")
    public static String getBaseSymbol(@Description(name="symbol", value="symbol.") String symbol) {
        if (symbol == null) {
            return null;
        }
        return MarketEventSymbols.getBaseSymbolInternal(symbol, MarketEventSymbols.getLengthWithoutAttributesInternal(symbol));
    }

    public static String changeBaseSymbol(String symbol, String baseSymbol) {
        if (symbol == null) {
            return baseSymbol;
        }
        int i = MarketEventSymbols.getLengthWithoutAttributesInternal(symbol);
        return MarketEventSymbols.hasExchangeCodeInternal(symbol, i) ? baseSymbol + '&' + symbol.charAt(i - 1) + symbol.substring(i) : (i == symbol.length() ? baseSymbol : baseSymbol + symbol.substring(i));
    }

    public static boolean hasAttributes(String symbol) {
        return symbol != null && MarketEventSymbols.getLengthWithoutAttributesInternal(symbol) < symbol.length();
    }

    @Description(value="Returns value of the attribute with the specified key.")
    public static String getAttributeStringByKey(@Description(name="symbol", value="symbol.") String symbol, @Description(name="key", value="attribute key.") String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (symbol == null) {
            return null;
        }
        return MarketEventSymbols.getAttributeInternal(symbol, MarketEventSymbols.getLengthWithoutAttributesInternal(symbol), key);
    }

    public static String changeAttributeStringByKey(String symbol, String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (symbol == null) {
            return value == null ? null : '{' + key + '=' + value + '}';
        }
        int i = MarketEventSymbols.getLengthWithoutAttributesInternal(symbol);
        if (i == symbol.length()) {
            return value == null ? symbol : symbol + '{' + key + '=' + value + '}';
        }
        return value == null ? MarketEventSymbols.removeAttributeInternal(symbol, i, key) : MarketEventSymbols.addAttributeInternal(symbol, i, key, value);
    }

    public static String removeAttributeStringByKey(String symbol, String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (symbol == null) {
            return null;
        }
        return MarketEventSymbols.removeAttributeInternal(symbol, MarketEventSymbols.getLengthWithoutAttributesInternal(symbol), key);
    }

    public static String buildSpreadSymbol(Map<String, ? extends Number> spread) {
        ArrayList<SpreadLeg> legs = new ArrayList<SpreadLeg>();
        for (Map.Entry<String, ? extends Number> e : spread.entrySet()) {
            if (e.getValue().doubleValue() == 0.0) continue;
            legs.add(new SpreadLeg(e.getKey(), e.getValue().doubleValue()));
        }
        if (legs.isEmpty()) {
            return "";
        }
        if (legs.size() == 1 && ((SpreadLeg)legs.get((int)0)).ratio == 1.0) {
            return ((SpreadLeg)legs.get((int)0)).symbol;
        }
        Collections.sort(legs);
        StringBuilder sb = new StringBuilder("=");
        for (SpreadLeg leg : legs) {
            double ratio = leg.ratio;
            if (ratio < 0.0) {
                sb.append('-');
            } else if (sb.length() > 1) {
                sb.append('+');
            }
            ratio = Math.abs(ratio);
            if (ratio != 1.0) {
                if (ratio == (double)((int)ratio)) {
                    sb.append((int)ratio);
                } else {
                    sb.append(ratio);
                }
                sb.append('*');
            }
            sb.append(leg.symbol);
        }
        return sb.toString();
    }

    @Description(value="Returns string with all exchange codes matching the specified character class.")
    public static String getExchangesByPattern(@Description(name="characterClass", value="regex character class.") String characterClass) {
        if (characterClass.isEmpty()) {
            return "";
        }
        if (characterClass.charAt(0) != '[' && characterClass.charAt(0) != '\\') {
            characterClass = '[' + characterClass + ']';
        }
        Pattern pattern = Pattern.compile(characterClass);
        String exchanges = IntStream.rangeClosed(0, 127).mapToObj(c -> String.valueOf((char)c)).filter(s -> pattern.matcher((CharSequence)s).matches()).collect(Collectors.joining());
        String unsupportedExchanges = exchanges.chars().mapToObj(c -> String.valueOf((char)c)).filter(s -> !EXCHANGES_PATTERN.matcher((CharSequence)s).matches()).collect(Collectors.joining(", "));
        if (!unsupportedExchanges.isEmpty()) {
            throw new IllegalArgumentException("Unsupported exchange codes: " + unsupportedExchanges);
        }
        return exchanges;
    }

    private static boolean hasExchangeCodeInternal(String symbol, int length) {
        return length >= 2 && symbol.charAt(length - 2) == '&';
    }

    private static String getBaseSymbolInternal(String symbol, int length) {
        return MarketEventSymbols.hasExchangeCodeInternal(symbol, length) ? symbol.substring(0, length - 2) : symbol.substring(0, length);
    }

    private static boolean hasAttributesInternal(String symbol, int length) {
        if (length >= 3 && symbol.charAt(length - 1) == '}') {
            int i = symbol.lastIndexOf(123, length - 2);
            return i >= 0 && i < length - 2;
        }
        return false;
    }

    private static int getLengthWithoutAttributesInternal(String symbol) {
        int length = symbol.length();
        return MarketEventSymbols.hasAttributesInternal(symbol, length) ? symbol.lastIndexOf(123) : length;
    }

    private static String getKeyInternal(String symbol, int i) {
        int val = symbol.indexOf(61, i);
        return val < 0 ? null : symbol.substring(i, val);
    }

    private static int getNextKeyInternal(String symbol, int i) {
        int val = symbol.indexOf(61, i) + 1;
        int sep = symbol.indexOf(44, val);
        return sep < 0 ? symbol.length() : sep + 1;
    }

    private static String getValueInternal(String symbol, int i, int j) {
        return symbol.substring(symbol.indexOf(61, i) + 1, j - 1);
    }

    private static String dropKeyAndValueInternal(String symbol, int length, int i, int j) {
        return j == symbol.length() ? (i == length + 1 ? symbol.substring(0, length) : symbol.substring(0, i - 1) + symbol.substring(j - 1)) : symbol.substring(0, i) + symbol.substring(j);
    }

    private static String getAttributeInternal(String symbol, int length, String key) {
        String cur;
        if (length == symbol.length()) {
            return null;
        }
        int i = length + 1;
        while (i < symbol.length() && (cur = MarketEventSymbols.getKeyInternal(symbol, i)) != null) {
            int j = MarketEventSymbols.getNextKeyInternal(symbol, i);
            if (key.equals(cur)) {
                return MarketEventSymbols.getValueInternal(symbol, i, j);
            }
            i = j;
        }
        return null;
    }

    private static String removeAttributeInternal(String symbol, int length, String key) {
        String cur;
        if (length == symbol.length()) {
            return symbol;
        }
        int i = length + 1;
        while (i < symbol.length() && (cur = MarketEventSymbols.getKeyInternal(symbol, i)) != null) {
            int j = MarketEventSymbols.getNextKeyInternal(symbol, i);
            if (key.equals(cur)) {
                symbol = MarketEventSymbols.dropKeyAndValueInternal(symbol, length, i, j);
                continue;
            }
            i = j;
        }
        return symbol;
    }

    private static String addAttributeInternal(String symbol, int length, String key, String value) {
        String cur;
        if (length == symbol.length()) {
            return symbol + '{' + key + '=' + value + '}';
        }
        int i = length + 1;
        boolean added = false;
        while (i < symbol.length() && (cur = MarketEventSymbols.getKeyInternal(symbol, i)) != null) {
            int j = MarketEventSymbols.getNextKeyInternal(symbol, i);
            int cmp = cur.compareTo(key);
            if (cmp == 0) {
                if (added) {
                    symbol = MarketEventSymbols.dropKeyAndValueInternal(symbol, length, i, j);
                    continue;
                }
                symbol = symbol.substring(0, i) + key + '=' + value + symbol.substring(j - 1);
                added = true;
                i += key.length() + value.length() + 2;
                continue;
            }
            if (cmp > 0 && !added) {
                symbol = symbol.substring(0, i) + key + '=' + value + ',' + symbol.substring(i);
                added = true;
                i += key.length() + value.length() + 2;
                continue;
            }
            i = j;
        }
        return added ? symbol : symbol.substring(0, i - 1) + ',' + key + '=' + value + symbol.substring(i - 1);
    }

    private static class SpreadLeg
    implements Comparable<SpreadLeg> {
        final String symbol;
        final double ratio;

        SpreadLeg(String symbol, double ratio) {
            this.symbol = symbol;
            this.ratio = ratio;
        }

        @Override
        public int compareTo(SpreadLeg other) {
            if (this.ratio > other.ratio) {
                return -1;
            }
            if (this.ratio < other.ratio) {
                return 1;
            }
            return this.symbol.compareTo(other.symbol) * (this.ratio >= 0.0 ? 1 : -1);
        }
    }
}

