/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.annotation.Description;
import com.dxfeed.event.market.IcebergType;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.Util;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="AnalyticOrder")
@XmlType(propOrder={"icebergPeakSize", "icebergHiddenSize", "icebergExecutedSize", "icebergType"})
@Description(value="Represents an extension of")
public class AnalyticOrder
extends Order {
    private static final long serialVersionUID = 0L;
    static final int ICEBERG_TYPE_MASK = 3;
    static final int ICEBERG_TYPE_SHIFT = 0;
    private double icebergPeakSize = Double.NaN;
    private double icebergHiddenSize = Double.NaN;
    private double icebergExecutedSize = Double.NaN;
    private int icebergFlags;

    public AnalyticOrder() {
    }

    public AnalyticOrder(String eventSymbol) {
        super(eventSymbol);
    }

    @Description(value="Returns iceberg peak size of this analytic order.")
    public double getIcebergPeakSize() {
        return this.icebergPeakSize;
    }

    public void setIcebergPeakSize(double icebergPeakSize) {
        this.icebergPeakSize = icebergPeakSize;
    }

    @Description(value="Returns iceberg hidden size of this analytic order.")
    public double getIcebergHiddenSize() {
        return this.icebergHiddenSize;
    }

    public void setIcebergHiddenSize(double icebergHiddenSize) {
        this.icebergHiddenSize = icebergHiddenSize;
    }

    @Description(value="Returns iceberg executed size of this analytic order.")
    public double getIcebergExecutedSize() {
        return this.icebergExecutedSize;
    }

    public void setIcebergExecutedSize(double icebergExecutedSize) {
        this.icebergExecutedSize = icebergExecutedSize;
    }

    @Description(value="Returns iceberg type of this analytic order.")
    public IcebergType getIcebergType() {
        return IcebergType.valueOf(Util.getBits(this.icebergFlags, 3, 0));
    }

    public void setIcebergType(IcebergType icebergType) {
        this.icebergFlags = Util.setBits(this.icebergFlags, 3, 0, icebergType.getCode());
    }

    @Override
    StringBuilder fieldsToString(StringBuilder sb) {
        return super.fieldsToString(sb).append(", icebergPeakSize=").append(this.icebergPeakSize).append(", icebergHiddenSize=").append(this.icebergHiddenSize).append(", icebergExecutedSize=").append(this.icebergExecutedSize).append(", icebergType=").append((Object)this.getIcebergType());
    }

    int getIcebergFlags() {
        return this.icebergFlags;
    }

    void setIcebergFlags(int icebergFlags) {
        this.icebergFlags = icebergFlags;
    }
}

