/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.impl;

import com.devexperts.annotation.Description;

@Description(value="A collection of static utility methods for manipulation of Java time in nanoseconds since Java epoch.")
public class TimeNanosUtil {
    private static final long NANOS_IN_MILLIS = 1000000L;

    private TimeNanosUtil() {
    }

    @Description(value="Returns time measured in nanoseconds since Java epoch from the time in milliseconds and its nano part.")
    public static long getNanosFromMillisAndNanoPart(@Description(name="timeMillis", value="time in milliseconds since Java epoch.") long timeMillis, @Description(name="timeNanoPart", value="nanoseconds part that shall lie within [0..999999] interval.") int timeNanoPart) {
        return timeMillis * 1000000L + (long)timeNanoPart;
    }

    @Description(value="Returns time measured in milliseconds since Java epoch from the time in nanoseconds.")
    public static long getMillisFromNanos(@Description(name="timeNanos", value="time measured in nanoseconds since Java epoch") long timeNanos) {
        return Math.floorDiv(timeNanos, 1000000L);
    }

    @Description(value="Returns nano part of time.")
    public static int getNanoPartFromNanos(@Description(name="timeNanos", value="time measured in nanoseconds since Java epoch") long timeNanos) {
        return (int)Math.floorMod(timeNanos, 1000000L);
    }
}

