/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import java.util.HashMap;
import java.util.Map;

@Description(value="Type of the candle aggregation period constitutes")
public enum CandleType {
    TICK("t", 0L),
    SECOND("s", 1000L),
    MINUTE("m", 60000L),
    HOUR("h", 3600000L),
    DAY("d", 86400000L),
    WEEK("w", 604800000L),
    MONTH("mo", 2592000000L),
    OPTEXP("o", 2592000000L),
    YEAR("y", 31536000000L),
    VOLUME("v", 0L),
    PRICE("p", 0L),
    PRICE_MOMENTUM("pm", 0L),
    PRICE_RENKO("pr", 0L);

    private final String string;
    private final long periodIntervalMillis;
    private static final Map<String, CandleType> BY_STRING;

    private CandleType(String string2, long periodIntervalMillis) {
        this.string = string2;
        this.periodIntervalMillis = periodIntervalMillis;
    }

    @Description(value="Returns candle type period in milliseconds as closely as possible.")
    public long getPeriodIntervalMillis() {
        return this.periodIntervalMillis;
    }

    public String toString() {
        return this.string;
    }

    public static CandleType parse(String s) {
        int n = s.length();
        if (n == 0) {
            throw new IllegalArgumentException("Missing candle type");
        }
        CandleType result = BY_STRING.get(s);
        if (result != null) {
            return result;
        }
        for (CandleType type : CandleType.values()) {
            String name = type.name();
            if (name.length() >= n && name.substring(0, n).equalsIgnoreCase(s)) {
                return type;
            }
            if (!s.endsWith("s") || !name.equalsIgnoreCase(s.substring(0, n - 1))) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown candle type: " + s);
    }

    static {
        BY_STRING = new HashMap<String, CandleType>();
        for (CandleType type : CandleType.values()) {
            BY_STRING.put(type.toString(), type);
        }
    }
}

