/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleAlignment;
import com.dxfeed.event.candle.CandleExchange;
import com.dxfeed.event.candle.CandlePeriod;
import com.dxfeed.event.candle.CandlePrice;
import com.dxfeed.event.candle.CandlePriceLevel;
import com.dxfeed.event.candle.CandleSession;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

@Description(value="Symbol that should be used with")
public class CandleSymbol
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String symbol;
    private transient String baseSymbol;
    transient CandleExchange exchange;
    transient CandlePrice price;
    transient CandleSession session;
    transient CandlePeriod period;
    transient CandleAlignment alignment;
    transient CandlePriceLevel priceLevel;

    private CandleSymbol(String symbol) {
        this.symbol = CandleSymbol.normalize(symbol);
        this.initTransientFields();
    }

    private CandleSymbol(String symbol, CandleSymbolAttribute<?> attribute) {
        this.symbol = CandleSymbol.normalize(CandleSymbol.changeAttribute(symbol, attribute));
        attribute.checkInAttributeImpl(this);
        this.initTransientFields();
    }

    private CandleSymbol(String symbol, CandleSymbolAttribute<?> attribute, CandleSymbolAttribute<?> ... attributes) {
        this.symbol = CandleSymbol.normalize(CandleSymbol.changeAttributes(symbol, attribute, attributes));
        attribute.checkInAttributeImpl(this);
        for (CandleSymbolAttribute<?> a : attributes) {
            a.checkInAttributeImpl(this);
        }
        this.initTransientFields();
    }

    @Description(value="Returns base market symbol without attributes.")
    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    @Description(value="Returns exchange attribute of this symbol.")
    public CandleExchange getExchange() {
        return this.exchange;
    }

    @Description(value="Returns price type attribute of this symbol.")
    public CandlePrice getPrice() {
        return this.price;
    }

    @Description(value="Returns session attribute of this symbol.")
    public CandleSession getSession() {
        return this.session;
    }

    @Description(value="Returns aggregation period of this symbol.")
    public CandlePeriod getPeriod() {
        return this.period;
    }

    @Description(value="Returns alignment attribute of this symbol.")
    public CandleAlignment getAlignment() {
        return this.alignment;
    }

    @Description(value="Returns price level attribute of this symbol.")
    public CandlePriceLevel getPriceLevel() {
        return this.priceLevel;
    }

    public String toString() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof CandleSymbol && this.symbol.equals(((CandleSymbol)o).symbol);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public static CandleSymbol valueOf(String symbol) {
        return new CandleSymbol(symbol);
    }

    public static CandleSymbol valueOf(String symbol, CandleSymbolAttribute<?> attribute) {
        return new CandleSymbol(symbol, attribute);
    }

    public static CandleSymbol valueOf(String symbol, CandleSymbolAttribute<?> attribute, CandleSymbolAttribute<?> ... attributes) {
        return new CandleSymbol(symbol, attribute, attributes);
    }

    private static String changeAttributes(String symbol, CandleSymbolAttribute<?> attribute, CandleSymbolAttribute<?> ... attributes) {
        symbol = CandleSymbol.changeAttribute(symbol, attribute);
        for (CandleSymbolAttribute<?> a : attributes) {
            symbol = CandleSymbol.changeAttribute(symbol, a);
        }
        return symbol;
    }

    private static String changeAttribute(String symbol, CandleSymbolAttribute<?> attribute) {
        return attribute.changeAttributeForSymbol(symbol);
    }

    private static String normalize(String symbol) {
        symbol = CandlePrice.normalizeAttributeForSymbol(symbol);
        symbol = CandleSession.normalizeAttributeForSymbol(symbol);
        symbol = CandlePeriod.normalizeAttributeForSymbol(symbol);
        symbol = CandleAlignment.normalizeAttributeForSymbol(symbol);
        symbol = CandlePriceLevel.normalizeAttributeForSymbol(symbol);
        return symbol;
    }

    private void initTransientFields() {
        this.baseSymbol = MarketEventSymbols.getBaseSymbol(this.symbol);
        if (this.exchange == null) {
            this.exchange = CandleExchange.getAttributeForSymbol(this.symbol);
        }
        if (this.price == null) {
            this.price = CandlePrice.getAttributeForSymbol(this.symbol);
        }
        if (this.session == null) {
            this.session = CandleSession.getAttributeForSymbol(this.symbol);
        }
        if (this.period == null) {
            this.period = CandlePeriod.getAttributeForSymbol(this.symbol);
        }
        if (this.alignment == null) {
            this.alignment = CandleAlignment.getAttributeForSymbol(this.symbol);
        }
        if (this.priceLevel == null) {
            this.priceLevel = CandlePriceLevel.getAttributeForSymbol(this.symbol);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientFields();
    }
}

