/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;
import com.dxfeed.schedule.SessionFilter;

@Description(value="Session attribute of")
public enum CandleSession implements CandleSymbolAttribute<CandleSession>
{
    ANY(SessionFilter.ANY, "false"),
    REGULAR(SessionFilter.REGULAR, "true");

    public static final CandleSession DEFAULT;
    public static final String ATTRIBUTE_KEY = "tho";
    private final SessionFilter sessionFilter;
    private final String string;

    private CandleSession(SessionFilter sessionFilter, String string2) {
        this.sessionFilter = sessionFilter;
        this.string = string2;
    }

    @Description(value="Returns session filter that corresponds to this session attribute.")
    public SessionFilter getSessionFilter() {
        return this.sessionFilter;
    }

    @Override
    public String changeAttributeForSymbol(String symbol) {
        return this == DEFAULT ? MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY) : MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, this.toString());
    }

    @Override
    public void checkInAttributeImpl(CandleSymbol candleSymbol) {
        if (candleSymbol.session != null) {
            throw new IllegalStateException("Already initialized");
        }
        candleSymbol.session = this;
    }

    public String toString() {
        return this.string;
    }

    public static CandleSession parse(String s) {
        int n = s.length();
        if (n == 0) {
            throw new IllegalArgumentException("Missing candle session");
        }
        for (CandleSession session : CandleSession.values()) {
            String ss = session.toString();
            if (ss.length() < n || !ss.substring(0, n).equalsIgnoreCase(s)) continue;
            return session;
        }
        throw new IllegalArgumentException("Unknown candle session: " + s);
    }

    @Description(value="Returns candle session attribute of the given candle symbol string.")
    public static CandleSession getAttributeForSymbol(@Description(name="symbol", value="candle symbol string.") String symbol) {
        String a = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        return a != null && Boolean.parseBoolean(a) ? REGULAR : DEFAULT;
    }

    public static String normalizeAttributeForSymbol(String symbol) {
        String a = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        if (a == null) {
            return symbol;
        }
        try {
            boolean b = Boolean.parseBoolean(a);
            if (!b) {
                MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY);
            }
            if (b && !a.equals(REGULAR.toString())) {
                return MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, REGULAR.toString());
            }
            return symbol;
        }
        catch (IllegalArgumentException e) {
            return symbol;
        }
    }

    static {
        DEFAULT = ANY;
    }
}

