/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;

@Description(value="Candle price level attribute of")
public class CandlePriceLevel
implements CandleSymbolAttribute<CandlePriceLevel> {
    public static final CandlePriceLevel DEFAULT = new CandlePriceLevel(Double.NaN);
    public static final String ATTRIBUTE_KEY = "pl";
    private final double value;

    private CandlePriceLevel(double value) {
        if (Double.isInfinite(value) || Double.compare(value, 0.0) < 0) {
            throw new IllegalArgumentException("Incorrect candle price level: " + value);
        }
        this.value = value;
    }

    @Description(value="Returns price level value.")
    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CandlePriceLevel)) {
            return false;
        }
        CandlePriceLevel that = (CandlePriceLevel)o;
        return Double.compare(this.value, that.value) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return this.value == (double)((long)this.value) ? Long.toString((long)this.value) : Double.toString(this.value);
    }

    @Override
    public String changeAttributeForSymbol(String symbol) {
        return this == DEFAULT ? MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY) : MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, this.toString());
    }

    @Override
    public void checkInAttributeImpl(CandleSymbol candleSymbol) {
        if (candleSymbol.priceLevel != null) {
            throw new IllegalStateException("Already initialized");
        }
        candleSymbol.priceLevel = this;
    }

    public static CandlePriceLevel parse(String s) {
        double value = Double.parseDouble(s);
        return CandlePriceLevel.valueOf(value);
    }

    public static CandlePriceLevel valueOf(double value) {
        return Double.isNaN(value) ? DEFAULT : new CandlePriceLevel(value);
    }

    @Description(value="Returns candle price level of the given candle symbol string.")
    public static CandlePriceLevel getAttributeForSymbol(@Description(name="symbol", value="candle symbol string.") String symbol) {
        String string = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        return string == null ? DEFAULT : CandlePriceLevel.parse(string);
    }

    public static String normalizeAttributeForSymbol(String symbol) {
        String a = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        if (a == null) {
            return symbol;
        }
        try {
            CandlePriceLevel other = CandlePriceLevel.parse(a);
            if (other == DEFAULT) {
                MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY);
            }
            if (!a.equals(other.toString())) {
                return MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, other.toString());
            }
            return symbol;
        }
        catch (IllegalArgumentException e) {
            return symbol;
        }
    }
}

