/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;
import java.util.HashMap;
import java.util.Map;

@Description(value="Price type attribute of")
public enum CandlePrice implements CandleSymbolAttribute<CandlePrice>
{
    LAST("last"),
    BID("bid"),
    ASK("ask"),
    MARK("mark"),
    SETTLEMENT("s");

    public static final CandlePrice DEFAULT;
    public static final String ATTRIBUTE_KEY = "price";
    private final String string;
    private static final Map<String, CandlePrice> BY_STRING;

    private CandlePrice(String string2) {
        this.string = string2;
    }

    @Override
    public String changeAttributeForSymbol(String symbol) {
        return this == DEFAULT ? MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY) : MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, this.toString());
    }

    @Override
    public void checkInAttributeImpl(CandleSymbol candleSymbol) {
        if (candleSymbol.price != null) {
            throw new IllegalStateException("Already initialized");
        }
        candleSymbol.price = this;
    }

    public String toString() {
        return this.string;
    }

    public static CandlePrice parse(String s) {
        int n = s.length();
        if (n == 0) {
            throw new IllegalArgumentException("Missing candle price");
        }
        CandlePrice result = BY_STRING.get(s);
        if (result != null) {
            return result;
        }
        for (CandlePrice price : CandlePrice.values()) {
            String ps = price.toString();
            if (ps.length() < n || !ps.substring(0, n).equalsIgnoreCase(s)) continue;
            return price;
        }
        throw new IllegalArgumentException("Unknown candle price: " + s);
    }

    @Description(value="Returns candle price type of the given candle symbol string.")
    public static CandlePrice getAttributeForSymbol(@Description(name="symbol", value="candle symbol string.") String symbol) {
        String string = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        return string == null ? DEFAULT : CandlePrice.parse(string);
    }

    public static String normalizeAttributeForSymbol(String symbol) {
        String a = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        if (a == null) {
            return symbol;
        }
        try {
            CandlePrice other = CandlePrice.parse(a);
            if (other == DEFAULT) {
                MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY);
            }
            if (!a.equals(other.toString())) {
                return MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, other.toString());
            }
            return symbol;
        }
        catch (IllegalArgumentException e) {
            return symbol;
        }
    }

    static {
        DEFAULT = LAST;
        BY_STRING = new HashMap<String, CandlePrice>();
        for (CandlePrice price : CandlePrice.values()) {
            BY_STRING.put(price.toString(), price);
        }
    }
}

