/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.candle.CandleType;
import com.dxfeed.event.market.MarketEventSymbols;
import java.io.ObjectStreamException;
import java.io.Serializable;

@Description(value="Period attribute of")
public class CandlePeriod
implements CandleSymbolAttribute<CandlePeriod>,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final CandlePeriod TICK = new CandlePeriod(1.0, CandleType.TICK);
    public static final CandlePeriod DAY = new CandlePeriod(1.0, CandleType.DAY);
    public static final CandlePeriod DEFAULT = TICK;
    public static final String ATTRIBUTE_KEY = "";
    private final double value;
    private final CandleType type;
    private String string;

    private CandlePeriod(double value, CandleType type) {
        this.value = value;
        this.type = type;
    }

    @Description(value="Returns aggregation period in milliseconds as closely as possible.")
    public long getPeriodIntervalMillis() {
        return (long)((double)this.type.getPeriodIntervalMillis() * this.value);
    }

    @Override
    public String changeAttributeForSymbol(String symbol) {
        return this == DEFAULT ? MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY) : MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, this.toString());
    }

    @Override
    public void checkInAttributeImpl(CandleSymbol candleSymbol) {
        if (candleSymbol.period != null) {
            throw new IllegalStateException("Already initialized");
        }
        candleSymbol.period = this;
    }

    @Description(value="Returns aggregation period value.")
    public double getValue() {
        return this.value;
    }

    @Description(value="Returns aggregation period type.")
    public CandleType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CandlePeriod)) {
            return false;
        }
        CandlePeriod that = (CandlePeriod)o;
        return Double.compare(this.value, that.value) == 0 && this.type == that.type;
    }

    public int hashCode() {
        return 31 * Double.hashCode(this.value) + this.type.hashCode();
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.value == 1.0 ? this.type.toString() : (this.value == (double)((long)this.value) ? (long)this.value + ATTRIBUTE_KEY + (Object)((Object)this.type) : this.value + ATTRIBUTE_KEY + (Object)((Object)this.type));
        }
        return this.string;
    }

    public static CandlePeriod parse(String s) {
        char c;
        int i;
        if (s.equals(CandleType.DAY.toString())) {
            return DAY;
        }
        if (s.equals(CandleType.TICK.toString())) {
            return TICK;
        }
        for (i = 0; i < s.length() && ((c = s.charAt(i)) >= '0' && c <= '9' || c == '.' || c == '-' || c == '+' || c == 'e' || c == 'E'); ++i) {
        }
        String value = s.substring(0, i);
        String type = s.substring(i);
        return CandlePeriod.valueOf(value.isEmpty() ? 1.0 : Double.parseDouble(value), CandleType.parse(type));
    }

    public static CandlePeriod valueOf(double value, CandleType type) {
        if (value == 1.0 && type == CandleType.DAY) {
            return DAY;
        }
        if (value == 1.0 && type == CandleType.TICK) {
            return TICK;
        }
        return new CandlePeriod(value, type);
    }

    @Description(value="Returns candle period of the given candle symbol string.")
    public static CandlePeriod getAttributeForSymbol(@Description(name="symbol", value="candle symbol string.") String symbol) {
        String string = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        return string == null ? DEFAULT : CandlePeriod.parse(string);
    }

    public static String normalizeAttributeForSymbol(String symbol) {
        String a = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        if (a == null) {
            return symbol;
        }
        try {
            CandlePeriod other = CandlePeriod.parse(a);
            if (other.equals(DEFAULT)) {
                MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY);
            }
            if (!a.equals(other.toString())) {
                return MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, other.toString());
            }
            return symbol;
        }
        catch (IllegalArgumentException e) {
            return symbol;
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.value == 1.0 && this.type == CandleType.DAY) {
            return DAY;
        }
        if (this.value == 1.0 && this.type == CandleType.TICK) {
            return TICK;
        }
        return this;
    }
}

