/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;
import java.io.ObjectStreamException;
import java.io.Serializable;

@Description(value="Exchange attribute of")
public class CandleExchange
implements CandleSymbolAttribute<CandleExchange>,
Serializable {
    private static final long serialVersionUID = 0L;
    public static final CandleExchange COMPOSITE;
    public static final CandleExchange DEFAULT;
    private final char exchangeCode;

    private CandleExchange(char exchangeCode) {
        this.exchangeCode = exchangeCode;
    }

    @Description(value="Returns exchange code.")
    public char getExchangeCode() {
        return this.exchangeCode;
    }

    public String toString() {
        return this.exchangeCode == '\u0000' ? "COMPOSITE" : "" + this.exchangeCode;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof CandleExchange && this.exchangeCode == ((CandleExchange)o).exchangeCode;
    }

    public int hashCode() {
        return this.exchangeCode;
    }

    @Override
    public String changeAttributeForSymbol(String symbol) {
        return MarketEventSymbols.changeExchangeCode(symbol, this.exchangeCode);
    }

    @Override
    public void checkInAttributeImpl(CandleSymbol candleSymbol) {
        if (candleSymbol.exchange != null) {
            throw new IllegalStateException("Already initialized");
        }
        candleSymbol.exchange = this;
    }

    public static CandleExchange valueOf(char exchangeCode) {
        return exchangeCode == '\u0000' ? COMPOSITE : new CandleExchange(exchangeCode);
    }

    @Description(value="Returns exchange attribute object of the given candle symbol string.")
    public static CandleExchange getAttributeForSymbol(@Description(name="symbol", value="candle symbol string.") String symbol) {
        return CandleExchange.valueOf(MarketEventSymbols.getExchangeCode(symbol));
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.exchangeCode == '\u0000') {
            return COMPOSITE;
        }
        return this;
    }

    static {
        DEFAULT = COMPOSITE = new CandleExchange('\u0000');
    }
}

