/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.event.candle.CandleSymbolAttribute;
import com.dxfeed.event.market.MarketEventSymbols;
import java.util.HashMap;
import java.util.Map;

@Description(value="Candle alignment attribute of")
public enum CandleAlignment implements CandleSymbolAttribute<CandleAlignment>
{
    MIDNIGHT("m"),
    SESSION("s");

    public static final CandleAlignment DEFAULT;
    public static final String ATTRIBUTE_KEY = "a";
    private final String string;
    private static final Map<String, CandleAlignment> BY_STRING;

    private CandleAlignment(String string2) {
        this.string = string2;
    }

    @Override
    public String changeAttributeForSymbol(String symbol) {
        return this == DEFAULT ? MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY) : MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, this.toString());
    }

    @Override
    public void checkInAttributeImpl(CandleSymbol candleSymbol) {
        if (candleSymbol.alignment != null) {
            throw new IllegalStateException("Already initialized");
        }
        candleSymbol.alignment = this;
    }

    public String toString() {
        return this.string;
    }

    public static CandleAlignment parse(String s) {
        CandleAlignment result = BY_STRING.get(s);
        if (result != null) {
            return result;
        }
        for (CandleAlignment align : CandleAlignment.values()) {
            if (!align.toString().equalsIgnoreCase(s)) continue;
            return align;
        }
        throw new IllegalArgumentException("Unknown candle alignment: " + s);
    }

    @Description(value="Returns candle alignment of the given candle symbol string.")
    public static CandleAlignment getAttributeForSymbol(@Description(name="symbol", value="candle symbol string.") String symbol) {
        String string = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        return string == null ? DEFAULT : CandleAlignment.parse(string);
    }

    public static String normalizeAttributeForSymbol(String symbol) {
        String a = MarketEventSymbols.getAttributeStringByKey(symbol, ATTRIBUTE_KEY);
        if (a == null) {
            return symbol;
        }
        try {
            CandleAlignment other = CandleAlignment.parse(a);
            if (other == DEFAULT) {
                MarketEventSymbols.removeAttributeStringByKey(symbol, ATTRIBUTE_KEY);
            }
            if (!a.equals(other.toString())) {
                return MarketEventSymbols.changeAttributeStringByKey(symbol, ATTRIBUTE_KEY, other.toString());
            }
            return symbol;
        }
        catch (IllegalArgumentException e) {
            return symbol;
        }
    }

    static {
        DEFAULT = MIDNIGHT;
        BY_STRING = new HashMap<String, CandleAlignment>();
        for (CandleAlignment align : CandleAlignment.values()) {
            BY_STRING.put(align.toString(), align);
        }
    }
}

