/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.candle;

import com.devexperts.annotation.Description;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.event.candle.CandleSymbol;
import com.dxfeed.impl.XmlCandleSymbolAdapter;
import com.dxfeed.impl.XmlTimeAdapter;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement(name="Candle")
@XmlType(propOrder={"eventSymbol", "eventTime", "eventFlags", "index", "time", "sequence", "count", "open", "high", "low", "close", "volumeAsDouble", "VWAP", "bidVolumeAsDouble", "askVolumeAsDouble", "impVolatility", "openInterestAsDouble"})
@Description(value="Candle event with open, high, low, close prices and other information for a specific period.")
public class Candle
implements TimeSeriesEvent<CandleSymbol>,
LastingEvent<CandleSymbol> {
    private static final long serialVersionUID = 3L;
    public static final int MAX_SEQUENCE = 0x3FFFFF;
    private CandleSymbol eventSymbol;
    private int eventFlags;
    private long eventTime;
    private long index;
    private long count;
    private double open = Double.NaN;
    private double high = Double.NaN;
    private double low = Double.NaN;
    private double close = Double.NaN;
    private double volume = Double.NaN;
    private double vwap = Double.NaN;
    private double bidVolume = Double.NaN;
    private double askVolume = Double.NaN;
    private double impVolatility = Double.NaN;
    private double openInterest = Double.NaN;

    public Candle() {
    }

    public Candle(CandleSymbol eventSymbol) {
        this.eventSymbol = eventSymbol;
    }

    @Override
    @XmlJavaTypeAdapter(type=CandleSymbol.class, value=XmlCandleSymbolAdapter.class)
    @XmlSchemaType(name="string")
    @Description(value="Returns candle event symbol.")
    public CandleSymbol getEventSymbol() {
        return this.eventSymbol;
    }

    @Override
    public void setEventSymbol(CandleSymbol eventSymbol) {
        this.eventSymbol = eventSymbol;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public long getEventTime() {
        return this.eventTime;
    }

    @Override
    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    @Override
    @XmlTransient
    @Description(value="{@inheritDoc}")
    public IndexedEventSource getSource() {
        return IndexedEventSource.DEFAULT;
    }

    @Override
    @Description(value="{@inheritDoc}")
    public int getEventFlags() {
        return this.eventFlags;
    }

    @Override
    public void setEventFlags(int eventFlags) {
        this.eventFlags = eventFlags;
    }

    @Override
    @Description(value="Returns unique per-symbol index of this candle event.")
    public long getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(long index) {
        this.index = index;
    }

    public void setEventId(long index) {
        this.setIndex(index);
    }

    @Override
    @XmlJavaTypeAdapter(type=long.class, value=XmlTimeAdapter.class)
    @XmlSchemaType(name="dateTime")
    @Description(value="Returns timestamp of the candle in milliseconds.")
    public long getTime() {
        return (this.index >> 32) * 1000L + (this.index >> 22 & 0x3FFL);
    }

    public void setTime(long time) {
        this.index = (long)TimeUtil.getSecondsFromTime(time) << 32 | (long)TimeUtil.getMillisFromTime(time) << 22 | (long)this.getSequence();
    }

    @Description(value="Returns sequence number of this event to distinguish events that have the same")
    public int getSequence() {
        return (int)this.index & 0x3FFFFF;
    }

    public void setSequence(int sequence) {
        if (sequence < 0 || sequence > 0x3FFFFF) {
            throw new IllegalArgumentException();
        }
        this.index = this.index & 0xFFFFFFFFFFC00000L | (long)sequence;
    }

    @Description(value="Returns total number of original trade (or quote) events in this candle.")
    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @Description(value="Returns the first (open) price of this candle.")
    public double getOpen() {
        return this.open;
    }

    public void setOpen(double open) {
        this.open = open;
    }

    @Description(value="Returns the maximal (high) price of this candle.")
    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    @Description(value="Returns the minimal (low) price of this candle.")
    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    @Description(value="Returns the last (close) price of this candle.")
    public double getClose() {
        return this.close;
    }

    public void setClose(double close) {
        this.close = close;
    }

    @XmlTransient
    @Description(value="Returns total volume in this candle.")
    public long getVolume() {
        return (long)this.volume;
    }

    public void setVolume(long volume) {
        this.volume = volume;
    }

    @XmlElement(name="volume")
    @Description(value="Returns total volume in this candle as floating number with fractions.")
    public double getVolumeAsDouble() {
        return this.volume;
    }

    public void setVolumeAsDouble(double volume) {
        this.volume = volume;
    }

    @XmlElement(name="vwap")
    @Description(value="Returns volume-weighted average price (VWAP) in this candle.")
    public double getVWAP() {
        return this.vwap;
    }

    public void setVWAP(double vwap) {
        this.vwap = vwap;
    }

    @XmlTransient
    @Description(value="Returns bid volume in this candle.")
    public long getBidVolume() {
        return (long)this.bidVolume;
    }

    public void setBidVolume(long bidVolume) {
        this.bidVolume = bidVolume;
    }

    @XmlElement(name="bidVolume")
    @Description(value="Returns bid volume in this candle as floating number with fractions.")
    public double getBidVolumeAsDouble() {
        return this.bidVolume;
    }

    public void setBidVolumeAsDouble(double bidVolume) {
        this.bidVolume = bidVolume;
    }

    @XmlTransient
    @Description(value="Returns ask volume in this candle.")
    public long getAskVolume() {
        return (long)this.askVolume;
    }

    public void setAskVolume(long askVolume) {
        this.askVolume = askVolume;
    }

    @XmlElement(name="askVolume")
    @Description(value="Returns ask volume in this candle as floating number with fractions.")
    public double getAskVolumeAsDouble() {
        return this.askVolume;
    }

    public void setAskVolumeAsDouble(double askVolume) {
        this.askVolume = askVolume;
    }

    @Description(value="Returns implied volatility.")
    public double getImpVolatility() {
        return this.impVolatility;
    }

    public void setImpVolatility(double impVolatility) {
        this.impVolatility = impVolatility;
    }

    @XmlTransient
    @Description(value="Returns open interest.")
    public long getOpenInterest() {
        return (long)this.openInterest;
    }

    public void setOpenInterest(long openInterest) {
        this.openInterest = openInterest;
    }

    @XmlElement(name="openInterest")
    @Description(value="Returns open interest as floating number with fractions.")
    public double getOpenInterestAsDouble() {
        return this.openInterest;
    }

    public void setOpenInterestAsDouble(double openInterest) {
        this.openInterest = openInterest;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.baseFieldsToString() + "}";
    }

    String baseFieldsToString() {
        return this.eventSymbol + ", eventTime=" + TimeFormat.DEFAULT.withMillis().format(this.getEventTime()) + ", eventFlags=0x" + Integer.toHexString(this.getEventFlags()) + ", time=" + TimeFormat.DEFAULT.withMillis().format(this.getTime()) + ", sequence=" + this.getSequence() + ", count=" + this.count + ", open=" + this.open + ", high=" + this.high + ", low=" + this.low + ", close=" + this.close + ", volume=" + this.volume + ", vwap=" + this.vwap + ", bidVolume=" + this.bidVolume + ", askVolume=" + this.askVolume + ", impVolatility=" + this.impVolatility + ", openInterest=" + this.openInterest + "";
    }
}

