/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api;

import com.devexperts.io.IOUtil;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXFeedEventListener;
import com.dxfeed.api.FilteredSubscriptionSymbol;
import com.dxfeed.api.osub.ObservableSubscription;
import com.dxfeed.api.osub.ObservableSubscriptionChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DXFeedSubscription<E>
implements Serializable,
ObservableSubscription<E>,
AutoCloseable {
    private static final long serialVersionUID = 0L;
    private volatile boolean closed;
    private transient Set<Class<? extends E>> eventTypeSet;
    private transient IndexerFunction<Object, Object> eventSymbolIndexer;
    private transient IndexedSet<Object, Object> symbols;
    private transient ObservableSubscriptionChangeListener changeListeners;
    private volatile transient Executor executor;
    private volatile transient DXFeedEventListener<E> eventListeners;
    private transient Set<?> undecoratedSymbols;
    private transient Set<?> decoratedSymbols;

    public DXFeedSubscription(Class<? extends E> eventType) {
        this.init(eventType);
    }

    @SafeVarargs
    public DXFeedSubscription(Class<? extends E> ... eventTypes) {
        this.init(eventTypes);
    }

    public void attach(DXFeed feed) {
        feed.attachSubscription(this);
    }

    public void detach(DXFeed feed) {
        feed.detachSubscription(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.eventListeners = null;
        ObservableSubscriptionChangeListener notifyListeners = this.changeListeners;
        this.changeListeners = null;
        if (notifyListeners != null) {
            notifyListeners.subscriptionClosed();
        }
    }

    @Override
    public Set<Class<? extends E>> getEventTypes() {
        return this.eventTypeSet;
    }

    @Override
    public boolean containsEventType(Class<?> eventType) {
        return this.eventTypeSet.contains(eventType);
    }

    public void clear() {
        this.setSymbols(Collections.EMPTY_LIST);
    }

    public Set<?> getSymbols() {
        if (this.undecoratedSymbols == null) {
            this.undecoratedSymbols = new SymbolView(true);
        }
        return this.undecoratedSymbols;
    }

    public Set<?> getDecoratedSymbols() {
        if (this.decoratedSymbols == null) {
            this.decoratedSymbols = new SymbolView(false);
        }
        return this.decoratedSymbols;
    }

    public void setSymbols(Collection<?> symbols) {
        this.setSymbolsImpl(this.decorateSymbols(symbols));
    }

    public void setSymbols(Object ... symbols) {
        this.setSymbolsImpl(this.decorateSymbols(symbols));
    }

    public void addSymbols(Collection<?> symbols) {
        if (symbols.isEmpty()) {
            return;
        }
        this.addSymbolsImpl(this.decorateSymbols(symbols));
    }

    public void addSymbols(Object ... symbols) {
        if (symbols.length == 0) {
            return;
        }
        if (symbols.length == 1) {
            this.addSymbolImpl(this.decorateSymbol(symbols[0]));
        } else {
            this.addSymbolsImpl(this.decorateSymbols(symbols));
        }
    }

    public void addSymbols(Object symbol) {
        this.addSymbolImpl(this.decorateSymbol(symbol));
    }

    public void removeSymbols(Collection<?> symbols) {
        if (symbols.isEmpty()) {
            return;
        }
        this.removeSymbolsImpl(this.decorateSymbols(symbols));
    }

    public void removeSymbols(Object ... symbols) {
        if (symbols.length == 0) {
            return;
        }
        this.removeSymbolsImpl(this.decorateSymbols(symbols));
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public synchronized void addEventListener(DXFeedEventListener<E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            return;
        }
        if (this.changeListeners != null && !this.symbols.isEmpty()) {
            throw new IllegalStateException("Cannot add event listener to non-empty attached subscription. Add event listeners first");
        }
        this.eventListeners = DXFeedSubscription.addListener(this.eventListeners, listener, false, EventListeners::new);
    }

    public synchronized void removeEventListener(DXFeedEventListener<E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.eventListeners = DXFeedSubscription.removeListener(this.eventListeners, listener, EventListeners::new);
    }

    @Override
    public synchronized void addChangeListener(ObservableSubscriptionChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            return;
        }
        ObservableSubscriptionChangeListener oldListeners = this.changeListeners;
        this.changeListeners = DXFeedSubscription.addListener(this.changeListeners, listener, true, ChangeListeners::new);
        if (this.changeListeners != oldListeners && !this.symbols.isEmpty()) {
            listener.symbolsAdded(this.symbols);
        }
    }

    @Override
    public synchronized void removeChangeListener(ObservableSubscriptionChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        ObservableSubscriptionChangeListener oldListeners = this.changeListeners;
        this.changeListeners = DXFeedSubscription.removeListener(this.changeListeners, listener, ChangeListeners::new);
        if (this.changeListeners != oldListeners) {
            listener.subscriptionClosed();
        }
    }

    void processEvents(List<E> events) {
        DXFeedEventListener<E> eventListeners = this.eventListeners;
        if (eventListeners != null) {
            eventListeners.eventsReceived(events);
        }
    }

    protected Object decorateSymbol(Object symbol) {
        if (symbol == null) {
            throw new NullPointerException();
        }
        return symbol;
    }

    protected Object undecorateSymbol(Object symbol) {
        if (symbol == null) {
            throw new NullPointerException();
        }
        return symbol;
    }

    private static void writeCompactCollection(ObjectOutput out, Collection<?> collection) throws IOException {
        IOUtil.writeCompactInt(out, collection.size());
        for (Object o : collection) {
            out.writeObject(o);
        }
    }

    private static <T> T[] readCompactCollection(ObjectInput in) throws IOException, ClassNotFoundException {
        int n = IOUtil.readCompactInt(in);
        Object[] a = new Object[n];
        for (int i = 0; i < n; ++i) {
            a[i] = in.readObject();
        }
        return a;
    }

    @SafeVarargs
    private final void init(Class<? extends E> ... eventTypes) {
        if (eventTypes.length == 0) {
            throw new IllegalArgumentException();
        }
        if (eventTypes.length == 1) {
            this.eventTypeSet = Collections.singleton(Objects.requireNonNull(eventTypes[0]));
        } else {
            IndexedSet set = IndexedSet.create();
            for (Class<? extends E> eventType : eventTypes) {
                set.add(Objects.requireNonNull(eventType));
            }
            this.eventTypeSet = Collections.unmodifiableSet(set);
        }
        this.eventSymbolIndexer = this.getClass() == DXFeedSubscription.class ? IndexerFunction.DEFAULT : this::undecorateSymbol;
        this.symbols = IndexedSet.create(this.eventSymbolIndexer);
    }

    private IndexedSet<Object, Object> decorateSymbols(Collection<?> symbols) {
        return symbols.stream().map(this::decorateSymbol).collect(IndexedSet.collector(this.eventSymbolIndexer));
    }

    private IndexedSet<Object, Object> decorateSymbols(Object ... symbols) {
        return Arrays.stream(symbols).map(this::decorateSymbol).collect(IndexedSet.collector(this.eventSymbolIndexer));
    }

    private synchronized void setSymbolsImpl(IndexedSet<Object, Object> added) {
        IndexedSet<Object, Object> removed = IndexedSet.create(this.eventSymbolIndexer);
        Iterator<Object> it = this.symbols.iterator();
        while (it.hasNext()) {
            Object oldSymbol = it.next();
            if (added.containsValue(oldSymbol)) continue;
            it.remove();
            removed.add(oldSymbol);
        }
        this.addAndNotify(added, removed);
    }

    private synchronized void addSymbolsImpl(IndexedSet<Object, Object> added) {
        this.addAndNotify(added, null);
    }

    private void addAndNotify(IndexedSet<Object, Object> added, IndexedSet<Object, Object> removed) {
        added.removeIf(o -> !this.putSymbol(o));
        if (this.changeListeners != null && removed != null && !removed.isEmpty()) {
            this.changeListeners.symbolsRemoved(removed);
        }
        if (this.changeListeners != null && !added.isEmpty()) {
            this.changeListeners.symbolsAdded(added);
        }
    }

    private synchronized void addSymbolImpl(Object symbol) {
        if (!this.putSymbol(symbol)) {
            return;
        }
        if (this.changeListeners != null) {
            this.changeListeners.symbolsAdded(Collections.singleton(symbol));
        }
    }

    private boolean putSymbol(Object symbol) {
        Object oldSymbol = this.symbols.put(symbol);
        return this.shallNotifyOnSymbolUpdate(symbol, oldSymbol);
    }

    protected boolean shallNotifyOnSymbolUpdate(@Nonnull Object symbol, @Nullable Object oldSymbol) {
        return symbol instanceof FilteredSubscriptionSymbol ? symbol != oldSymbol : oldSymbol == null;
    }

    private synchronized void removeSymbolsImpl(IndexedSet<Object, Object> removed) {
        Iterator<Object> it = removed.concurrentIterator();
        while (it.hasNext()) {
            Object symbol = it.next();
            Object oldSymbol = this.symbols.removeValue(symbol);
            if (oldSymbol == null) {
                removed.remove(symbol);
                continue;
            }
            if (oldSymbol == symbol) continue;
            removed.add(oldSymbol);
        }
        if (removed.isEmpty()) {
            return;
        }
        if (this.changeListeners != null) {
            this.changeListeners.symbolsRemoved(removed);
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        DXFeedSubscription.writeCompactCollection(out, this.eventTypeSet);
        DXFeedSubscription.writeCompactCollection(out, this.symbols);
        DXFeedSubscription.writeCompactCollection(out, DXFeedSubscription.getSerializable(this.eventListeners));
        DXFeedSubscription.writeCompactCollection(out, DXFeedSubscription.getSerializable(this.changeListeners));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        T[] eventTypes = DXFeedSubscription.readCompactCollection(in);
        this.init((Class[])Arrays.copyOf(eventTypes, eventTypes.length, Class[].class));
        Collections.addAll(this.symbols, DXFeedSubscription.readCompactCollection(in));
        this.eventListeners = DXFeedSubscription.simplifyListener(DXFeedSubscription.readCompactCollection(in), EventListeners::new);
        this.changeListeners = DXFeedSubscription.simplifyListener(DXFeedSubscription.readCompactCollection(in), ChangeListeners::new);
    }

    private static Collection<Object> getSerializable(Object oneOrList) {
        if (oneOrList instanceof Serializable) {
            return Collections.singletonList(oneOrList);
        }
        if (oneOrList instanceof ListenerList) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : ((ListenerList)oneOrList).a) {
                if (!(o instanceof Serializable)) continue;
                result.add(o);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private static <L> L simplifyListener(Object[] a, Function<Object[], L> listWrapper) {
        return (L)(a.length == 0 ? null : (a.length == 1 ? a[0] : listWrapper.apply(a)));
    }

    private static <L> L addListener(L oneOrList, L listener, boolean idempotent, Function<Object[], L> listWrapper) {
        if (oneOrList == null) {
            return listener;
        }
        if (idempotent && listener.equals(oneOrList)) {
            return oneOrList;
        }
        if (!(oneOrList instanceof ListenerList)) {
            return listWrapper.apply(new Object[]{oneOrList, listener});
        }
        ListenerList list = (ListenerList)oneOrList;
        if (idempotent && DXFeedSubscription.findListener(list, listener) >= 0) {
            return oneOrList;
        }
        Object[] a = Arrays.copyOf(list.a, list.a.length + 1);
        a[a.length - 1] = listener;
        return listWrapper.apply(a);
    }

    private static <L> L removeListener(L oneOrList, L listener, Function<Object[], L> listWrapper) {
        if (oneOrList == null) {
            return null;
        }
        if (listener.equals(oneOrList)) {
            return null;
        }
        if (!(oneOrList instanceof ListenerList)) {
            return oneOrList;
        }
        ListenerList list = (ListenerList)oneOrList;
        int i = DXFeedSubscription.findListener(list, listener);
        if (i < 0) {
            return oneOrList;
        }
        return (L)(list.a.length == 2 ? list.a[1 - i] : listWrapper.apply(DXFeedSubscription.removeListenerAt(list, i)));
    }

    static <L> int findListener(ListenerList<L> oldList, L newListener) {
        for (int i = 0; i < oldList.a.length; ++i) {
            if (!newListener.equals(oldList.a[i])) continue;
            return i;
        }
        return -1;
    }

    static <L> Object[] removeListenerAt(ListenerList<L> oldList, int removeIndex) {
        Object[] a = new Object[oldList.a.length - 1];
        System.arraycopy(oldList.a, 0, a, 0, removeIndex);
        System.arraycopy(oldList.a, removeIndex + 1, a, removeIndex, oldList.a.length - removeIndex - 1);
        return a;
    }

    static void rethrow(Throwable error) {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        if (error instanceof Error) {
            throw (Error)error;
        }
    }

    private static class ChangeListeners
    extends ListenerList<ObservableSubscriptionChangeListener>
    implements ObservableSubscriptionChangeListener {
        ChangeListeners(Object[] a) {
            super(a);
        }

        @Override
        public void symbolsAdded(Set<?> symbols) {
            Throwable error = null;
            for (Object listener : this.a) {
                try {
                    ((ObservableSubscriptionChangeListener)listener).symbolsAdded(symbols);
                }
                catch (Error | RuntimeException e) {
                    error = e;
                }
            }
            DXFeedSubscription.rethrow(error);
        }

        @Override
        public void symbolsRemoved(Set<?> symbols) {
            Throwable error = null;
            for (Object listener : this.a) {
                try {
                    ((ObservableSubscriptionChangeListener)listener).symbolsRemoved(symbols);
                }
                catch (Error | RuntimeException e) {
                    error = e;
                }
            }
            DXFeedSubscription.rethrow(error);
        }

        @Override
        public void subscriptionClosed() {
            Throwable error = null;
            for (Object listener : this.a) {
                try {
                    ((ObservableSubscriptionChangeListener)listener).subscriptionClosed();
                }
                catch (Error | RuntimeException e) {
                    error = e;
                }
            }
            DXFeedSubscription.rethrow(error);
        }
    }

    private static class EventListeners<E>
    extends ListenerList<DXFeedEventListener<E>>
    implements DXFeedEventListener<E> {
        EventListeners(Object[] a) {
            super(a);
        }

        @Override
        public void eventsReceived(List<E> events) {
            Throwable error = null;
            for (Object listener : this.a) {
                try {
                    ((DXFeedEventListener)listener).eventsReceived(events);
                }
                catch (Error | RuntimeException e) {
                    error = e;
                }
            }
            DXFeedSubscription.rethrow(error);
        }
    }

    private static abstract class ListenerList<L> {
        final Object[] a;

        protected ListenerList(Object[] a) {
            this.a = a;
        }
    }

    private class SymbolViewIterator
    implements Iterator<Object> {
        private final boolean undecorate;
        private final Iterator<Object> it;

        SymbolViewIterator(boolean undecorate, Iterator<Object> it) {
            this.undecorate = undecorate;
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            Object next = this.it.next();
            return this.undecorate ? DXFeedSubscription.this.undecorateSymbol(next) : next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SymbolView
    extends AbstractSet<Object> {
        private final boolean undecorate;

        public SymbolView(boolean undecorate) {
            this.undecorate = undecorate;
        }

        @Override
        @Nonnull
        public Iterator<Object> iterator() {
            return new SymbolViewIterator(this.undecorate, DXFeedSubscription.this.symbols.concurrentIterator());
        }

        @Override
        public int size() {
            return DXFeedSubscription.this.symbols.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.undecorate ? DXFeedSubscription.this.symbols.containsKey(o) : DXFeedSubscription.this.symbols.containsValue(o);
        }
    }
}

