/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api;

import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.DXFeedSubscription;
import com.dxfeed.api.DXFeedTimeSeriesSubscription;
import com.dxfeed.event.IndexedEvent;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.LastingEvent;
import com.dxfeed.event.TimeSeriesEvent;
import com.dxfeed.promise.Promise;
import java.util.Collection;
import java.util.List;

public abstract class DXFeed {
    protected DXFeed() {
    }

    public static DXFeed getInstance() {
        return DXEndpoint.getInstance().getFeed();
    }

    public final <E> DXFeedSubscription<E> createSubscription(Class<? extends E> eventType) {
        DXFeedSubscription<? extends E> subscription = new DXFeedSubscription<E>(eventType);
        this.attachSubscription(subscription);
        return subscription;
    }

    @SafeVarargs
    public final <E> DXFeedSubscription<E> createSubscription(Class<? extends E> ... eventTypes) {
        DXFeedSubscription<? extends E> subscription = new DXFeedSubscription<E>(eventTypes);
        this.attachSubscription(subscription);
        return subscription;
    }

    public final <E extends TimeSeriesEvent<?>> DXFeedTimeSeriesSubscription<E> createTimeSeriesSubscription(Class<? extends E> eventType) {
        DXFeedTimeSeriesSubscription<? extends E> subscription = new DXFeedTimeSeriesSubscription<E>(eventType);
        this.attachSubscription(subscription);
        return subscription;
    }

    @SafeVarargs
    public final <E extends TimeSeriesEvent<?>> DXFeedTimeSeriesSubscription<E> createTimeSeriesSubscription(Class<? extends E> ... eventTypes) {
        DXFeedTimeSeriesSubscription<? extends E> subscription = new DXFeedTimeSeriesSubscription<E>(eventTypes);
        this.attachSubscription(subscription);
        return subscription;
    }

    public abstract void attachSubscription(DXFeedSubscription<?> var1);

    public abstract void detachSubscription(DXFeedSubscription<?> var1);

    public abstract void detachSubscriptionAndClear(DXFeedSubscription<?> var1);

    public abstract <E extends LastingEvent<?>> E getLastEvent(E var1);

    public <E extends LastingEvent<?>> Collection<E> getLastEvents(Collection<E> events) {
        events.forEach(this::getLastEvent);
        return events;
    }

    public abstract <E extends LastingEvent<?>> Promise<E> getLastEventPromise(Class<E> var1, Object var2);

    public abstract <E extends LastingEvent<?>> E getLastEventIfSubscribed(Class<E> var1, Object var2);

    public abstract <E extends LastingEvent<?>> List<Promise<E>> getLastEventsPromises(Class<E> var1, Collection<?> var2);

    public abstract <E extends IndexedEvent<?>> Promise<List<E>> getIndexedEventsPromise(Class<E> var1, Object var2, IndexedEventSource var3);

    public abstract <E extends IndexedEvent<?>> List<E> getIndexedEventsIfSubscribed(Class<E> var1, Object var2, IndexedEventSource var3);

    public abstract <E extends TimeSeriesEvent<?>> Promise<List<E>> getTimeSeriesPromise(Class<E> var1, Object var2, long var3, long var5);

    public abstract <E extends TimeSeriesEvent<?>> List<E> getTimeSeriesIfSubscribed(Class<E> var1, Object var2, long var3, long var5);

    protected static <E> void processEvents(DXFeedSubscription<E> subscription, List<E> events) {
        subscription.processEvents(events);
    }
}

