/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.api;

import com.devexperts.services.Service;
import com.devexperts.services.Services;
import com.dxfeed.api.DXFeed;
import com.dxfeed.api.DXPublisher;
import com.dxfeed.event.EventType;
import java.beans.PropertyChangeListener;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;

public abstract class DXEndpoint
implements AutoCloseable {
    public static final String NAME_PROPERTY = "name";
    public static final String DXFEED_PROPERTIES_PROPERTY = "dxfeed.properties";
    public static final String DXFEED_ADDRESS_PROPERTY = "dxfeed.address";
    public static final String DXFEED_USER_PROPERTY = "dxfeed.user";
    public static final String DXFEED_PASSWORD_PROPERTY = "dxfeed.password";
    public static final String DXFEED_THREAD_POOL_SIZE_PROPERTY = "dxfeed.threadPoolSize";
    public static final String DXFEED_AGGREGATION_PERIOD_PROPERTY = "dxfeed.aggregationPeriod";
    public static final String DXFEED_WILDCARD_ENABLE_PROPERTY = "dxfeed.wildcard.enable";
    public static final String DXPUBLISHER_PROPERTIES_PROPERTY = "dxpublisher.properties";
    public static final String DXPUBLISHER_ADDRESS_PROPERTY = "dxpublisher.address";
    public static final String DXPUBLISHER_THREAD_POOL_SIZE_PROPERTY = "dxpublisher.threadPoolSize";
    public static final String DXENDPOINT_EVENT_TIME_PROPERTY = "dxendpoint.eventTime";
    public static final String DXENDPOINT_STORE_EVERYTHING_PROPERTY = "dxendpoint.storeEverything";
    public static final String DXSCHEME_NANO_TIME_PROPERTY = "dxscheme.nanoTime";
    public static final String DXSCHEME_ENABLED_PROPERTY_PREFIX = "dxscheme.enabled.";
    private static final EnumMap<Role, DXEndpoint> INSTANCES = new EnumMap(Role.class);

    protected DXEndpoint() {
    }

    public static DXEndpoint getInstance() {
        return DXEndpoint.getInstance(Role.FEED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DXEndpoint getInstance(Role role) {
        EnumMap<Role, DXEndpoint> enumMap = INSTANCES;
        synchronized (enumMap) {
            DXEndpoint instance = INSTANCES.get((Object)role);
            if (instance == null) {
                instance = DXEndpoint.newBuilder().withRole(role).build();
                INSTANCES.put(role, instance);
            }
            return instance;
        }
    }

    public static Builder newBuilder() {
        Builder builder = Services.createService(Builder.class, null, null);
        if (builder == null) {
            throw new IllegalStateException("There is no " + Builder.class + " implementation service in class path");
        }
        return builder;
    }

    public static DXEndpoint create() {
        return DXEndpoint.newBuilder().build();
    }

    public static DXEndpoint create(Role role) {
        return DXEndpoint.newBuilder().withRole(role).build();
    }

    public abstract Role getRole();

    public abstract State getState();

    public abstract void addStateChangeListener(PropertyChangeListener var1);

    public abstract void removeStateChangeListener(PropertyChangeListener var1);

    public abstract DXEndpoint executor(Executor var1);

    public abstract DXEndpoint user(String var1);

    public abstract DXEndpoint password(String var1);

    public abstract DXEndpoint connect(String var1);

    public abstract void reconnect();

    public abstract void disconnect();

    public abstract void disconnectAndClear();

    @Override
    public abstract void close();

    public abstract void awaitNotConnected() throws InterruptedException;

    public abstract void awaitProcessed() throws InterruptedException;

    public abstract void closeAndAwaitTermination() throws InterruptedException;

    public abstract Set<Class<? extends EventType<?>>> getEventTypes();

    public abstract DXFeed getFeed();

    public abstract DXPublisher getPublisher();

    @Service
    public static abstract class Builder {
        protected Role role = Role.FEED;

        protected Builder() {
        }

        public final Builder withName(String name) {
            return this.withProperty(DXEndpoint.NAME_PROPERTY, name);
        }

        public Builder withRole(Role role) {
            if (role == null) {
                throw new NullPointerException();
            }
            this.role = role;
            return this;
        }

        public abstract Builder withProperty(String var1, String var2);

        public Builder withProperties(Properties props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String key = (String)entry.getKey();
                this.withProperty(key, (String)entry.getValue());
            }
            return this;
        }

        public abstract boolean supportsProperty(String var1);

        public abstract DXEndpoint build();
    }

    public static enum State {
        NOT_CONNECTED,
        CONNECTING,
        CONNECTED,
        CLOSED;

    }

    public static enum Role {
        FEED,
        ON_DEMAND_FEED,
        STREAM_FEED,
        PUBLISHER,
        STREAM_PUBLISHER,
        LOCAL_HUB;

    }
}

