/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.Decimal;
import com.ib.controller.Formats;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Bar {
    private static final ThreadLocal<SimpleDateFormat> FORMAT_CACHE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd HH:mm:ss"));
    private final long m_time;
    private final String m_timeStr;
    private final double m_high;
    private final double m_low;
    private final double m_open;
    private final double m_close;
    private final Decimal m_wap;
    private final Decimal m_volume;
    private final int m_count;

    public long time() {
        return this.m_time;
    }

    public String timeStr() {
        return this.m_timeStr;
    }

    public double high() {
        return this.m_high;
    }

    public double low() {
        return this.m_low;
    }

    public double open() {
        return this.m_open;
    }

    public double close() {
        return this.m_close;
    }

    public Decimal wap() {
        return this.m_wap;
    }

    public Decimal volume() {
        return this.m_volume;
    }

    public int count() {
        return this.m_count;
    }

    public Bar(long l, double d, double d2, double d3, double d4, Decimal decimal, Decimal decimal2, int n) {
        this.m_time = l;
        this.m_timeStr = null;
        this.m_high = d;
        this.m_low = d2;
        this.m_open = d3;
        this.m_close = d4;
        this.m_wap = decimal;
        this.m_volume = decimal2;
        this.m_count = n;
    }

    public Bar(String string, double d, double d2, double d3, double d4, Decimal decimal, Decimal decimal2, int n) {
        this.m_time = Long.MAX_VALUE;
        this.m_timeStr = string;
        this.m_high = d;
        this.m_low = d2;
        this.m_open = d3;
        this.m_close = d4;
        this.m_wap = decimal;
        this.m_volume = decimal2;
        this.m_count = n;
    }

    public String formattedTime() {
        return Formats.fmtDate(this.m_time * 1000L);
    }

    public static String format(long l) {
        return FORMAT_CACHE.get().format(new Date(l));
    }

    public String toString() {
        return String.format("%s %s %s %s %s", this.m_timeStr != null ? this.m_timeStr : this.formattedTime(), this.m_open, this.m_high, this.m_low, this.m_close);
    }
}

