/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDescription;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.DepthMktDataDescription;
import com.ib.client.EClientErrors;
import com.ib.client.EJavaSignal;
import com.ib.client.EReader;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.ExecutionFilter;
import com.ib.client.FamilyCode;
import com.ib.client.HistogramEntry;
import com.ib.client.HistoricalSession;
import com.ib.client.HistoricalTick;
import com.ib.client.HistoricalTickBidAsk;
import com.ib.client.HistoricalTickLast;
import com.ib.client.NewsProvider;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.OrderStatus;
import com.ib.client.PriceIncrement;
import com.ib.client.ScannerSubscription;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.TickAttrib;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;
import com.ib.client.TickType;
import com.ib.client.Types;
import com.ib.client.WshEventData;
import com.ib.controller.AccountSummaryTag;
import com.ib.controller.AdvisorUtil;
import com.ib.controller.Alias;
import com.ib.controller.ApiConnection;
import com.ib.controller.Bar;
import com.ib.controller.ConcurrentHashSet;
import com.ib.controller.Group;
import com.ib.controller.MarketValueTag;
import com.ib.controller.Position;
import com.ib.controller.Profile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ApiController
implements EWrapper {
    private ApiConnection m_client;
    private final ApiConnection.ILogger m_outLogger;
    private final ApiConnection.ILogger m_inLogger;
    private int m_reqId;
    private int m_orderId;
    private final IConnectionHandler m_connectionHandler;
    private ITradeReportHandler m_tradeReportHandler;
    private ICompletedOrdersHandler m_completedOrdersHandler;
    private IAdvisorHandler m_advisorHandler;
    private IScannerHandler m_scannerHandler;
    private ITimeHandler m_timeHandler;
    private IBulletinHandler m_bulletinHandler;
    private IUserInfoHandler m_userInfoHandler;
    private final Map<Integer, IInternalHandler> m_contractDetailsMap = new HashMap<Integer, IInternalHandler>();
    private final Map<Integer, IOptHandler> m_optionCompMap = new HashMap<Integer, IOptHandler>();
    private final Map<Integer, IEfpHandler> m_efpMap = new HashMap<Integer, IEfpHandler>();
    private final Map<Integer, ITopMktDataHandler> m_topMktDataMap = new HashMap<Integer, ITopMktDataHandler>();
    private final Map<Integer, IDeepMktDataHandler> m_deepMktDataMap = new HashMap<Integer, IDeepMktDataHandler>();
    private final Map<Integer, IScannerHandler> m_scannerMap = new HashMap<Integer, IScannerHandler>();
    private final Map<Integer, IRealTimeBarHandler> m_realTimeBarMap = new HashMap<Integer, IRealTimeBarHandler>();
    private final Map<Integer, IHistoricalDataHandler> m_historicalDataMap = new HashMap<Integer, IHistoricalDataHandler>();
    private final Map<Integer, IHeadTimestampHandler> m_headTimestampMap = new HashMap<Integer, IHeadTimestampHandler>();
    private final Map<Integer, IHistogramDataHandler> m_histogramDataMap = new HashMap<Integer, IHistogramDataHandler>();
    private final Map<Integer, IFundamentalsHandler> m_fundMap = new HashMap<Integer, IFundamentalsHandler>();
    private final Map<Integer, IOrderHandler> m_orderHandlers = new HashMap<Integer, IOrderHandler>();
    private final Map<Integer, IOrderCancelHandler> m_orderCancelHandlers = new HashMap<Integer, IOrderCancelHandler>();
    private final Map<Integer, IAccountSummaryHandler> m_acctSummaryHandlers = new HashMap<Integer, IAccountSummaryHandler>();
    private final Map<Integer, IMarketValueSummaryHandler> m_mktValSummaryHandlers = new HashMap<Integer, IMarketValueSummaryHandler>();
    private final Set<IPositionHandler> m_positionHandlers = new ConcurrentHashSet<IPositionHandler>();
    private final Set<IAccountHandler> m_accountHandlers = new ConcurrentHashSet<IAccountHandler>();
    private final Set<ILiveOrderHandler> m_liveOrderHandlers = new ConcurrentHashSet<ILiveOrderHandler>();
    private final Map<Integer, IPositionMultiHandler> m_positionMultiMap = new HashMap<Integer, IPositionMultiHandler>();
    private final Map<Integer, IAccountUpdateMultiHandler> m_accountUpdateMultiMap = new HashMap<Integer, IAccountUpdateMultiHandler>();
    private final Map<Integer, ISecDefOptParamsReqHandler> m_secDefOptParamsReqMap = new HashMap<Integer, ISecDefOptParamsReqHandler>();
    private final Map<Integer, ISoftDollarTiersReqHandler> m_softDollarTiersReqMap = new HashMap<Integer, ISoftDollarTiersReqHandler>();
    private final Set<IFamilyCodesHandler> m_familyCodesHandlers = new ConcurrentHashSet<IFamilyCodesHandler>();
    private final Map<Integer, ISymbolSamplesHandler> m_symbolSamplesHandlerMap = new HashMap<Integer, ISymbolSamplesHandler>();
    private final Set<IMktDepthExchangesHandler> m_mktDepthExchangesHandlers = new ConcurrentHashSet<IMktDepthExchangesHandler>();
    private final Map<Integer, ITickNewsHandler> m_tickNewsHandlerMap = new HashMap<Integer, ITickNewsHandler>();
    private final Map<Integer, ISmartComponentsHandler> m_smartComponentsHandler = new HashMap<Integer, ISmartComponentsHandler>();
    private final Set<INewsProvidersHandler> m_newsProvidersHandlers = new ConcurrentHashSet<INewsProvidersHandler>();
    private final Map<Integer, INewsArticleHandler> m_newsArticleHandlerMap = new HashMap<Integer, INewsArticleHandler>();
    private final Map<Integer, IHistoricalNewsHandler> m_historicalNewsHandlerMap = new HashMap<Integer, IHistoricalNewsHandler>();
    private final Set<IMarketRuleHandler> m_marketRuleHandlers = new ConcurrentHashSet<IMarketRuleHandler>();
    private final Map<Integer, IPnLHandler> m_pnlMap = new HashMap<Integer, IPnLHandler>();
    private final Map<Integer, IPnLSingleHandler> m_pnlSingleMap = new HashMap<Integer, IPnLSingleHandler>();
    private final Map<Integer, IHistoricalTickHandler> m_historicalTicksMap = new HashMap<Integer, IHistoricalTickHandler>();
    private final Map<Integer, ITickByTickDataHandler> m_tickByTickDataMap = new HashMap<Integer, ITickByTickDataHandler>();
    private final Map<Integer, IWshMetaDataHandler> m_wshMetaDataMap = new HashMap<Integer, IWshMetaDataHandler>();
    private final Map<Integer, IWshEventDataHandler> m_wshEventDataMap = new HashMap<Integer, IWshEventDataHandler>();
    private final Map<Integer, IHistoricalScheduleHandler> m_historicalScheduleMap = new HashMap<Integer, IHistoricalScheduleHandler>();
    private boolean m_connected = false;
    private static final int REPLACE_FA_GROUPS_REQ_ID = 0;
    private static final int REPLACE_FA_PROFILES_REQ_ID = 1;

    public ApiConnection client() {
        return this.m_client;
    }

    public ApiController(IConnectionHandler iConnectionHandler) {
        this(iConnectionHandler, null, null);
    }

    public ApiController(IConnectionHandler iConnectionHandler, ApiConnection.ILogger iLogger, ApiConnection.ILogger iLogger2) {
        this.m_connectionHandler = iConnectionHandler;
        this.m_client = new ApiConnection(this, iLogger, iLogger2);
        this.m_inLogger = iLogger;
        this.m_outLogger = iLogger2;
    }

    private void startMsgProcessingThread() {
        EJavaSignal eJavaSignal = new EJavaSignal();
        EReader eReader = new EReader(this.client(), eJavaSignal);
        eReader.start();
        new Thread(() -> {
            while (this.client().isConnected()) {
                eJavaSignal.waitForSignal();
                try {
                    eReader.processMsgs();
                }
                catch (IOException iOException) {
                    this.error(iOException);
                }
            }
        }).start();
    }

    public void connect(String string, int n, int n2, String string2) {
        if (!this.m_client.isConnected()) {
            this.m_client.eConnect(string, n, n2);
            this.startMsgProcessingThread();
            this.sendEOM();
        }
    }

    public void disconnect() {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.eDisconnect();
        this.m_connectionHandler.disconnected();
        this.m_connected = false;
        this.sendEOM();
    }

    @Override
    public void managedAccounts(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        this.m_connectionHandler.accountList(arrayList);
        this.recEOM();
    }

    @Override
    public void nextValidId(int n) {
        this.m_orderId = n;
        this.m_reqId = this.m_orderId + 10000000;
        this.m_connected = true;
        if (this.m_connectionHandler != null) {
            this.m_connectionHandler.connected();
        }
        this.recEOM();
    }

    @Override
    public void error(Exception exception) {
        this.m_connectionHandler.error(exception);
    }

    @Override
    public void error(int n, int n2, String string, String string2) {
        IOrderCancelHandler iOrderCancelHandler;
        IOrderHandler iOrderHandler = this.m_orderHandlers.get(n);
        if (iOrderHandler != null) {
            iOrderHandler.handle(n2, string);
        }
        if ((iOrderCancelHandler = this.m_orderCancelHandlers.get(n)) != null) {
            iOrderCancelHandler.handle(n2, string);
        }
        Object object = this.m_liveOrderHandlers.iterator();
        while (object.hasNext()) {
            ILiveOrderHandler iLiveOrderHandler = object.next();
            iLiveOrderHandler.handle(n, n2, string);
        }
        if (n2 == 200 && (object = this.m_contractDetailsMap.remove(n)) != null) {
            object.contractDetailsEnd();
        }
        this.m_connectionHandler.message(n, n2, string, string2);
        this.recEOM();
    }

    @Override
    public void connectionClosed() {
        this.m_connectionHandler.disconnected();
        this.m_connected = false;
    }

    public void reqAccountUpdates(boolean bl, String string, IAccountHandler iAccountHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_accountHandlers.add(iAccountHandler);
        this.m_client.reqAccountUpdates(bl, string);
        this.sendEOM();
    }

    @Override
    public void updateAccountValue(String string, String string2, String string3, String string4) {
        if ("Currency".equals(string)) {
            return;
        }
        for (IAccountHandler iAccountHandler : this.m_accountHandlers) {
            iAccountHandler.accountValue(string4, string, string2, string3);
        }
        this.recEOM();
    }

    @Override
    public void updateAccountTime(String string) {
        for (IAccountHandler iAccountHandler : this.m_accountHandlers) {
            iAccountHandler.accountTime(string);
        }
        this.recEOM();
    }

    @Override
    public void accountDownloadEnd(String string) {
        for (IAccountHandler iAccountHandler : this.m_accountHandlers) {
            iAccountHandler.accountDownloadEnd(string);
        }
        this.recEOM();
    }

    @Override
    public void updatePortfolio(Contract contract, Decimal decimal, double d, double d2, double d3, double d4, double d5, String string) {
        contract.exchange(contract.primaryExch());
        Position position = new Position(contract, string, decimal, d, d2, d3, d4, d5);
        for (IAccountHandler iAccountHandler : this.m_accountHandlers) {
            iAccountHandler.updatePortfolio(position);
        }
        this.recEOM();
    }

    public void reqAccountSummary(String string, AccountSummaryTag[] accountSummaryTagArray, IAccountSummaryHandler iAccountSummaryHandler) {
        if (!this.checkConnection()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (AccountSummaryTag accountSummaryTag : accountSummaryTagArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append((Object)accountSummaryTag);
        }
        int n = this.m_reqId++;
        this.m_acctSummaryHandlers.put(n, iAccountSummaryHandler);
        this.m_client.reqAccountSummary(n, string, stringBuilder.toString());
        this.sendEOM();
    }

    private boolean isConnected() {
        return this.m_connected;
    }

    public void cancelAccountSummary(IAccountSummaryHandler iAccountSummaryHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_acctSummaryHandlers, iAccountSummaryHandler);
        if (n != null) {
            this.m_client.cancelAccountSummary(n);
            this.sendEOM();
        }
    }

    public void reqMarketValueSummary(String string, IMarketValueSummaryHandler iMarketValueSummaryHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_mktValSummaryHandlers.put(n, iMarketValueSummaryHandler);
        this.m_client.reqAccountSummary(n, string, "$LEDGER");
        this.sendEOM();
    }

    public void cancelMarketValueSummary(IMarketValueSummaryHandler iMarketValueSummaryHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_mktValSummaryHandlers, iMarketValueSummaryHandler);
        if (n != null) {
            this.m_client.cancelAccountSummary(n);
            this.sendEOM();
        }
    }

    @Override
    public void accountSummary(int n, String string, String string2, String string3, String string4) {
        IMarketValueSummaryHandler iMarketValueSummaryHandler;
        if ("Currency".equals(string2)) {
            return;
        }
        IAccountSummaryHandler iAccountSummaryHandler = this.m_acctSummaryHandlers.get(n);
        if (iAccountSummaryHandler != null) {
            iAccountSummaryHandler.accountSummary(string, AccountSummaryTag.valueOf(string2), string3, string4);
        }
        if ((iMarketValueSummaryHandler = this.m_mktValSummaryHandlers.get(n)) != null) {
            iMarketValueSummaryHandler.marketValueSummary(string, MarketValueTag.valueOf(string2), string3, string4);
        }
        this.recEOM();
    }

    @Override
    public void accountSummaryEnd(int n) {
        IMarketValueSummaryHandler iMarketValueSummaryHandler;
        IAccountSummaryHandler iAccountSummaryHandler = this.m_acctSummaryHandlers.get(n);
        if (iAccountSummaryHandler != null) {
            iAccountSummaryHandler.accountSummaryEnd();
        }
        if ((iMarketValueSummaryHandler = this.m_mktValSummaryHandlers.get(n)) != null) {
            iMarketValueSummaryHandler.marketValueSummaryEnd();
        }
        this.recEOM();
    }

    public void reqPositions(IPositionHandler iPositionHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_positionHandlers.add(iPositionHandler);
        this.m_client.reqPositions();
        this.sendEOM();
    }

    public void cancelPositions(IPositionHandler iPositionHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_positionHandlers.remove(iPositionHandler);
        this.m_client.cancelPositions();
        this.sendEOM();
    }

    @Override
    public void position(String string, Contract contract, Decimal decimal, double d) {
        for (IPositionHandler iPositionHandler : this.m_positionHandlers) {
            iPositionHandler.position(string, contract, decimal, d);
        }
        this.recEOM();
    }

    @Override
    public void positionEnd() {
        for (IPositionHandler iPositionHandler : this.m_positionHandlers) {
            iPositionHandler.positionEnd();
        }
        this.recEOM();
    }

    public void reqContractDetails(Contract contract, final IContractDetailsHandler iContractDetailsHandler) {
        if (!this.checkConnection()) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        this.internalReqContractDetails(contract, new IInternalHandler(){

            @Override
            public void contractDetails(ContractDetails contractDetails) {
                arrayList.add(contractDetails);
            }

            @Override
            public void contractDetailsEnd() {
                iContractDetailsHandler.contractDetails(arrayList);
            }
        });
        this.sendEOM();
    }

    private void internalReqContractDetails(Contract contract, final IInternalHandler iInternalHandler) {
        int n = this.m_reqId++;
        this.m_contractDetailsMap.put(n, iInternalHandler);
        this.m_orderHandlers.put(n, new IOrderHandler(){

            @Override
            public void handle(int n, String string) {
                iInternalHandler.contractDetailsEnd();
            }

            @Override
            public void orderState(OrderState orderState) {
            }

            @Override
            public void orderStatus(OrderStatus orderStatus, Decimal decimal, Decimal decimal2, double d, int n, int n2, double d2, int n3, String string, double d3) {
            }
        });
        this.m_client.reqContractDetails(n, contract);
        this.sendEOM();
    }

    @Override
    public void contractDetails(int n, ContractDetails contractDetails) {
        IInternalHandler iInternalHandler = this.m_contractDetailsMap.get(n);
        if (iInternalHandler != null) {
            iInternalHandler.contractDetails(contractDetails);
        } else {
            this.show("Error: no contract details handler for reqId " + n);
        }
        this.recEOM();
    }

    @Override
    public void bondContractDetails(int n, ContractDetails contractDetails) {
        IInternalHandler iInternalHandler = this.m_contractDetailsMap.get(n);
        if (iInternalHandler != null) {
            iInternalHandler.contractDetails(contractDetails);
        } else {
            this.show("Error: no bond contract details handler for reqId " + n);
        }
        this.recEOM();
    }

    @Override
    public void contractDetailsEnd(int n) {
        IInternalHandler iInternalHandler = this.m_contractDetailsMap.remove(n);
        if (iInternalHandler != null) {
            iInternalHandler.contractDetailsEnd();
        } else {
            this.show("Error: no contract details handler for reqId " + n);
        }
        this.recEOM();
    }

    public void reqTopMktData(Contract contract, String string, boolean bl, boolean bl2, ITopMktDataHandler iTopMktDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_topMktDataMap.put(n, iTopMktDataHandler);
        this.m_client.reqMktData(n, contract, string, bl, bl2, Collections.emptyList());
        this.sendEOM();
    }

    public void reqOptionMktData(Contract contract, String string, boolean bl, boolean bl2, IOptHandler iOptHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_topMktDataMap.put(n, iOptHandler);
        this.m_optionCompMap.put(n, iOptHandler);
        this.m_client.reqMktData(n, contract, string, bl, bl2, Collections.emptyList());
        this.sendEOM();
    }

    public void reqEfpMktData(Contract contract, String string, boolean bl, boolean bl2, IEfpHandler iEfpHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_topMktDataMap.put(n, iEfpHandler);
        this.m_efpMap.put(n, iEfpHandler);
        this.m_client.reqMktData(n, contract, string, bl, bl2, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelTopMktData(ITopMktDataHandler iTopMktDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_topMktDataMap, iTopMktDataHandler);
        if (n != null) {
            this.m_client.cancelMktData(n);
        } else {
            this.show("Error: could not cancel top market data");
        }
        this.sendEOM();
    }

    public void cancelOptionMktData(IOptHandler iOptHandler) {
        this.cancelTopMktData(iOptHandler);
        ApiController.getAndRemoveKey(this.m_optionCompMap, iOptHandler);
    }

    public void cancelEfpMktData(IEfpHandler iEfpHandler) {
        this.cancelTopMktData(iEfpHandler);
        ApiController.getAndRemoveKey(this.m_efpMap, iEfpHandler);
    }

    public void reqMktDataType(int n) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.reqMarketDataType(n);
        this.sendEOM();
        switch (n) {
            case 1: {
                this.show("Frozen, Delayed and Delayed-Frozen market data types are disabled");
                break;
            }
            case 2: {
                this.show("Frozen market data type is enabled");
                break;
            }
            case 3: {
                this.show("Delayed market data type is enabled, Delayed-Frozen market data type is disabled");
                break;
            }
            case 4: {
                this.show("Delayed and Delayed-Frozen market data types are enabled");
                break;
            }
            default: {
                this.show("Unknown market data type");
            }
        }
    }

    @Override
    public void tickPrice(int n, int n2, double d, TickAttrib tickAttrib) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.tickPrice(TickType.get(n2), d, tickAttrib);
        }
        this.recEOM();
    }

    @Override
    public void tickGeneric(int n, int n2, double d) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.tickPrice(TickType.get(n2), d, new TickAttrib());
        }
        this.recEOM();
    }

    @Override
    public void tickSize(int n, int n2, Decimal decimal) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.tickSize(TickType.get(n2), decimal);
        }
        this.recEOM();
    }

    @Override
    public void tickString(int n, int n2, String string) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.tickString(TickType.get(n2), string);
        }
        this.recEOM();
    }

    @Override
    public void tickEFP(int n, int n2, double d, String string, double d2, int n3, String string2, double d3, double d4) {
        IEfpHandler iEfpHandler = this.m_efpMap.get(n);
        if (iEfpHandler != null) {
            iEfpHandler.tickEFP(n2, d, string, d2, n3, string2, d3, d4);
        }
        this.recEOM();
    }

    @Override
    public void tickSnapshotEnd(int n) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.tickSnapshotEnd();
        }
        this.recEOM();
    }

    @Override
    public void marketDataType(int n, int n2) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.marketDataType(n2);
        }
        this.recEOM();
    }

    public void reqDeepMktData(Contract contract, int n, boolean bl, IDeepMktDataHandler iDeepMktDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        this.m_deepMktDataMap.put(n2, iDeepMktDataHandler);
        ArrayList<TagValue> arrayList = new ArrayList<TagValue>();
        this.m_client.reqMktDepth(n2, contract, n, bl, arrayList);
        this.sendEOM();
    }

    public void cancelDeepMktData(boolean bl, IDeepMktDataHandler iDeepMktDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_deepMktDataMap, iDeepMktDataHandler);
        if (n != null) {
            this.m_client.cancelMktDepth(n, bl);
            this.sendEOM();
        }
    }

    @Override
    public void updateMktDepth(int n, int n2, int n3, int n4, double d, Decimal decimal) {
        IDeepMktDataHandler iDeepMktDataHandler = this.m_deepMktDataMap.get(n);
        if (iDeepMktDataHandler != null) {
            iDeepMktDataHandler.updateMktDepth(n2, null, Types.DeepType.get(n3), Types.DeepSide.get(n4), d, decimal);
        }
        this.recEOM();
    }

    @Override
    public void updateMktDepthL2(int n, int n2, String string, int n3, int n4, double d, Decimal decimal, boolean bl) {
        IDeepMktDataHandler iDeepMktDataHandler = this.m_deepMktDataMap.get(n);
        if (iDeepMktDataHandler != null) {
            iDeepMktDataHandler.updateMktDepth(n2, string, Types.DeepType.get(n3), Types.DeepSide.get(n4), d, decimal);
        }
        this.recEOM();
    }

    public void reqOptionVolatility(Contract contract, double d, double d2, IOptHandler iOptHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_optionCompMap.put(n, iOptHandler);
        this.m_client.calculateImpliedVolatility(n, contract, d, d2, null);
        this.sendEOM();
    }

    public void reqOptionComputation(Contract contract, double d, double d2, IOptHandler iOptHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_optionCompMap.put(n, iOptHandler);
        this.m_client.calculateOptionPrice(n, contract, d, d2, null);
        this.sendEOM();
    }

    void cancelOptionComp(IOptHandler iOptHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_optionCompMap, iOptHandler);
        if (n != null) {
            this.m_client.cancelCalculateOptionPrice(n);
            this.sendEOM();
        }
    }

    @Override
    public void tickOptionComputation(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        IOptHandler iOptHandler = this.m_optionCompMap.get(n);
        if (iOptHandler != null) {
            iOptHandler.tickOptionComputation(TickType.get(n2), n3, d, d2, d3, d4, d5, d6, d7, d8);
        } else {
            System.out.println(String.format("not handled %s %s %s %s %s %s %s %s %s %s", n2, n3, d, d2, d3, d4, d5, d6, d7, d8));
        }
        this.recEOM();
    }

    public void reqExecutions(ExecutionFilter executionFilter, ITradeReportHandler iTradeReportHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_tradeReportHandler = iTradeReportHandler;
        this.m_client.reqExecutions(this.m_reqId++, executionFilter);
        this.sendEOM();
    }

    @Override
    public void execDetails(int n, Contract contract, Execution execution) {
        if (this.m_tradeReportHandler != null) {
            int n2 = execution.execId().lastIndexOf(46);
            String string = execution.execId().substring(0, n2);
            this.m_tradeReportHandler.tradeReport(string, contract, execution);
        }
        this.recEOM();
    }

    @Override
    public void execDetailsEnd(int n) {
        if (this.m_tradeReportHandler != null) {
            this.m_tradeReportHandler.tradeReportEnd();
        }
        this.recEOM();
    }

    @Override
    public void commissionReport(CommissionReport commissionReport) {
        if (this.m_tradeReportHandler != null) {
            int n = commissionReport.execId().lastIndexOf(46);
            String string = commissionReport.execId().substring(0, n);
            this.m_tradeReportHandler.commissionReport(string, commissionReport);
        }
        this.recEOM();
    }

    public void reqAdvisorData(Types.FADataType fADataType, IAdvisorHandler iAdvisorHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_advisorHandler = iAdvisorHandler;
        this.m_client.requestFA(fADataType.ordinal());
        this.sendEOM();
    }

    public void updateGroups(List<Group> list) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.replaceFA(0, Types.FADataType.GROUPS.ordinal(), AdvisorUtil.getGroupsXml(list));
        this.sendEOM();
    }

    public void updateProfiles(List<Profile> list) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.replaceFA(1, Types.FADataType.PROFILES.ordinal(), AdvisorUtil.getProfilesXml(list));
        this.sendEOM();
    }

    @Override
    public final void receiveFA(int n, String string) {
        if (this.m_advisorHandler == null) {
            return;
        }
        Types.FADataType fADataType = Types.FADataType.get(n);
        switch (fADataType) {
            case GROUPS: {
                List<Group> list = AdvisorUtil.getGroups(string);
                this.m_advisorHandler.groups(list);
                break;
            }
            case PROFILES: {
                List<Profile> list = AdvisorUtil.getProfiles(string);
                this.m_advisorHandler.profiles(list);
                break;
            }
            case ALIASES: {
                List<Alias> list = AdvisorUtil.getAliases(string);
                this.m_advisorHandler.aliases(list);
                break;
            }
        }
        this.recEOM();
    }

    @Override
    public final void replaceFAEnd(int n, String string) {
        switch (n) {
            case 0: {
                this.m_advisorHandler.updateGroupsEnd(string);
                break;
            }
            case 1: {
                this.m_advisorHandler.updateProfilesEnd(string);
                break;
            }
        }
        this.recEOM();
    }

    public void placeOrModifyOrder(Contract contract, Order order, IOrderHandler iOrderHandler) {
        if (!this.checkConnection()) {
            return;
        }
        if (order.orderId() == 0) {
            order.orderId(this.m_orderId++);
            if (iOrderHandler != null) {
                this.m_orderHandlers.put(order.orderId(), iOrderHandler);
            }
        }
        this.m_client.placeOrder(contract, order);
        this.sendEOM();
    }

    public void cancelOrder(int n, String string, IOrderCancelHandler iOrderCancelHandler) {
        if (!this.checkConnection()) {
            return;
        }
        if (iOrderCancelHandler != null) {
            this.m_orderCancelHandlers.put(n, iOrderCancelHandler);
        }
        this.m_client.cancelOrder(n, string);
        this.sendEOM();
    }

    public void cancelAllOrders() {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.reqGlobalCancel();
        this.sendEOM();
    }

    public void exerciseOption(String string, Contract contract, Types.ExerciseType exerciseType, int n, boolean bl) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.exerciseOptions(this.m_reqId++, contract, exerciseType.ordinal(), n, string, bl ? 1 : 0);
        this.sendEOM();
    }

    public void removeOrderHandler(IOrderHandler iOrderHandler) {
        ApiController.getAndRemoveKey(this.m_orderHandlers, iOrderHandler);
    }

    public void removeOrderCancelHandler(IOrderCancelHandler iOrderCancelHandler) {
        ApiController.getAndRemoveKey(this.m_orderCancelHandlers, iOrderCancelHandler);
    }

    public void reqLiveOrders(ILiveOrderHandler iLiveOrderHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_liveOrderHandlers.add(iLiveOrderHandler);
        this.m_client.reqAllOpenOrders();
        this.sendEOM();
    }

    public void takeTwsOrders(ILiveOrderHandler iLiveOrderHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_liveOrderHandlers.add(iLiveOrderHandler);
        this.m_client.reqOpenOrders();
        this.sendEOM();
    }

    public void takeFutureTwsOrders(ILiveOrderHandler iLiveOrderHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_liveOrderHandlers.add(iLiveOrderHandler);
        this.m_client.reqAutoOpenOrders(true);
        this.sendEOM();
    }

    public void removeLiveOrderHandler(ILiveOrderHandler iLiveOrderHandler) {
        this.m_liveOrderHandlers.remove(iLiveOrderHandler);
    }

    @Override
    public void openOrder(int n, Contract contract, Order order, OrderState orderState) {
        IOrderHandler iOrderHandler = this.m_orderHandlers.get(n);
        if (iOrderHandler != null) {
            iOrderHandler.orderState(orderState);
        }
        if (!order.whatIf()) {
            for (ILiveOrderHandler iLiveOrderHandler : this.m_liveOrderHandlers) {
                iLiveOrderHandler.openOrder(contract, order, orderState);
            }
        }
        this.recEOM();
    }

    @Override
    public void openOrderEnd() {
        for (ILiveOrderHandler iLiveOrderHandler : this.m_liveOrderHandlers) {
            iLiveOrderHandler.openOrderEnd();
        }
        this.recEOM();
    }

    @Override
    public void orderStatus(int n, String string, Decimal decimal, Decimal decimal2, double d, int n2, int n3, double d2, int n4, String string2, double d3) {
        IOrderCancelHandler iOrderCancelHandler;
        IOrderHandler iOrderHandler = this.m_orderHandlers.get(n);
        if (iOrderHandler != null) {
            iOrderHandler.orderStatus(OrderStatus.valueOf(string), decimal, decimal2, d, n2, n3, d2, n4, string2, d3);
        }
        if ((iOrderCancelHandler = this.m_orderCancelHandlers.get(n)) != null) {
            iOrderCancelHandler.orderStatus(string);
        }
        for (ILiveOrderHandler iLiveOrderHandler : this.m_liveOrderHandlers) {
            iLiveOrderHandler.orderStatus(n, OrderStatus.valueOf(string), decimal, decimal2, d, n2, n3, d2, n4, string2, d3);
        }
        this.recEOM();
    }

    public void reqScannerParameters(IScannerHandler iScannerHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_scannerHandler = iScannerHandler;
        this.m_client.reqScannerParameters();
        this.sendEOM();
    }

    public void reqScannerSubscription(ScannerSubscription scannerSubscription, List<TagValue> list, IScannerHandler iScannerHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_scannerMap.put(n, iScannerHandler);
        this.m_client.reqScannerSubscription(n, scannerSubscription, null, list);
        this.sendEOM();
    }

    public void cancelScannerSubscription(IScannerHandler iScannerHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_scannerMap, iScannerHandler);
        if (n != null) {
            this.m_client.cancelScannerSubscription(n);
            this.sendEOM();
        }
    }

    @Override
    public void scannerParameters(String string) {
        this.m_scannerHandler.scannerParameters(string);
        this.recEOM();
    }

    @Override
    public void scannerData(int n, int n2, ContractDetails contractDetails, String string, String string2, String string3, String string4) {
        IScannerHandler iScannerHandler = this.m_scannerMap.get(n);
        if (iScannerHandler != null) {
            iScannerHandler.scannerData(n2, contractDetails, string4);
        }
        this.recEOM();
    }

    @Override
    public void scannerDataEnd(int n) {
        IScannerHandler iScannerHandler = this.m_scannerMap.get(n);
        if (iScannerHandler != null) {
            iScannerHandler.scannerDataEnd();
        }
        this.recEOM();
    }

    public void reqHistoricalData(Contract contract, String string, int n, Types.DurationUnit durationUnit, Types.BarSize barSize, Types.WhatToShow whatToShow, boolean bl, boolean bl2, IHistoricalDataHandler iHistoricalDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        this.m_historicalDataMap.put(n2, iHistoricalDataHandler);
        String string2 = n + " " + durationUnit.toString().charAt(0);
        this.m_client.reqHistoricalData(n2, contract, string, string2, barSize.toString(), whatToShow.toString(), bl ? 1 : 0, 1, bl2, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelHistoricalData(IHistoricalDataHandler iHistoricalDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_historicalDataMap, iHistoricalDataHandler);
        if (n != null) {
            this.m_client.cancelHistoricalData(n);
            this.sendEOM();
        }
    }

    @Override
    public void historicalData(int n, com.ib.client.Bar bar) {
        IHistoricalDataHandler iHistoricalDataHandler = this.m_historicalDataMap.get(n);
        if (iHistoricalDataHandler != null) {
            if (bar.time().startsWith("finished")) {
                iHistoricalDataHandler.historicalDataEnd();
            } else {
                Bar bar2 = new Bar(bar.time(), bar.high(), bar.low(), bar.open(), bar.close(), bar.wap(), bar.volume(), bar.count());
                iHistoricalDataHandler.historicalData(bar2);
            }
        }
        this.recEOM();
    }

    public void reqRealTimeBars(Contract contract, Types.WhatToShow whatToShow, boolean bl, IRealTimeBarHandler iRealTimeBarHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_realTimeBarMap.put(n, iRealTimeBarHandler);
        ArrayList<TagValue> arrayList = new ArrayList<TagValue>();
        this.m_client.reqRealTimeBars(n, contract, 0, whatToShow.toString(), bl, arrayList);
        this.sendEOM();
    }

    public void cancelRealtimeBars(IRealTimeBarHandler iRealTimeBarHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_realTimeBarMap, iRealTimeBarHandler);
        if (n != null) {
            this.m_client.cancelRealTimeBars(n);
            this.sendEOM();
        }
    }

    @Override
    public void realtimeBar(int n, long l, double d, double d2, double d3, double d4, Decimal decimal, Decimal decimal2, int n2) {
        IRealTimeBarHandler iRealTimeBarHandler = this.m_realTimeBarMap.get(n);
        if (iRealTimeBarHandler != null) {
            Bar bar = new Bar(l, d2, d3, d, d4, decimal2, decimal, n2);
            iRealTimeBarHandler.realtimeBar(bar);
        }
        this.recEOM();
    }

    public void reqFundamentals(Contract contract, Types.FundamentalType fundamentalType, IFundamentalsHandler iFundamentalsHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_fundMap.put(n, iFundamentalsHandler);
        this.m_client.reqFundamentalData(n, contract, fundamentalType.getApiString(), null);
        this.sendEOM();
    }

    @Override
    public void fundamentalData(int n, String string) {
        IFundamentalsHandler iFundamentalsHandler = this.m_fundMap.get(n);
        if (iFundamentalsHandler != null) {
            iFundamentalsHandler.fundamentals(string);
        }
        this.recEOM();
    }

    public void reqCurrentTime(ITimeHandler iTimeHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_timeHandler = iTimeHandler;
        this.m_client.reqCurrentTime();
        this.sendEOM();
    }

    protected boolean checkConnection() {
        if (!this.isConnected()) {
            this.error(-1, EClientErrors.NOT_CONNECTED.code(), EClientErrors.NOT_CONNECTED.msg(), null);
            return false;
        }
        return true;
    }

    @Override
    public void currentTime(long l) {
        this.m_timeHandler.currentTime(l);
        this.recEOM();
    }

    public void reqBulletins(boolean bl, IBulletinHandler iBulletinHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_bulletinHandler = iBulletinHandler;
        this.m_client.reqNewsBulletins(bl);
        this.sendEOM();
    }

    public void cancelBulletins() {
        if (!this.checkConnection()) {
            return;
        }
        this.m_client.cancelNewsBulletins();
    }

    @Override
    public void updateNewsBulletin(int n, int n2, String string, String string2) {
        this.m_bulletinHandler.bulletin(n, Types.NewsType.get(n2), string, string2);
        this.recEOM();
    }

    public void reqPositionsMulti(String string, String string2, IPositionMultiHandler iPositionMultiHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_positionMultiMap.put(n, iPositionMultiHandler);
        this.m_client.reqPositionsMulti(n, string, string2);
        this.sendEOM();
    }

    public void cancelPositionsMulti(IPositionMultiHandler iPositionMultiHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_positionMultiMap, iPositionMultiHandler);
        if (n != null) {
            this.m_client.cancelPositionsMulti(n);
            this.sendEOM();
        }
    }

    @Override
    public void positionMulti(int n, String string, String string2, Contract contract, Decimal decimal, double d) {
        IPositionMultiHandler iPositionMultiHandler = this.m_positionMultiMap.get(n);
        if (iPositionMultiHandler != null) {
            iPositionMultiHandler.positionMulti(string, string2, contract, decimal, d);
        }
        this.recEOM();
    }

    @Override
    public void positionMultiEnd(int n) {
        IPositionMultiHandler iPositionMultiHandler = this.m_positionMultiMap.get(n);
        if (iPositionMultiHandler != null) {
            iPositionMultiHandler.positionMultiEnd();
        }
        this.recEOM();
    }

    public void reqAccountUpdatesMulti(String string, String string2, boolean bl, IAccountUpdateMultiHandler iAccountUpdateMultiHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_accountUpdateMultiMap.put(n, iAccountUpdateMultiHandler);
        this.m_client.reqAccountUpdatesMulti(n, string, string2, bl);
        this.sendEOM();
    }

    public void cancelAccountUpdatesMulti(IAccountUpdateMultiHandler iAccountUpdateMultiHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_accountUpdateMultiMap, iAccountUpdateMultiHandler);
        if (n != null) {
            this.m_client.cancelAccountUpdatesMulti(n);
            this.sendEOM();
        }
    }

    @Override
    public void accountUpdateMulti(int n, String string, String string2, String string3, String string4, String string5) {
        IAccountUpdateMultiHandler iAccountUpdateMultiHandler = this.m_accountUpdateMultiMap.get(n);
        if (iAccountUpdateMultiHandler != null) {
            iAccountUpdateMultiHandler.accountUpdateMulti(string, string2, string3, string4, string5);
        }
        this.recEOM();
    }

    @Override
    public void accountUpdateMultiEnd(int n) {
        IAccountUpdateMultiHandler iAccountUpdateMultiHandler = this.m_accountUpdateMultiMap.get(n);
        if (iAccountUpdateMultiHandler != null) {
            iAccountUpdateMultiHandler.accountUpdateMultiEnd();
        }
        this.recEOM();
    }

    @Override
    public void verifyMessageAPI(String string) {
    }

    @Override
    public void verifyCompleted(boolean bl, String string) {
    }

    @Override
    public void verifyAndAuthMessageAPI(String string, String string2) {
    }

    @Override
    public void verifyAndAuthCompleted(boolean bl, String string) {
    }

    @Override
    public void displayGroupList(int n, String string) {
    }

    @Override
    public void displayGroupUpdated(int n, String string) {
    }

    @Override
    public void deltaNeutralValidation(int n, DeltaNeutralContract deltaNeutralContract) {
        this.show("RECEIVED DN VALIDATION");
        this.recEOM();
    }

    protected void sendEOM() {
        if (this.m_outLogger != null) {
            this.m_outLogger.log("\n");
        }
    }

    private void recEOM() {
        if (this.m_inLogger != null) {
            this.m_inLogger.log("\n");
        }
    }

    public void show(String string) {
        this.m_connectionHandler.show(string);
    }

    private static <K, V> K getAndRemoveKey(Map<K, V> map, V v) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getValue() != v) continue;
            map.remove(entry.getKey());
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void error(String string) {
        throw new RuntimeException();
    }

    @Override
    public void connectAck() {
        if (this.m_client.isAsyncEConnect()) {
            this.m_client.startAPI();
        }
    }

    public void reqSecDefOptParams(String string, String string2, String string3, int n, ISecDefOptParamsReqHandler iSecDefOptParamsReqHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        this.m_secDefOptParamsReqMap.put(n2, iSecDefOptParamsReqHandler);
        this.m_client.reqSecDefOptParams(n2, string, string2, string3, n);
        this.sendEOM();
    }

    @Override
    public void securityDefinitionOptionalParameter(int n, String string, int n2, String string2, String string3, Set<String> set, Set<Double> set2) {
        ISecDefOptParamsReqHandler iSecDefOptParamsReqHandler = this.m_secDefOptParamsReqMap.get(n);
        if (iSecDefOptParamsReqHandler != null) {
            iSecDefOptParamsReqHandler.securityDefinitionOptionalParameter(string, n2, string2, string3, set, set2);
        }
    }

    @Override
    public void securityDefinitionOptionalParameterEnd(int n) {
        ISecDefOptParamsReqHandler iSecDefOptParamsReqHandler = this.m_secDefOptParamsReqMap.get(n);
        if (iSecDefOptParamsReqHandler != null) {
            iSecDefOptParamsReqHandler.securityDefinitionOptionalParameterEnd(n);
        }
    }

    public void reqSoftDollarTiers(ISoftDollarTiersReqHandler iSoftDollarTiersReqHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_softDollarTiersReqMap.put(n, iSoftDollarTiersReqHandler);
        this.m_client.reqSoftDollarTiers(n);
        this.sendEOM();
    }

    @Override
    public void softDollarTiers(int n, SoftDollarTier[] softDollarTierArray) {
        ISoftDollarTiersReqHandler iSoftDollarTiersReqHandler = this.m_softDollarTiersReqMap.get(n);
        if (iSoftDollarTiersReqHandler != null) {
            iSoftDollarTiersReqHandler.softDollarTiers(softDollarTierArray);
        }
    }

    public void reqFamilyCodes(IFamilyCodesHandler iFamilyCodesHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_familyCodesHandlers.add(iFamilyCodesHandler);
        this.m_client.reqFamilyCodes();
        this.sendEOM();
    }

    @Override
    public void familyCodes(FamilyCode[] familyCodeArray) {
        for (IFamilyCodesHandler iFamilyCodesHandler : this.m_familyCodesHandlers) {
            iFamilyCodesHandler.familyCodes(familyCodeArray);
        }
        this.recEOM();
    }

    public void reqMatchingSymbols(String string, ISymbolSamplesHandler iSymbolSamplesHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_symbolSamplesHandlerMap.put(n, iSymbolSamplesHandler);
        this.m_client.reqMatchingSymbols(n, string);
        this.sendEOM();
    }

    @Override
    public void symbolSamples(int n, ContractDescription[] contractDescriptionArray) {
        ISymbolSamplesHandler iSymbolSamplesHandler = this.m_symbolSamplesHandlerMap.get(n);
        if (iSymbolSamplesHandler != null) {
            iSymbolSamplesHandler.symbolSamples(contractDescriptionArray);
        }
        this.recEOM();
    }

    @Override
    public void historicalDataEnd(int n, String string, String string2) {
        IHistoricalDataHandler iHistoricalDataHandler = this.m_historicalDataMap.get(n);
        if (iHistoricalDataHandler != null) {
            iHistoricalDataHandler.historicalDataEnd();
        }
    }

    public void reqMktDepthExchanges(IMktDepthExchangesHandler iMktDepthExchangesHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_mktDepthExchangesHandlers.add(iMktDepthExchangesHandler);
        this.m_client.reqMktDepthExchanges();
        this.sendEOM();
    }

    @Override
    public void mktDepthExchanges(DepthMktDataDescription[] depthMktDataDescriptionArray) {
        for (IMktDepthExchangesHandler iMktDepthExchangesHandler : this.m_mktDepthExchangesHandlers) {
            iMktDepthExchangesHandler.mktDepthExchanges(depthMktDataDescriptionArray);
        }
        this.recEOM();
    }

    public void reqNewsTicks(Contract contract, ITickNewsHandler iTickNewsHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_tickNewsHandlerMap.put(n, iTickNewsHandler);
        this.m_client.reqMktData(n, contract, "mdoff,292", false, false, Collections.emptyList());
        this.sendEOM();
    }

    @Override
    public void tickNews(int n, long l, String string, String string2, String string3, String string4) {
        ITickNewsHandler iTickNewsHandler = this.m_tickNewsHandlerMap.get(n);
        if (iTickNewsHandler != null) {
            iTickNewsHandler.tickNews(l, string, string2, string3, string4);
        }
        this.recEOM();
    }

    @Override
    public void smartComponents(int n, Map<Integer, Map.Entry<String, Character>> map) {
        ISmartComponentsHandler iSmartComponentsHandler = this.m_smartComponentsHandler.get(n);
        if (iSmartComponentsHandler != null) {
            iSmartComponentsHandler.smartComponents(n, map);
        }
    }

    public void reqSmartComponents(String string, ISmartComponentsHandler iSmartComponentsHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_smartComponentsHandler.put(n, iSmartComponentsHandler);
        this.m_client.reqSmartComponents(n, string);
        this.sendEOM();
    }

    @Override
    public void tickReqParams(int n, double d, String string, int n2) {
        ITopMktDataHandler iTopMktDataHandler = this.m_topMktDataMap.get(n);
        if (iTopMktDataHandler != null) {
            iTopMktDataHandler.tickReqParams(n, d, string, n2);
        }
        this.recEOM();
    }

    public void reqNewsProviders(INewsProvidersHandler iNewsProvidersHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_newsProvidersHandlers.add(iNewsProvidersHandler);
        this.m_client.reqNewsProviders();
        this.sendEOM();
    }

    @Override
    public void newsProviders(NewsProvider[] newsProviderArray) {
        for (INewsProvidersHandler iNewsProvidersHandler : this.m_newsProvidersHandlers) {
            iNewsProvidersHandler.newsProviders(newsProviderArray);
        }
        this.recEOM();
    }

    public void reqNewsArticle(String string, String string2, INewsArticleHandler iNewsArticleHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_newsArticleHandlerMap.put(n, iNewsArticleHandler);
        this.m_client.reqNewsArticle(n, string, string2, Collections.emptyList());
        this.sendEOM();
    }

    @Override
    public void newsArticle(int n, int n2, String string) {
        INewsArticleHandler iNewsArticleHandler = this.m_newsArticleHandlerMap.get(n);
        if (iNewsArticleHandler != null) {
            iNewsArticleHandler.newsArticle(n2, string);
        }
        this.recEOM();
    }

    public void reqHistoricalNews(int n, String string, String string2, String string3, int n2, IHistoricalNewsHandler iHistoricalNewsHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n3 = this.m_reqId++;
        this.m_historicalNewsHandlerMap.put(n3, iHistoricalNewsHandler);
        this.m_client.reqHistoricalNews(n3, n, string, string2, string3, n2, Collections.emptyList());
        this.sendEOM();
    }

    @Override
    public void historicalNews(int n, String string, String string2, String string3, String string4) {
        IHistoricalNewsHandler iHistoricalNewsHandler = this.m_historicalNewsHandlerMap.get(n);
        if (iHistoricalNewsHandler != null) {
            iHistoricalNewsHandler.historicalNews(string, string2, string3, string4);
        }
        this.recEOM();
    }

    @Override
    public void historicalNewsEnd(int n, boolean bl) {
        IHistoricalNewsHandler iHistoricalNewsHandler = this.m_historicalNewsHandlerMap.get(n);
        if (iHistoricalNewsHandler != null) {
            iHistoricalNewsHandler.historicalNewsEnd(bl);
        }
        this.recEOM();
    }

    public void reqHeadTimestamp(Contract contract, Types.WhatToShow whatToShow, boolean bl, IHeadTimestampHandler iHeadTimestampHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_headTimestampMap.put(n, iHeadTimestampHandler);
        this.m_client.reqHeadTimestamp(n, contract, whatToShow.toString(), bl ? 1 : 0, 2);
    }

    @Override
    public void headTimestamp(int n, String string) {
        IHeadTimestampHandler iHeadTimestampHandler = this.m_headTimestampMap.get(n);
        if (iHeadTimestampHandler != null) {
            iHeadTimestampHandler.headTimestamp(n, Long.parseLong(string));
        }
        this.recEOM();
    }

    public void reqHistogramData(Contract contract, int n, Types.DurationUnit durationUnit, boolean bl, IHistogramDataHandler iHistogramDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        String string = n + " " + durationUnit.toString().toLowerCase() + "s";
        this.m_histogramDataMap.put(n2, iHistogramDataHandler);
        this.m_client.reqHistogramData(n2, contract, bl, string);
    }

    public void cancelHistogramData(IHistogramDataHandler iHistogramDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_histogramDataMap, iHistogramDataHandler);
        if (n != null) {
            this.m_client.cancelHistogramData(n);
            this.sendEOM();
        }
    }

    @Override
    public void histogramData(int n, List<HistogramEntry> list) {
        IHistogramDataHandler iHistogramDataHandler = this.m_histogramDataMap.get(n);
        if (iHistogramDataHandler != null) {
            iHistogramDataHandler.histogramData(n, list);
        }
        this.recEOM();
    }

    @Override
    public void historicalDataUpdate(int n, com.ib.client.Bar bar) {
        this.historicalData(n, bar);
    }

    @Override
    public void rerouteMktDataReq(int n, int n2, String string) {
        this.show("Re-route market data request. ReqId: " + n + ", ConId: " + n2 + ", Exchange: " + string);
    }

    @Override
    public void rerouteMktDepthReq(int n, int n2, String string) {
        this.show("Re-route market depth request. ReqId: " + n + ", ConId: " + n2 + ", Exchange: " + string);
    }

    public void reqMarketRule(int n, IMarketRuleHandler iMarketRuleHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_marketRuleHandlers.add(iMarketRuleHandler);
        this.m_client.reqMarketRule(n);
        this.sendEOM();
    }

    @Override
    public void marketRule(int n, PriceIncrement[] priceIncrementArray) {
        for (IMarketRuleHandler iMarketRuleHandler : this.m_marketRuleHandlers) {
            iMarketRuleHandler.marketRule(n, priceIncrementArray);
        }
        this.recEOM();
    }

    public void reqPnL(String string, String string2, IPnLHandler iPnLHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_pnlMap.put(n, iPnLHandler);
        this.m_client.reqPnL(n, string, string2);
    }

    public void cancelPnL(IPnLHandler iPnLHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_pnlMap, iPnLHandler);
        if (n != null) {
            this.m_client.cancelPnL(n);
            this.sendEOM();
        }
    }

    @Override
    public void pnl(int n, double d, double d2, double d3) {
        IPnLHandler iPnLHandler = this.m_pnlMap.get(n);
        if (iPnLHandler != null) {
            iPnLHandler.pnl(n, d, d2, d3);
        }
        this.recEOM();
    }

    public void reqPnLSingle(String string, String string2, int n, IPnLSingleHandler iPnLSingleHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        this.m_pnlSingleMap.put(n2, iPnLSingleHandler);
        this.m_client.reqPnLSingle(n2, string, string2, n);
    }

    public void cancelPnLSingle(IPnLSingleHandler iPnLSingleHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_pnlSingleMap, iPnLSingleHandler);
        if (n != null) {
            this.m_client.cancelPnLSingle(n);
            this.sendEOM();
        }
    }

    @Override
    public void pnlSingle(int n, Decimal decimal, double d, double d2, double d3, double d4) {
        IPnLSingleHandler iPnLSingleHandler = this.m_pnlSingleMap.get(n);
        if (iPnLSingleHandler != null) {
            iPnLSingleHandler.pnlSingle(n, decimal, d, d2, d3, d4);
        }
        this.recEOM();
    }

    public void reqHistoricalTicks(Contract contract, String string, String string2, int n, String string3, int n2, boolean bl, IHistoricalTickHandler iHistoricalTickHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n3 = this.m_reqId++;
        this.m_historicalTicksMap.put(n3, iHistoricalTickHandler);
        this.m_client.reqHistoricalTicks(n3, contract, string, string2, n, string3, n2, bl, Collections.emptyList());
    }

    @Override
    public void historicalTicks(int n, List<HistoricalTick> list, boolean bl) {
        ITickByTickDataHandler iTickByTickDataHandler;
        IHistoricalTickHandler iHistoricalTickHandler = this.m_historicalTicksMap.get(n);
        if (iHistoricalTickHandler != null) {
            iHistoricalTickHandler.historicalTick(n, list);
        }
        if ((iTickByTickDataHandler = this.m_tickByTickDataMap.get(n)) != null) {
            iTickByTickDataHandler.tickByTickHistoricalTick(n, list);
        }
        this.recEOM();
    }

    @Override
    public void historicalTicksBidAsk(int n, List<HistoricalTickBidAsk> list, boolean bl) {
        ITickByTickDataHandler iTickByTickDataHandler;
        IHistoricalTickHandler iHistoricalTickHandler = this.m_historicalTicksMap.get(n);
        if (iHistoricalTickHandler != null) {
            iHistoricalTickHandler.historicalTickBidAsk(n, list);
        }
        if ((iTickByTickDataHandler = this.m_tickByTickDataMap.get(n)) != null) {
            iTickByTickDataHandler.tickByTickHistoricalTickBidAsk(n, list);
        }
        this.recEOM();
    }

    @Override
    public void historicalTicksLast(int n, List<HistoricalTickLast> list, boolean bl) {
        ITickByTickDataHandler iTickByTickDataHandler;
        IHistoricalTickHandler iHistoricalTickHandler = this.m_historicalTicksMap.get(n);
        if (iHistoricalTickHandler != null) {
            iHistoricalTickHandler.historicalTickLast(n, list);
        }
        if ((iTickByTickDataHandler = this.m_tickByTickDataMap.get(n)) != null) {
            iTickByTickDataHandler.tickByTickHistoricalTickAllLast(n, list);
        }
        this.recEOM();
    }

    public void reqTickByTickData(Contract contract, String string, int n, boolean bl, ITickByTickDataHandler iTickByTickDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        this.m_tickByTickDataMap.put(n2, iTickByTickDataHandler);
        this.m_client.reqTickByTickData(n2, contract, string, n, bl);
        this.sendEOM();
    }

    public void cancelTickByTickData(ITickByTickDataHandler iTickByTickDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_tickByTickDataMap, iTickByTickDataHandler);
        if (n != null) {
            this.m_client.cancelTickByTickData(n);
            this.sendEOM();
        }
    }

    @Override
    public void tickByTickAllLast(int n, int n2, long l, double d, Decimal decimal, TickAttribLast tickAttribLast, String string, String string2) {
        ITickByTickDataHandler iTickByTickDataHandler = this.m_tickByTickDataMap.get(n);
        if (iTickByTickDataHandler != null) {
            iTickByTickDataHandler.tickByTickAllLast(n, n2, l, d, decimal, tickAttribLast, string, string2);
        }
        this.recEOM();
    }

    @Override
    public void tickByTickBidAsk(int n, long l, double d, double d2, Decimal decimal, Decimal decimal2, TickAttribBidAsk tickAttribBidAsk) {
        ITickByTickDataHandler iTickByTickDataHandler = this.m_tickByTickDataMap.get(n);
        if (iTickByTickDataHandler != null) {
            iTickByTickDataHandler.tickByTickBidAsk(n, l, d, d2, decimal, decimal2, tickAttribBidAsk);
        }
        this.recEOM();
    }

    @Override
    public void tickByTickMidPoint(int n, long l, double d) {
        ITickByTickDataHandler iTickByTickDataHandler = this.m_tickByTickDataMap.get(n);
        if (iTickByTickDataHandler != null) {
            iTickByTickDataHandler.tickByTickMidPoint(n, l, d);
        }
        this.recEOM();
    }

    @Override
    public void orderBound(long l, int n, int n2) {
        this.show("Order bound. OrderId: " + l + ", apiClientId: " + n + ", apiOrderId: " + n2);
    }

    public void reqCompletedOrders(ICompletedOrdersHandler iCompletedOrdersHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_completedOrdersHandler = iCompletedOrdersHandler;
        this.m_client.reqCompletedOrders(false);
        this.sendEOM();
    }

    @Override
    public void completedOrder(Contract contract, Order order, OrderState orderState) {
        if (this.m_completedOrdersHandler != null) {
            this.m_completedOrdersHandler.completedOrder(contract, order, orderState);
        }
        this.recEOM();
    }

    @Override
    public void completedOrdersEnd() {
        if (this.m_completedOrdersHandler != null) {
            this.m_completedOrdersHandler.completedOrdersEnd();
        }
        this.recEOM();
    }

    public void reqWshMetaData(IWshMetaDataHandler iWshMetaDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_wshMetaDataMap.put(n, iWshMetaDataHandler);
        this.m_client.reqWshMetaData(n);
        this.sendEOM();
    }

    public void cancelWshMetaData(IWshMetaDataHandler iWshMetaDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_wshMetaDataMap, iWshMetaDataHandler);
        if (n != null) {
            this.m_client.cancelWshMetaData(n);
            this.sendEOM();
        }
    }

    @Override
    public void wshMetaData(int n, String string) {
        IWshMetaDataHandler iWshMetaDataHandler = this.m_wshMetaDataMap.get(n);
        if (iWshMetaDataHandler != null) {
            iWshMetaDataHandler.wshMetaData(n, string);
        }
        this.recEOM();
    }

    public void reqWshEventData(WshEventData wshEventData, IWshEventDataHandler iWshEventDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n = this.m_reqId++;
        this.m_wshEventDataMap.put(n, iWshEventDataHandler);
        this.m_client.reqWshEventData(n, wshEventData);
        this.sendEOM();
    }

    public void cancelWshEventData(IWshEventDataHandler iWshEventDataHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_wshEventDataMap, iWshEventDataHandler);
        if (n != null) {
            this.m_client.cancelWshMetaData(n);
            this.sendEOM();
        }
    }

    @Override
    public void wshEventData(int n, String string) {
        IWshEventDataHandler iWshEventDataHandler = this.m_wshEventDataMap.get(n);
        if (iWshEventDataHandler != null) {
            iWshEventDataHandler.wshEventData(n, string);
        }
        this.recEOM();
    }

    public void reqHistoricalSchedule(Contract contract, String string, int n, Types.DurationUnit durationUnit, boolean bl, IHistoricalScheduleHandler iHistoricalScheduleHandler) {
        if (!this.checkConnection()) {
            return;
        }
        int n2 = this.m_reqId++;
        this.m_historicalScheduleMap.put(n2, iHistoricalScheduleHandler);
        String string2 = n + " " + durationUnit.toString().charAt(0);
        this.m_client.reqHistoricalData(n2, contract, string, string2, Types.BarSize._1_day.toString(), Types.WhatToShow.SCHEDULE.name(), bl ? 1 : 0, 2, false, Collections.emptyList());
        this.sendEOM();
    }

    public void cancelHistoricalSchedule(IHistoricalScheduleHandler iHistoricalScheduleHandler) {
        if (!this.checkConnection()) {
            return;
        }
        Integer n = ApiController.getAndRemoveKey(this.m_historicalScheduleMap, iHistoricalScheduleHandler);
        if (n != null) {
            this.m_client.cancelHistoricalData(n);
            this.sendEOM();
        }
    }

    @Override
    public void historicalSchedule(int n, String string, String string2, String string3, List<HistoricalSession> list) {
        IHistoricalScheduleHandler iHistoricalScheduleHandler = this.m_historicalScheduleMap.get(n);
        if (iHistoricalScheduleHandler != null) {
            iHistoricalScheduleHandler.historicalSchedule(n, string, string2, string3, list);
        }
        this.recEOM();
    }

    public void reqUserInfo(int n, IUserInfoHandler iUserInfoHandler) {
        if (!this.checkConnection()) {
            return;
        }
        this.m_userInfoHandler = iUserInfoHandler;
        this.m_client.reqUserInfo(n);
        this.sendEOM();
    }

    @Override
    public void userInfo(int n, String string) {
        this.m_userInfoHandler.userInfo(n, string);
        this.recEOM();
    }

    public static interface IUserInfoHandler {
        public void userInfo(int var1, String var2);
    }

    public static interface IHistoricalScheduleHandler {
        public void historicalSchedule(int var1, String var2, String var3, String var4, List<HistoricalSession> var5);
    }

    public static interface IWshEventDataHandler {
        public void wshEventData(int var1, String var2);
    }

    public static interface IWshMetaDataHandler {
        public void wshMetaData(int var1, String var2);
    }

    public static interface ICompletedOrdersHandler {
        public void completedOrder(Contract var1, Order var2, OrderState var3);

        public void completedOrdersEnd();
    }

    public static interface ITickByTickDataHandler {
        public void tickByTickAllLast(int var1, int var2, long var3, double var5, Decimal var7, TickAttribLast var8, String var9, String var10);

        public void tickByTickBidAsk(int var1, long var2, double var4, double var6, Decimal var8, Decimal var9, TickAttribBidAsk var10);

        public void tickByTickMidPoint(int var1, long var2, double var4);

        public void tickByTickHistoricalTickAllLast(int var1, List<HistoricalTickLast> var2);

        public void tickByTickHistoricalTickBidAsk(int var1, List<HistoricalTickBidAsk> var2);

        public void tickByTickHistoricalTick(int var1, List<HistoricalTick> var2);
    }

    public static interface IHistoricalTickHandler {
        public void historicalTick(int var1, List<HistoricalTick> var2);

        public void historicalTickBidAsk(int var1, List<HistoricalTickBidAsk> var2);

        public void historicalTickLast(int var1, List<HistoricalTickLast> var2);
    }

    public static interface IPnLSingleHandler {
        public void pnlSingle(int var1, Decimal var2, double var3, double var5, double var7, double var9);
    }

    public static interface IPnLHandler {
        public void pnl(int var1, double var2, double var4, double var6);
    }

    public static interface IMarketRuleHandler {
        public void marketRule(int var1, PriceIncrement[] var2);
    }

    public static interface IHistogramDataHandler {
        public void histogramData(int var1, List<HistogramEntry> var2);
    }

    public static interface IHeadTimestampHandler {
        public void headTimestamp(int var1, long var2);
    }

    public static interface IHistoricalNewsHandler {
        public void historicalNews(String var1, String var2, String var3, String var4);

        public void historicalNewsEnd(boolean var1);
    }

    public static interface INewsArticleHandler {
        public void newsArticle(int var1, String var2);
    }

    public static interface INewsProvidersHandler {
        public void newsProviders(NewsProvider[] var1);
    }

    public static interface ISmartComponentsHandler {
        public void smartComponents(int var1, Map<Integer, Map.Entry<String, Character>> var2);
    }

    public static interface ITickNewsHandler {
        public void tickNews(long var1, String var3, String var4, String var5, String var6);
    }

    public static interface IMktDepthExchangesHandler {
        public void mktDepthExchanges(DepthMktDataDescription[] var1);
    }

    public static interface ISymbolSamplesHandler {
        public void symbolSamples(ContractDescription[] var1);
    }

    public static interface IFamilyCodesHandler {
        public void familyCodes(FamilyCode[] var1);
    }

    public static interface ISoftDollarTiersReqHandler {
        public void softDollarTiers(SoftDollarTier[] var1);
    }

    public static interface ISecDefOptParamsReqHandler {
        public void securityDefinitionOptionalParameter(String var1, int var2, String var3, String var4, Set<String> var5, Set<Double> var6);

        public void securityDefinitionOptionalParameterEnd(int var1);
    }

    public static interface IAccountUpdateMultiHandler {
        public void accountUpdateMulti(String var1, String var2, String var3, String var4, String var5);

        public void accountUpdateMultiEnd();
    }

    public static interface IPositionMultiHandler {
        public void positionMulti(String var1, String var2, Contract var3, Decimal var4, double var5);

        public void positionMultiEnd();
    }

    public static interface IBulletinHandler {
        public void bulletin(int var1, Types.NewsType var2, String var3, String var4);
    }

    public static interface ITimeHandler {
        public void currentTime(long var1);
    }

    public static interface IFundamentalsHandler {
        public void fundamentals(String var1);
    }

    public static interface IRealTimeBarHandler {
        public void realtimeBar(Bar var1);
    }

    public static interface IHistoricalDataHandler {
        public void historicalData(Bar var1);

        public void historicalDataEnd();
    }

    public static interface IScannerHandler {
        public void scannerParameters(String var1);

        public void scannerData(int var1, ContractDetails var2, String var3);

        public void scannerDataEnd();
    }

    public static interface ILiveOrderHandler {
        public void openOrder(Contract var1, Order var2, OrderState var3);

        public void openOrderEnd();

        public void orderStatus(int var1, OrderStatus var2, Decimal var3, Decimal var4, double var5, int var7, int var8, double var9, int var11, String var12, double var13);

        public void handle(int var1, int var2, String var3);
    }

    public static interface IOrderCancelHandler {
        public void orderStatus(String var1);

        public void handle(int var1, String var2);
    }

    public static interface IOrderHandler {
        public void orderState(OrderState var1);

        public void orderStatus(OrderStatus var1, Decimal var2, Decimal var3, double var4, int var6, int var7, double var8, int var10, String var11, double var12);

        public void handle(int var1, String var2);
    }

    public static interface IAdvisorHandler {
        public void groups(List<Group> var1);

        public void profiles(List<Profile> var1);

        public void aliases(List<Alias> var1);

        public void updateGroupsEnd(String var1);

        public void updateProfilesEnd(String var1);
    }

    public static interface ITradeReportHandler {
        public void tradeReport(String var1, Contract var2, Execution var3);

        public void tradeReportEnd();

        public void commissionReport(String var1, CommissionReport var2);
    }

    public static interface IDeepMktDataHandler {
        public void updateMktDepth(int var1, String var2, Types.DeepType var3, Types.DeepSide var4, double var5, Decimal var7);
    }

    public static class TopMktDataAdapter
    implements ITopMktDataHandler {
        @Override
        public void tickPrice(TickType tickType, double d, TickAttrib tickAttrib) {
        }

        @Override
        public void tickSize(TickType tickType, Decimal decimal) {
        }

        @Override
        public void tickString(TickType tickType, String string) {
        }

        @Override
        public void tickSnapshotEnd() {
        }

        @Override
        public void marketDataType(int n) {
        }

        @Override
        public void tickReqParams(int n, double d, String string, int n2) {
        }
    }

    public static interface IOptHandler
    extends ITopMktDataHandler {
        public void tickOptionComputation(TickType var1, int var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17);
    }

    public static interface IEfpHandler
    extends ITopMktDataHandler {
        public void tickEFP(int var1, double var2, String var4, double var5, int var7, String var8, double var9, double var11);
    }

    public static interface ITopMktDataHandler {
        public void tickPrice(TickType var1, double var2, TickAttrib var4);

        public void tickSize(TickType var1, Decimal var2);

        public void tickString(TickType var1, String var2);

        public void tickSnapshotEnd();

        public void marketDataType(int var1);

        public void tickReqParams(int var1, double var2, String var4, int var5);
    }

    private static interface IInternalHandler {
        public void contractDetails(ContractDetails var1);

        public void contractDetailsEnd();
    }

    public static interface IContractDetailsHandler {
        public void contractDetails(List<ContractDetails> var1);
    }

    public static interface IPositionHandler {
        public void position(String var1, Contract var2, Decimal var3, double var4);

        public void positionEnd();
    }

    public static interface IMarketValueSummaryHandler {
        public void marketValueSummary(String var1, MarketValueTag var2, String var3, String var4);

        public void marketValueSummaryEnd();
    }

    public static interface IAccountSummaryHandler {
        public void accountSummary(String var1, AccountSummaryTag var2, String var3, String var4);

        public void accountSummaryEnd();
    }

    public static interface IAccountHandler {
        public void accountValue(String var1, String var2, String var3, String var4);

        public void accountTime(String var1);

        public void accountDownloadEnd(String var1);

        public void updatePortfolio(Position var1);
    }

    public static interface IConnectionHandler {
        public void connected();

        public void disconnected();

        public void accountList(List<String> var1);

        public void error(Exception var1);

        public void message(int var1, int var2, String var3, String var4);

        public void show(String var1);
    }
}

